/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextBreakIterator;
import com.adobe.xfa.text.TextCharProp;
import com.adobe.xfa.text.TextDisplay;
import com.adobe.xfa.text.TextEmbed;
import com.adobe.xfa.text.TextField;
import com.adobe.xfa.text.TextMarker;
import com.adobe.xfa.text.TextMarkupBase;
import com.adobe.xfa.text.TextNullFrame;
import com.adobe.xfa.text.TextRange;
import com.adobe.xfa.text.TextStream;
import com.adobe.xfa.text.TextStreamIterator;
import com.adobe.xfa.ut.UnitSpan;
import java.util.List;

public class TextPosnBase
extends TextMarkupBase {
    public static final int POSN_AFTER = 0;
    public static final int POSN_BEFORE = 1;
    public static final int AFFINITY_AFTER = 0;
    public static final int AFFINITY_BEFORE = 1;
    public static final int WORD_MODE_LEGACY = 0;
    public static final int WORD_MODE_ALGORITHMIC = 1;
    public static final int WORD_MODE_LOCALE_SENSITIVE = 2;
    private static final int WHITE_SPACE_SPACE = 0;
    private static final int WHITE_SPACE_TEXT = 1;
    private static final int WHITE_SPACE_BREAK = 2;
    private static final int WHITE_SPACE_NOT_FOUND = 3;
    private static final int NW_START = 0;
    private static final int NW_START_BREAK = 1;
    private static final int NW_START_WORD = 2;
    private static final int NW_SPACES = 3;
    private static final int NW_DONE = 4;
    private static final int PW_START = 0;
    private static final int PW_START_SPACES = 1;
    private static final int PW_WORD = 2;
    private static final int PW_BREAK = 3;
    private static final int PW_DONE = 4;
    private static final int WB_SPACE = 0;
    private static final int WB_LETTER = 1;
    private static final int WB_OTHER = 2;
    TextStream mpoStream;
    int mnMajor;
    int mnMinor;
    int mnIndex;
    boolean mbIsBeforePosition;
    boolean mbIsPrevAffinity;
    boolean mbIsRTL;
    boolean mbIsMarkerPosition;
    boolean mbIsInvalid;
    boolean mbTightenPending;
    UnitSpan mpoTarget;
    private static final int[][] geLegacyNextWordState = new int[][]{{3, 2, 1}, {3, 4, 4}, {3, 2, 4}, {3, 4, 4}};
    private static final int[][] geLegacyPrevWordState = new int[][]{{1, 2, 3}, {1, 2, 3}, {4, 2, 4}};
    private static final boolean[][] gbWordBreak = new boolean[][]{{false, true, true}, {false, false, true}, {false, true, false}, {false, false, false}, {true, false, true}, {true, true, false}};

    public TextPosnBase() {
        this.initialize();
    }

    public TextPosnBase(TextPosnBase oSource) {
        this.initialize();
        this.copy(oSource);
    }

    public TextPosnBase(TextStream poNewStream, int nNewIndex, int eNewPosn) {
        if (this.initWithStream(poNewStream, eNewPosn)) {
            this.mpoStream.posnUpdateStreamLoc(this, nNewIndex);
        }
    }

    public TextPosnBase(TextStream poNewStream, int nNewIndex) {
        if (this.initWithStream(poNewStream, 0)) {
            this.mpoStream.posnUpdateStreamLoc(this, nNewIndex);
        }
    }

    public TextPosnBase(TextStream poNewStream) {
        if (this.initWithStream(poNewStream, 0)) {
            this.mpoStream.posnFirst(this);
        }
    }

    public void associate(TextStream poNewStream, int nNewIndex, int eNewPosn) {
        this.doAssociate(poNewStream, nNewIndex, eNewPosn);
    }

    public void associate(TextStream poNewStream, int nNewIndex) {
        this.doAssociate(poNewStream, nNewIndex, 0);
    }

    public void associate(TextStream poNewStream) {
        this.cleanupTarget();
        if (this.initWithStream(poNewStream, 0)) {
            this.mpoStream.posnFirst(this);
        }
    }

    public int index() {
        return this.mnIndex;
    }

    public void index(int nNewIndex) {
        if (this.mpoStream != null && nNewIndex != this.mnIndex) {
            this.mpoStream.posnUpdateStreamLoc(this, nNewIndex);
        }
    }

    public int position() {
        return this.mbIsBeforePosition ? 1 : 0;
    }

    public void position(int ePosition) {
        this.mbIsBeforePosition = ePosition == 1;
    }

    public int affinity() {
        return this.mbIsPrevAffinity ? 1 : 0;
    }

    public void affinity(int eAffinity) {
        this.mbIsPrevAffinity = eAffinity == 1;
    }

    public boolean isRTL() {
        return this.mbIsRTL;
    }

    public void setRTL(boolean bRTL) {
        this.mbIsRTL = bRTL;
    }

    public void enumerateMarkers(List<TextMarker> oMarkers, boolean bPositionMarkers, boolean bRangeMarkers) {
        if (this.mpoStream != null) {
            this.mpoStream.rangeEnumMarker(this, this, oMarkers, bPositionMarkers, bRangeMarkers, false);
        }
    }

    public void first(boolean bVisual) {
        if (this.mpoStream != null) {
            this.mpoStream.posnFirst(this);
        }
        if (bVisual) {
            this.start(true);
        }
    }

    public void first() {
        this.first(false);
    }

    public void last(boolean bVisual) {
        if (this.mpoStream != null) {
            this.mpoStream.posnUpdateStreamLoc(this, this.mpoStream.posnCount());
        }
        if (bVisual) {
            this.end(true);
        }
    }

    public void last() {
        this.last(false);
    }

    public int next(boolean bTestOnly) {
        return this.next(0, bTestOnly);
    }

    public int next(int eNullFrameMode) {
        return this.next(eNullFrameMode, false);
    }

    public int next() {
        return this.next(false);
    }

    public int next(int eNullFrameMode, boolean bTestOnly) {
        int[] result = this.nextData(eNullFrameMode, bTestOnly);
        if (result == null) {
            return 0;
        }
        return result[0];
    }

    public int[] nextData(boolean bTestOnly) {
        return this.nextData(0, bTestOnly);
    }

    public int prev(boolean bTestOnly) {
        return this.prev(0, bTestOnly);
    }

    public int prev(int eNullFrameMode) {
        return this.prev(eNullFrameMode, false);
    }

    public int prev() {
        return this.prev(false);
    }

    public int prev(int eNullFrameMode, boolean bTestOnly) {
        int[] result = this.prevData(eNullFrameMode, bTestOnly);
        if (result == null) {
            return 0;
        }
        return result[0];
    }

    public int[] prevData(boolean bTestOnly) {
        return this.prevData(0, bTestOnly);
    }

    public int nextChar(boolean bTestOnly) {
        if (this.mpoStream == null) {
            return 0;
        }
        return this.mpoStream.posnNextChar(this, bTestOnly);
    }

    public int nextChar() {
        return this.nextChar(false);
    }

    public int prevChar(boolean bTestOnly) {
        if (this.mpoStream == null) {
            return 0;
        }
        return this.mpoStream.posnPrevChar(this, bTestOnly);
    }

    public int prevChar() {
        return this.nextChar(false);
    }

    public TextField nextField(boolean bTestOnly) {
        if (this.mpoStream == null) {
            return null;
        }
        return this.mpoStream.posnNextField(this, bTestOnly);
    }

    public TextField nextField() {
        return this.nextField(false);
    }

    public TextField prevField(boolean bTestOnly) {
        if (this.mpoStream == null) {
            return null;
        }
        return this.mpoStream.posnPrevField(this, bTestOnly);
    }

    public TextField prevField() {
        return this.prevField(false);
    }

    public TextEmbed nextEmbed(boolean bTestOnly) {
        if (this.mpoStream == null) {
            return null;
        }
        return this.mpoStream.posnNextEmbed(this, bTestOnly);
    }

    public TextEmbed nextEmbed() {
        return this.nextEmbed(false);
    }

    public TextEmbed prevEmbed(boolean bTestOnly) {
        if (this.mpoStream == null) {
            return null;
        }
        return this.mpoStream.posnPrevEmbed(this, bTestOnly);
    }

    public TextEmbed prevEmbed() {
        return this.prevEmbed(false);
    }

    public TextAttr nextAttr(boolean bTestOnly) {
        if (this.mpoStream == null) {
            return null;
        }
        return this.mpoStream.posnNextAttr(this, bTestOnly);
    }

    public TextAttr nextAttr() {
        return this.nextAttr(false);
    }

    public TextAttr prevAttr(boolean bTestOnly) {
        if (this.mpoStream == null) {
            return null;
        }
        return this.mpoStream.posnPrevAttr(this, bTestOnly);
    }

    public TextAttr prevAttr() {
        return this.prevAttr(false);
    }

    public boolean nextUserPosn(boolean bVisual) {
        int[] result = this.nextUserPosnTypeData(bVisual);
        return result != null && result[0] != 0;
    }

    public boolean nextUserPosn() {
        return this.nextUserPosn(false);
    }

    public boolean prevUserPosn(boolean bVisual) {
        int[] result = this.prevUserPosnTypeData(bVisual);
        return result != null && result[0] != 0;
    }

    public boolean prevUserPosn() {
        return this.prevUserPosn(false);
    }

    public int nextUserPosnType(boolean bVisual) {
        return this.nextUserPosnType(0, bVisual);
    }

    public int nextUserPosnType() {
        return this.nextUserPosnType(false);
    }

    public int nextUserPosnType(int eNullFrameMode) {
        return this.nextUserPosnType(eNullFrameMode, false);
    }

    public int nextUserPosnType(int eNullFrameMode, boolean bVisual) {
        int[] result = this.nextUserPosnTypeData(eNullFrameMode, bVisual);
        if (result == null) {
            return 0;
        }
        return result[0];
    }

    public int[] nextUserPosnTypeData(boolean bVisual) {
        return this.nextUserPosnTypeData(0, bVisual);
    }

    public int prevUserPosnType(boolean bVisual) {
        return this.prevUserPosnType(0, bVisual);
    }

    public int prevUserPosnType() {
        return this.prevUserPosnType(false);
    }

    public int prevUserPosnType(int eNullFrameMode) {
        return this.prevUserPosnType(eNullFrameMode, false);
    }

    public int prevUserPosnType(int eNullFrameMode, boolean bVisual) {
        int[] result = this.prevUserPosnTypeData(eNullFrameMode, bVisual);
        if (result == null) {
            return 0;
        }
        return result[0];
    }

    public int[] prevUserPosnTypeData(boolean bVisual) {
        return this.prevUserPosnTypeData(0, bVisual);
    }

    public boolean nextWord(boolean bVisual, int eWordMode) {
        if (eWordMode == 0) {
            int eItem;
            boolean bMoved = false;
            int eState = 0;
            while ((eItem = this.nextUserPosnWhiteSpace(bVisual)) != 3) {
                if ((eState = geLegacyNextWordState[eState][eItem]) == 4) {
                    this.prevUserPosn(bVisual);
                    break;
                }
                bMoved = true;
            }
            return bMoved;
        }
        return this.algorithmicMoveWord(true, false, bVisual);
    }

    public boolean nextWord(boolean bVisual) {
        return this.prevWord(bVisual, 0);
    }

    public boolean nextWord() {
        return this.prevWord(false, 0);
    }

    public boolean prevWord(boolean bVisual, int eWordMode) {
        if (eWordMode == 0) {
            int eItem;
            boolean bMoved = false;
            int eState = 0;
            while ((eItem = this.prevUserPosnWhiteSpace(bVisual)) != 3) {
                bMoved = true;
                if ((eState = geLegacyPrevWordState[eState][eItem]) == 4) {
                    this.nextUserPosn(bVisual);
                    break;
                }
                if (eState != 3) continue;
                break;
            }
            return bMoved;
        }
        return this.algorithmicMoveWord(false, false, bVisual);
    }

    public boolean prevWord(boolean bVisual) {
        return this.prevWord(bVisual, 0);
    }

    public boolean prevWord() {
        return this.prevWord(false, 0);
    }

    public boolean nextLine() {
        if (this.display() == null) {
            return false;
        }
        if (!this.down()) {
            if (!this.nextUserPosn()) {
                return false;
            }
            this.last();
        } else {
            this.start();
        }
        this.tighten(false);
        return true;
    }

    public boolean prevLine() {
        if (this.display() == null) {
            return false;
        }
        TextPosnBase oTemp = new TextPosnBase(this);
        if (!this.prevUserPosn()) {
            return false;
        }
        oTemp.start();
        if (this.lte(oTemp)) {
            this.start();
        } else {
            this.copyFrom(oTemp);
        }
        this.tighten(false);
        return true;
    }

    public boolean nextPara() {
        return this.nextPara(0);
    }

    public boolean prevPara() {
        return this.prevPara(0);
    }

    public void wordStart(int eWordMode) {
        if (eWordMode == 0) {
            boolean bMoved = false;
            int eItem = this.prevUserPosnWhiteSpace();
            while (eItem == 1) {
                bMoved = true;
                eItem = this.prevUserPosnWhiteSpace();
            }
            if (eItem == 0 || eItem == 2 && bMoved) {
                this.nextUserPosn();
            }
        } else {
            this.algorithmicMoveWord(false, true, false);
        }
    }

    public void wordStart() {
        this.wordEnd(0);
    }

    public void wordEnd(int eWordMode) {
        if (eWordMode == 0) {
            boolean bMoved = false;
            int eItem = this.nextUserPosnWhiteSpace();
            while (eItem == 1) {
                bMoved = true;
                eItem = this.nextUserPosnWhiteSpace();
            }
            if (eItem == 0 || eItem == 2 && bMoved) {
                this.prevUserPosn();
            }
        } else {
            this.algorithmicMoveWord(true, true, false);
        }
    }

    public void wordEnd() {
        this.wordEnd(0);
    }

    public void paraStart() {
        int eItem = this.prevUserPosnType();
        while (eItem != 0 && eItem != 5) {
            eItem = this.prevUserPosnType();
        }
        if (eItem == 5) {
            this.nextUserPosn();
        }
    }

    public void paraEnd() {
        int eItem = this.nextUserPosnType();
        while (eItem != 0 && eItem != 5) {
            eItem = this.nextUserPosnType();
        }
        if (eItem == 5) {
            this.prevUserPosn();
        }
    }

    public boolean up() {
        TextDisplay poDisplay = this.display();
        if (poDisplay == null) {
            return false;
        }
        TextPosnBase oResult = new TextPosnBase();
        UnitSpan newTarget = poDisplay.caretUp(this, this.mpoTarget, oResult);
        if (newTarget == null) {
            return false;
        }
        this.copy(oResult);
        this.tighten(this.isAtStart());
        this.mpoTarget = newTarget;
        return true;
    }

    public boolean down() {
        TextDisplay poDisplay = this.display();
        if (poDisplay == null) {
            return false;
        }
        TextPosnBase oResult = new TextPosnBase();
        UnitSpan newTarget = poDisplay.caretDown(this, this.mpoTarget, oResult);
        if (newTarget == null) {
            return false;
        }
        this.copy(oResult);
        this.tighten(this.isAtStart());
        this.mpoTarget = newTarget;
        return true;
    }

    public boolean start(boolean bVisual) {
        TextDisplay poDisplay = this.display();
        if (poDisplay == null) {
            return false;
        }
        TextPosnBase oResult = new TextPosnBase();
        if (!poDisplay.caretStartEnd(this, false, bVisual, oResult)) {
            return false;
        }
        this.copy(oResult);
        this.tighten(false);
        return true;
    }

    public boolean start() {
        return this.start(false);
    }

    public boolean end(boolean bVisual) {
        TextDisplay poDisplay = this.display();
        if (poDisplay == null) {
            return false;
        }
        TextPosnBase oResult = new TextPosnBase();
        if (!poDisplay.caretStartEnd(this, true, bVisual, oResult)) {
            return false;
        }
        this.copy(oResult);
        this.tighten(false);
        return true;
    }

    public boolean end() {
        return this.end(false);
    }

    public boolean isAtStart(boolean bCheckFirstLineOnly) {
        TextDisplay poDisplay = this.display();
        if (poDisplay == null) {
            return false;
        }
        return false;
    }

    public boolean isAtStart() {
        return this.isAtStart(false);
    }

    public void tighten(boolean bSkipAhead) {
        if (bSkipAhead) {
            int eItem = this.next(1, true);
            while (eItem != 0 && !TextPosnBase.isUserPosnType(eItem)) {
                this.next();
                eItem = this.next(1, true);
            }
        } else {
            int eItem = this.prev(1, true);
            while (eItem != 0 && !TextPosnBase.isUserPosnType(eItem)) {
                this.prev();
                eItem = this.prev(1, true);
            }
            if (this.index() == 0) {
                this.tighten(true);
            }
        }
    }

    public int charPosition() {
        int cChar;
        TextPosnBase oPos = new TextPosnBase(this);
        int nResult = -1;
        do {
            ++nResult;
        } while ((cChar = oPos.prevChar()) != 0);
        return nResult;
    }

    public TextPosnBase charPosition(int nIndex) {
        TextPosnBase poResult = new TextPosnBase(this);
        int nCurrent = nIndex;
        if (nCurrent >= 0) {
            while (nCurrent > 0 && poResult.nextChar() != 0) {
                --nCurrent;
            }
        } else {
            while (nCurrent < 0 && poResult.prevChar() != 0) {
                ++nCurrent;
            }
        }
        return poResult;
    }

    public TextRange charRange(int lStart, int lLength) {
        TextPosnBase oStart = this.charPosition(lStart);
        TextRange poResult = new TextRange(this.mpoStream, oStart.index(), oStart.index());
        TextPosnBase oEnd = this.charPosition(lStart + lLength);
        poResult.end(oEnd.index());
        return poResult;
    }

    public void insert(char cInsert) {
        if (this.mpoStream != null) {
            this.mpoStream.posnInsert(this, cInsert);
        }
    }

    public void insert(String sInsert) {
        if (this.mpoStream != null) {
            this.mpoStream.posnInsert(this, sInsert);
        }
    }

    public void insert(TextStream oInsert) {
        if (this.mpoStream != null) {
            this.mpoStream.posnInsert(this, oInsert);
        }
    }

    public TextField insert(TextField poField) {
        if (this.mpoStream == null) {
            return null;
        }
        TextPosnBase oAnchor = new TextPosnBase(this);
        oAnchor.position(1);
        this.mpoStream.posnInsert(this, poField);
        return oAnchor.nextField(true);
    }

    public TextEmbed insert(TextEmbed poEmbed) {
        if (this.mpoStream == null) {
            return null;
        }
        TextPosnBase oAnchor = new TextPosnBase(this);
        oAnchor.position(1);
        this.mpoStream.posnInsert(this, poEmbed);
        return oAnchor.nextEmbed(true);
    }

    public void insertPara() {
        if (this.mpoStream != null) {
            this.mpoStream.posnInsertPara(this);
        }
    }

    public TextMarker insert(TextMarker poMarker) {
        return this.mpoStream == null ? null : this.mpoStream.posnMarker(this, poMarker);
    }

    public void deleteAhead(int nDelete, boolean bRaw) {
        if (this.mpoStream == null) {
            return;
        }
        if (!bRaw) {
            this.tighten(true);
            TextPosnBase oEnd = new TextPosnBase(this.stream(), this.index() + nDelete);
            TextPosnBase oBack = new TextPosnBase(oEnd);
            while (oBack.isCombiningChar(false)) {
                oBack.tighten(true);
                if (!oBack.lte(this)) continue;
            }
            if (oBack.gt(this)) {
                while (oEnd.isCombiningChar(true)) {
                }
                oEnd.tighten(false);
                nDelete = oEnd.index() - this.index();
            }
        }
        this.mpoStream.posnDelete(this, nDelete, bRaw);
        if (!bRaw) {
            this.tighten(this.isAtStart());
        }
    }

    public void deleteAhead(int nDelete) {
        this.deleteAhead(nDelete, false);
    }

    public void deleteAhead() {
        this.deleteAhead(1, false);
    }

    public void deleteBack(int nDelete, boolean bRaw) {
        if (this.mpoStream == null) {
            return;
        }
        int nActual = nDelete;
        if (bRaw) {
            if (nActual > this.mnIndex) {
                nActual = this.mnIndex;
            }
            this.index(this.mnIndex - nActual);
        } else {
            int nLeft;
            for (nLeft = nDelete; nLeft > 0 && this.prevUserPosn(); --nLeft) {
            }
            nActual -= nLeft;
        }
        this.deleteAhead(nActual, bRaw);
    }

    public void deleteBack(int nDelete) {
        this.deleteBack(nDelete, false);
    }

    public void deleteBack() {
        this.deleteBack(1, false);
    }

    @Override
    public TextAttr attributePtr() {
        if (this.mpoStream == null) {
            return null;
        }
        return this.mpoStream.posnAttrPtr(this);
    }

    public TextAttr attribute() {
        TextAttr poAttr = this.attributePtr();
        if (poAttr == null) {
            return TextAttr.defaultAttr(false);
        }
        return poAttr;
    }

    public void attribute(TextAttr oNewAttr, boolean bRaw) {
        if (this.mpoStream != null) {
            this.mpoStream.posnAttr(this, oNewAttr, bRaw);
        }
    }

    public final void attribute(TextAttr oNewAttr) {
        this.attribute(oNewAttr, false);
    }

    public void setKeyboard() {
    }

    public void copyFrom(TextPosnBase oSource) {
        this.copy(oSource);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        TextPosnBase posn = (TextPosnBase)object;
        return this.mpoStream == posn.mpoStream && this.mnIndex == posn.mnIndex;
    }

    public int hashCode() {
        int hash = 97;
        hash = hash * 31 ^ this.mpoStream.hashCode();
        hash = hash * 31 ^ this.mnIndex;
        return hash;
    }

    public boolean notEqual(TextPosnBase oCompare) {
        return !this.equals(oCompare);
    }

    public boolean lt(TextPosnBase oCompare) {
        return this.mnIndex < oCompare.mnIndex;
    }

    public boolean lte(TextPosnBase oCompare) {
        return this.mnIndex <= oCompare.mnIndex;
    }

    public boolean gt(TextPosnBase oCompare) {
        return this.mnIndex > oCompare.mnIndex;
    }

    public boolean gte(TextPosnBase oCompare) {
        return this.mnIndex >= oCompare.mnIndex;
    }

    @Override
    public void para() {
        this.insertPara();
    }

    @Override
    public void field(TextField poField) {
        this.insert(poField);
    }

    @Override
    public void text(String sText) {
        this.insert(sText);
    }

    @Override
    public void attr(TextAttr oAttr) {
        this.attribute(oAttr);
    }

    @Override
    public boolean legacyPositioning() {
        return this.mpoStream == null ? false : this.mpoStream.hasLegacyPositioning();
    }

    @Override
    public void marker(TextMarker poMarker) {
        this.insert(poMarker);
    }

    @Override
    public TextMarker markerStart(TextMarker poMarker) {
        return this.mpoStream == null ? null : this.mpoStream.posnMarkerStart(this, poMarker);
    }

    @Override
    public void markerEnd(TextMarker poMarker) {
        if (this.mpoStream != null) {
            this.mpoStream.posnMarkerEnd(this, poMarker);
        }
    }

    boolean isSamePosition(TextPosnBase oCompare) {
        return this.mpoStream == oCompare.mpoStream && this.mnIndex == oCompare.mnIndex;
    }

    public TextStream stream() {
        return this.mpoStream;
    }

    boolean isMarkerPosition() {
        return this.mbIsMarkerPosition;
    }

    void insertNullFrame(TextNullFrame poNullFrame) {
        if (this.mpoStream != null) {
            this.mpoStream.posnInsertNullFrame(this, poNullFrame);
        }
    }

    void removeNullFrame() {
        if (this.mpoStream != null) {
            this.mpoStream.posnRemoveNullFrame(this);
        }
    }

    void invalidate(boolean bTighten) {
        this.mbIsInvalid = true;
        this.mbTightenPending = bTighten;
    }

    void testValid() {
        if (this.mbIsInvalid) {
            this.validate();
        }
    }

    char charMove(boolean bForward, boolean bVisual) {
        int[] result = bForward ? this.nextUserPosnTypeData(bVisual) : this.prevUserPosnTypeData(bVisual);
        return result != null && result[0] != 0 ? (char)result[1] : (char)'\u0000';
    }

    int major() {
        this.testValid();
        return this.mnMajor;
    }

    int minor() {
        this.testValid();
        return this.mnMinor;
    }

    void copyData(TextPosnBase oSource) {
        if (this.mpoStream == oSource.mpoStream) {
            if (this.mpoStream != null) {
                this.copySameStream(oSource);
            }
        } else if (this.mpoStream != null) {
            this.index(oSource.index());
        }
    }

    int[] nextData(int eNullFrameMode, boolean bTestOnly) {
        if (this.mpoStream == null) {
            return null;
        }
        return this.mpoStream.posnNext(this, eNullFrameMode, bTestOnly);
    }

    int[] prevData(int eNullFrameMode, boolean bTestOnly) {
        if (this.mpoStream == null) {
            return null;
        }
        return this.mpoStream.posnPrev(this, eNullFrameMode, bTestOnly);
    }

    boolean nextPara(int eNullFrameMode) {
        int eItem = this.nextUserPosnType(eNullFrameMode);
        while (eItem != 0 && eItem != 5) {
            eItem = this.nextUserPosnType(eNullFrameMode);
        }
        return eItem == 5;
    }

    boolean prevPara(int eNullFrameMode) {
        boolean bMoved = false;
        int eItem = this.prevUserPosnType(eNullFrameMode);
        while (!(eItem == 0 || eItem == 5 && bMoved)) {
            bMoved = true;
            eItem = this.prevUserPosnType(eNullFrameMode);
        }
        if (eItem != 0) {
            this.nextUserPosn();
        }
        return bMoved;
    }

    int[] nextUserPosnTypeData(int eNullFrameMode, boolean bVisual) {
        if (bVisual) {
            return this.visualMoveData(true);
        }
        int[] result = this.nextData(eNullFrameMode, false);
        while (result != null && result[0] != 0 && !TextPosnBase.isUserPosnType(result[0])) {
            result = this.nextData(eNullFrameMode, false);
        }
        if (result == null) {
            return null;
        }
        int eReturn = result[0];
        int c = result[1];
        if (eReturn == 5 || eReturn == 2 && c == 10) {
            int[] skipAttrResult = this.nextData(eNullFrameMode, true);
            while (skipAttrResult != null && skipAttrResult[0] != 0 && !TextPosnBase.isUserPosnType(skipAttrResult[0])) {
                this.next(eNullFrameMode);
                skipAttrResult = this.nextData(eNullFrameMode, true);
            }
        } else if (eReturn != 2 || c < 12352 || c > 12543 || this.display() != null) {
            // empty if block
        }
        switch (eReturn) {
            case 5: {
                c = 10;
                break;
            }
            default: {
                c = 65532;
            }
        }
        result[0] = eReturn;
        result[1] = c;
        return result;
    }

    int[] prevUserPosnTypeData(int eNullFrameMode, boolean bVisual) {
        if (bVisual) {
            return this.visualMoveData(true);
        }
        int[] result = this.prevData(eNullFrameMode, false);
        while (result != null && result[0] != 0 && !TextPosnBase.isUserPosnType(result[0])) {
            result = this.prevData(eNullFrameMode, false);
        }
        if (result == null) {
            return null;
        }
        int eReturn = result[0];
        int c = result[1];
        if (eReturn != 5 && (eReturn != 2 || c != 10)) {
            if (eReturn != 2 || c != 12441 && c != 12442 || this.display() != null) {
                // empty if block
            }
            int[] skipAttrResult = this.prevData(eNullFrameMode, true);
            while (skipAttrResult != null && skipAttrResult[0] != 0 && !TextPosnBase.isUserPosnType(skipAttrResult[0])) {
                this.prev(eNullFrameMode);
                skipAttrResult = this.prevData(eNullFrameMode, true);
            }
            if (this.mnIndex == 0) {
                this.first();
            }
        }
        eReturn = result[0];
        c = (char)result[1];
        switch (eReturn) {
            case 5: {
                c = 10;
                break;
            }
            default: {
                c = 65532;
            }
        }
        result[0] = eReturn;
        result[1] = c;
        return result;
    }

    void setMarkerPosition(boolean bIsMarkerPosition) {
        this.mbIsMarkerPosition = bIsMarkerPosition;
    }

    private void doAssociate(TextStream poNewStream, int nNewIndex, int eNewPosn) {
        this.cleanupTarget();
        if (this.initWithStream(poNewStream, eNewPosn)) {
            this.mpoStream.posnUpdateStreamLoc(this, nNewIndex);
        }
    }

    private void copy(TextPosnBase oSource) {
        this.mpoStream = oSource.mpoStream;
        this.copySameStream(oSource);
    }

    private void copySameStream(TextPosnBase oSource) {
        this.mnMajor = oSource.mnMajor;
        this.mnMinor = oSource.mnMinor;
        this.mnIndex = oSource.mnIndex;
        this.mbIsBeforePosition = oSource.mbIsBeforePosition;
        this.mbIsPrevAffinity = oSource.mbIsPrevAffinity;
        this.mbIsRTL = oSource.mbIsRTL;
        this.mbIsMarkerPosition = oSource.mbIsMarkerPosition;
        this.mbIsInvalid = oSource.mbIsInvalid;
        this.mbTightenPending = oSource.mbTightenPending;
        this.cleanupTarget();
        if (oSource.mpoTarget != null) {
            this.mpoTarget = oSource.mpoTarget;
        }
    }

    private TextDisplay display() {
        if (this.mpoStream == null) {
            return null;
        }
        return this.mpoStream.display();
    }

    private void initialize() {
        this.mpoStream = null;
        this.mnMajor = 0;
        this.mnMinor = 0;
        this.mnIndex = 0;
        this.mbIsBeforePosition = false;
        this.mbIsPrevAffinity = false;
        this.mbIsRTL = false;
        this.mbIsMarkerPosition = false;
        this.mbIsInvalid = false;
        this.mbTightenPending = false;
        this.mpoTarget = null;
    }

    private boolean initWithStream(TextStream poNewStream, int eNewPosn) {
        this.initialize();
        this.position(eNewPosn);
        if (poNewStream == null) {
            return false;
        }
        this.mpoStream = poNewStream;
        return true;
    }

    void cleanup() {
        this.cleanupTarget();
        this.initialize();
    }

    void cleanupTarget() {
        this.mpoTarget = null;
    }

    private int[] visualMoveData(boolean bRight) {
        if (this.display() == null) {
            return null;
        }
        return null;
    }

    private void validate() {
        int nIndex = this.mnIndex;
        this.mnIndex = 0;
        this.mnMajor = 0;
        this.mnMinor = 0;
        if (this.mpoStream != null) {
            this.mpoStream.posnUpdateStreamLoc(this, nIndex);
        }
        if (this.mbTightenPending) {
            this.tighten(false);
            this.mbTightenPending = false;
        }
        this.mbIsInvalid = false;
    }

    private int nextUserPosnWhiteSpace(boolean bVisual) {
        int eItem = this.nextUserPosnType(bVisual);
        switch (eItem) {
            case 0: {
                return 3;
            }
            case 2: {
                return Character.isWhitespace((char)this.prevChar(true)) ? 0 : 1;
            }
            case 5: {
                return 0;
            }
        }
        return 2;
    }

    private int nextUserPosnWhiteSpace() {
        return this.nextUserPosnWhiteSpace(false);
    }

    private int prevUserPosnWhiteSpace(boolean bVisual) {
        int eItem = this.prevUserPosnType(bVisual);
        switch (eItem) {
            case 0: {
                return 3;
            }
            case 2: {
                return Character.isWhitespace((char)this.nextChar(true)) ? 0 : 1;
            }
            case 5: {
                return 0;
            }
        }
        return 2;
    }

    private int prevUserPosnWhiteSpace() {
        return this.prevUserPosnWhiteSpace(false);
    }

    private boolean algorithmicMoveWord(boolean bNext, boolean bLimitOnly, boolean bVisual) {
        int nIndex = this.index();
        char c = this.charMove(bNext, bVisual);
        if (c == '\u0000') {
            return false;
        }
        int eData = TextCharProp.getCharProperty(c);
        int nPrev = TextPosnBase.propertyToNextWordBreak(eData);
        this.index(nIndex);
        boolean bMoved = false;
        TextStreamIterator oStreamIterator = new TextStreamIterator(this, bNext, bVisual);
        TextBreakIterator poBreakIterator = TextBreakIterator.createWordInstance(oStreamIterator);
        int nRowOffset = bNext ? 0 : 3;
        nIndex = poBreakIterator.next();
        while (nIndex != Integer.MAX_VALUE) {
            bMoved = true;
            this.index(nIndex);
            c = this.charMove(bNext, bVisual);
            if (c == '\u0000') break;
            eData = TextCharProp.getCharProperty(c);
            int nNext = TextPosnBase.propertyToNextWordBreak(eData);
            if (bLimitOnly ? nPrev != nNext : gbWordBreak[nPrev + nRowOffset][nNext]) break;
            nPrev = nNext;
            nIndex = poBreakIterator.next();
        }
        if (nIndex != Integer.MAX_VALUE) {
            this.index(nIndex);
        }
        return bMoved;
    }

    private boolean isCombiningChar(boolean bForward) {
        int eItem;
        boolean bIsCombining = false;
        int n = eItem = bForward ? this.nextUserPosnType(1) : this.prevUserPosnType(1);
        if (eItem != 0) {
            int c;
            int eBreak;
            if (eItem == 2 && TextCharProp.getBreakClass(eBreak = TextCharProp.getCharProperty(c = bForward ? this.prevChar(true) : this.nextChar(true))) == 8) {
                bIsCombining = true;
            }
            if (!bIsCombining) {
                if (bForward) {
                    this.prevUserPosnType(1);
                } else {
                    this.nextUserPosnType(1);
                }
            }
        }
        return bIsCombining;
    }

    private static int propertyToNextWordBreak(int eData) {
        if (TextCharProp.getBreakClass(eData) == 31) {
            return 0;
        }
        if (TextCharProp.isWordEdge(eData)) {
            return 1;
        }
        return 2;
    }

    private static boolean isUserPosnType(int eItem) {
        return eItem != 1;
    }
}

