/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.font.FontInfo;
import com.adobe.xfa.font.FontInstance;
import com.adobe.xfa.font.FontService;
import com.adobe.xfa.gfx.GFXTextAttr;
import com.adobe.xfa.text.AttrCopy;
import com.adobe.xfa.text.Pkg;
import com.adobe.xfa.text.TextBaselineShift;
import com.adobe.xfa.text.TextGfxAttr;
import com.adobe.xfa.text.TextGfxSource;
import com.adobe.xfa.text.TextMeasurement;
import com.adobe.xfa.text.TextStream;
import com.adobe.xfa.text.TextTabList;
import com.adobe.xfa.text.Units;
import com.adobe.xfa.ut.LcData;
import com.adobe.xfa.ut.LcLocale;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.UnitSpan;

public class TextAttr
extends TextGfxAttr {
    public static final int JUST_V_UNKNOWN = 0;
    public static final int JUST_V_TOP = 1;
    public static final int JUST_V_MIDDLE = 2;
    public static final int JUST_V_BOTTOM = 3;
    public static final int JUST_H_UNKNOWN = 4;
    public static final int JUST_H_LEFT = 5;
    public static final int JUST_H_CENTRE = 6;
    public static final int JUST_H_RIGHT = 7;
    public static final int JUST_H_SPREAD = 8;
    public static final int JUST_H_SPREAD_ALL = 9;
    public static final int JUST_H_RADIX = 10;
    public static final int JUST_H_COMB_LEFT = 11;
    public static final int JUST_H_COMB_CENTRE = 12;
    public static final int JUST_H_COMB_RIGHT = 13;
    public static final int DIGITS_LOCALE = 0;
    public static final int DIGITS_ARABIC = 1;
    public static final int DIGITS_INDIC = 2;
    public static final int DIRECTION_NEUTRAL = 0;
    public static final int DIRECTION_LTR = 1;
    public static final int DIRECTION_RTL = 2;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL_LTR = 1;
    public static final int ORIENTATION_VERTICAL_RTL = 2;
    public static final int LIGATURE_MINIMUM = 0;
    public static final int LIGATURE_COMMON = 1;
    public static final int HYPHEN_OFF = 0;
    public static final int HYPHEN_PREFERRED = 1;
    public static final int HYPHEN_NORMAL = 2;
    public static final int HYPHEN_ALL = 3;
    public static final int LEADER_PATTERN_SPACE = 0;
    public static final int LEADER_PATTERN_RULE = 1;
    public static final int LEADER_PATTERN_DOTS = 2;
    public static final int LEADER_PATTERN_USE_CONTENT = 3;
    public static final int LEADER_ALIGN_NONE = 0;
    public static final int LEADER_ALIGN_PAGE = 1;
    public static final int RULE_STYLE_NONE = 0;
    public static final int RULE_STYLE_SOLID = 1;
    public static final int RULE_STYLE_DOTTED = 2;
    public static final int RULE_STYLE_DASHED = 3;
    public static final int DEFAULT_HYPH_LEVEL = 0;
    public static final int DEFAULT_HYPH_MIN_WORD = 7;
    public static final int DEFAULT_HYPH_MIN_PREFIX = 3;
    public static final int DEFAULT_HYPH_MIN_SUFFIX = 3;
    public static final int DEFAULT_HYPH_MAX_LINES = 2;
    public static final boolean DEFAULT_HYPH_SUPPRESS_NAMES = false;
    public static final boolean DEFAULT_HYPH_SUPPRESS_ACRONYMS = false;
    public static final int DEFAULT_LEADER_PATTERN = 0;
    public static final int DEFAULT_LEADER_ALIGN = 0;
    public static final int DEFAULT_RULE_STYLE = 1;
    private static final int UNIT_SPACING = 0;
    private static final int UNIT_MARGIN_L = 1;
    private static final int UNIT_MARGIN_R = 2;
    private static final int UNIT_RADIX_OFFSET = 3;
    private static final int UNIT_SPECIAL = 4;
    private static final int UNIT_SPACE_BEFORE = 5;
    private static final int UNIT_SPACE_AFTER = 6;
    private static final int UNIT_CHAR_SPACING = 7;
    private static final int UNIT_WORD_SPACING = 8;
    private static final int UNIT_LEADER_PATTERN_WIDTH = 9;
    private static final int UNIT_RULE_THICKNESS = 10;
    private static final int MAX_UNIT_INDEX = 11;
    private static final int INT_RADIX_POS = 0;
    private static final int INT_INVIS_CHAR = 1;
    private static final int INT_DIGITS = 2;
    private static final int INT_DIRECTION = 3;
    private static final int INT_PARA_DIRECTION = 4;
    private static final int INT_LAYOUT_ORIENTATION = 5;
    private static final int INT_LIGATURE = 6;
    private static final int INT_HYPH_LEVEL = 7;
    private static final int INT_HYPH_MIN_WORD = 8;
    private static final int INT_HYPH_MIN_PREFIX = 9;
    private static final int INT_HYPH_MIN_SUFFIX = 10;
    private static final int INT_HYPH_MAX_LINES = 11;
    private static final int INT_LEADER_PATTERN = 12;
    private static final int INT_LEADER_ALIGN = 13;
    private static final int INT_RULE_STYLE = 14;
    private static final int MAX_INT_INDEX = 15;
    private static final int BOOL_ITALIC = 0;
    private static final int BOOL_TRANSPARENT = 1;
    private static final int BOOL_INVISIBLE = 2;
    private static final int BOOL_KERNING = 3;
    private static final int BOOL_HYPH_SUPPRESS_NAMES = 4;
    private static final int BOOL_HYPH_SUPPRESS_ACRONYMS = 5;
    private static final int MAX_BOOL_INDEX = 6;
    private static final int FLOAT_HORIZONTAL_SCALE = 0;
    private static final int FLOAT_VERTICAL_SCALE = 1;
    private static final int MAX_FLOAT_INDEX = 2;
    private TextGfxSource moGfxSource;
    private AttrExtra mpoExtra;
    private FontInstance moFontInstance;
    private String msTypeface = "";
    private String msOriginalTypeface = "";
    private String msEncoding = "";
    private UnitSpan moSize = goDefaultUnitNeg;
    private int miWeight;
    private int meJustifyV = 1;
    private int meJustifyH = 5;
    private TextTabList mpoTabs;
    private String msLocale = "";
    private int mbUnitEnable;
    private int mbIntEnable;
    private int mbFloatEnable;
    private int mbBoolEnable;
    private int mbBoolValue;
    private boolean mbJustifyVEnable;
    private boolean mbJustifyHEnable;
    private boolean mbLocaleEnable;
    private boolean mbBaselineShiftEnable;
    private boolean mbLeaderContentEnable;
    private static final UnitSpan goDefaultUnitNeg = new UnitSpan(19, -1);
    private static final TextMeasurement goDefaultMeasureNeg = new TextMeasurement(goDefaultUnitNeg);
    private static final String gmsDefaultTypeface = "Courier Std";
    private static final String gsDefaultEncoding = "iso8859-1";
    public static final TextAttr defaultFull = new TextAttr(true);
    public static final TextAttr defaultEmpty = new TextAttr(false);

    public TextAttr() {
        this.initialize(false);
    }

    public TextAttr(boolean bDefault) {
        this.initialize(bDefault);
    }

    public TextAttr(TextAttr oSource) {
        this.initialize(false);
        this.moGfxSource = oSource.moGfxSource;
        this.copyFrom(oSource);
    }

    public TextAttr(TextAttr oSource, TextGfxSource oGfxSource) {
        this.initialize(false);
        this.moGfxSource = oGfxSource;
        if (oSource.moGfxSource != this.moGfxSource) {
            AttrCopy copier = new AttrCopy(oSource, 0);
            copier.copy(this);
        } else {
            this.copyFrom(oSource);
        }
    }

    public TextGfxSource gfxSource() {
        return this.moGfxSource;
    }

    public void gfxSource(TextGfxSource oNewGfxSource) {
        FontInstance oNewFontInstance = null;
        String sOriginalTypeface = this.originalTypeface();
        if (this.moFontInstance != null) {
            oNewFontInstance = this.moFontInstance;
        } else if (oNewGfxSource.getFontService() != null && this.typefaceEnable() && this.sizeEnable() && this.weightEnable() && this.italicEnable()) {
            FontDesc oFontDesc = new FontDesc(this);
            ReconcileInfo reconcile = this.reconcileFont(oNewGfxSource.getFontService(), oFontDesc);
            oNewFontInstance = reconcile.mFontInstance;
            sOriginalTypeface = reconcile.mOriginalTypeface;
        }
        this.moGfxSource = oNewGfxSource;
        if (oNewFontInstance != null) {
            this.updateFont(oNewFontInstance, sOriginalTypeface);
        }
        if (this.mpoExtra != null && this.mpoExtra.mpoLeaderContent != null) {
            this.mpoExtra.mpoLeaderContent.fontService(oNewGfxSource.getFontService());
        }
    }

    public FontService fontService() {
        return this.moGfxSource == null ? null : this.moGfxSource.getFontService();
    }

    public void fontService(FontService poNewFontService, boolean bSuppressReconcile) {
        if (poNewFontService == this.fontService()) {
            return;
        }
        if (bSuppressReconcile) {
            this.moGfxSource = new TextGfxSource(poNewFontService);
        } else {
            this.gfxSource(new TextGfxSource(poNewFontService));
        }
        if (this.mpoExtra != null && this.mpoExtra.mpoLeaderContent != null) {
            this.mpoExtra.mpoLeaderContent.fontService(poNewFontService);
        }
    }

    public void fontService(FontService poNewFontService) {
        this.fontService(poNewFontService, false);
    }

    public FontInstance fontInstance() {
        return this.moFontInstance;
    }

    public void fontInstance(FontInstance oNewFont, String sOriginalTypeface) {
        if (oNewFont != this.moFontInstance) {
            this.updateFont(oNewFont, sOriginalTypeface);
        }
    }

    public void fontInstance(FontInstance oNewFont) {
        this.fontInstance(oNewFont, "");
    }

    public boolean substituteFont() {
        return !StringUtils.isEmpty(this.msOriginalTypeface);
    }

    public boolean fontEnable() {
        return this.moFontInstance != null;
    }

    public void fontEnable(boolean bNewEnable) {
        if (!bNewEnable) {
            this.updateFont(null, "");
        }
    }

    public boolean anyFontEnable() {
        return this.typefaceEnable() || this.sizeEnable() || this.weightEnable() || this.italicEnable() || this.horizontalScaleEnable() || this.verticalScaleEnable();
    }

    public String typeface() {
        return this.msTypeface;
    }

    public void typeface(String sNewTypeface, int nWeight, boolean bItalic, String sEncoding) {
        this.msTypeface = sNewTypeface;
        FontDesc oFontDesc = new FontDesc();
        oFontDesc.setTypeface(sNewTypeface);
        oFontDesc.setWeight(nWeight);
        oFontDesc.setItalic(bItalic);
        oFontDesc.setEncoding(sEncoding);
        this.updateFont(oFontDesc);
    }

    public void typeface(String sNewTypeface) {
        FontDesc oFontDesc = new FontDesc(sNewTypeface);
        this.updateFont(oFontDesc);
    }

    public void typeface(String sNewTypeface, UnitSpan oSize, int nWeight, int nItalic) {
        FontDesc oFontDesc = new FontDesc();
        if (sNewTypeface != null && sNewTypeface.length() > 0) {
            oFontDesc.setTypeface(sNewTypeface);
        }
        if (oSize != null && oSize.value() > 0) {
            oFontDesc.setSize(oSize);
        }
        if (nWeight != 0) {
            oFontDesc.setWeight(nWeight);
        }
        if (nItalic != -1) {
            oFontDesc.setItalic(nItalic == 1);
        }
        this.updateFont(oFontDesc);
    }

    public boolean typefaceEnable() {
        return this.msTypeface.length() > 0;
    }

    public void typefaceEnable(boolean bNewEnable) {
        if (!bNewEnable) {
            this.typeface("");
        }
    }

    public String originalTypeface() {
        return this.msOriginalTypeface;
    }

    public String encoding() {
        return this.msEncoding;
    }

    public void encoding(String sNewEncoding) {
        FontDesc oFontDesc = new FontDesc();
        oFontDesc.setEncoding(sNewEncoding);
        this.updateFont(oFontDesc);
    }

    public boolean encodingEnable() {
        return this.msEncoding.length() > 0;
    }

    public void encodingEnable(boolean bNewEnable) {
        if (!bNewEnable) {
            this.encoding("");
        }
    }

    public UnitSpan size() {
        return this.moSize;
    }

    public void size(UnitSpan oNewSize) {
        FontDesc oFontDesc = new FontDesc(oNewSize);
        this.updateFont(oFontDesc);
    }

    public boolean sizeEnable() {
        return this.moSize.value() >= 0;
    }

    public void sizeEnable(boolean bNewEnable) {
        this.size(new UnitSpan(UnitSpan.defaultUnits(), -1));
    }

    public int weight() {
        return this.miWeight;
    }

    public void weight(int iNewWeight) {
        FontDesc oFontDesc = new FontDesc(iNewWeight);
        this.updateFont(oFontDesc);
    }

    public boolean weightEnable() {
        return this.miWeight != 0;
    }

    public void weightEnable(boolean bNewEnable) {
        this.weight(0);
    }

    public boolean italic() {
        return this.getBoolValue(0);
    }

    public void italic(boolean bNewItalic) {
        FontDesc oFontDesc = new FontDesc();
        oFontDesc.setItalic(bNewItalic);
        this.updateFont(oFontDesc);
    }

    public boolean italicEnable() {
        return this.isBoolEnabled(0);
    }

    public void italicEnable(boolean bNewEnable) {
        this.enableBool(0, bNewEnable);
        this.updateFont();
    }

    public GFXTextAttr gfxTextAttr() {
        return this.getGfxTextAttr();
    }

    public boolean transparent() {
        return this.getBoolValue(1);
    }

    public void transparent(boolean bNewTransparent) {
        this.setBoolValue(1, bNewTransparent);
    }

    public boolean transparentEnable() {
        return this.isBoolEnabled(1);
    }

    public void transparentEnable(boolean bNewEnable) {
        this.enableBool(1, bNewEnable);
    }

    public TextMeasurement spacing() {
        return this.getUnitValue(0);
    }

    public void spacing(TextMeasurement oNewSpacing) {
        this.setUnitValue(0, oNewSpacing);
    }

    public boolean spacingEnable() {
        return this.isUnitEnabled(0);
    }

    public void spacingEnable(boolean bNewEnable) {
        this.enableUnit(0, bNewEnable);
    }

    public TextMeasurement marginL() {
        return this.getUnitValue(1);
    }

    public void marginL(TextMeasurement oNewMarginL) {
        this.setUnitValue(1, oNewMarginL);
    }

    public boolean marginLEnable() {
        return this.isUnitEnabled(1);
    }

    public void marginLEnable(boolean bNewEnable) {
        this.enableUnit(1, bNewEnable);
    }

    public TextMeasurement marginR() {
        return this.getUnitValue(2);
    }

    public void marginR(TextMeasurement oNewMarginR) {
        this.setUnitValue(2, oNewMarginR);
    }

    public boolean marginREnable() {
        return this.isUnitEnabled(2);
    }

    public void marginREnable(boolean bNewEnable) {
        this.enableUnit(2, bNewEnable);
    }

    public int justifyV() {
        return this.meJustifyV;
    }

    public void justifyV(int eNewJustifyV) {
        this.meJustifyV = eNewJustifyV;
        this.mbJustifyVEnable = this.meJustifyV != 0;
    }

    public boolean justifyVEnable() {
        return this.mbJustifyVEnable;
    }

    public void justifyVEnable(boolean bNewEnable) {
        this.mbJustifyVEnable = bNewEnable;
        if (!this.mbJustifyVEnable) {
            this.meJustifyV = 0;
        }
    }

    public int justifyH() {
        return this.meJustifyH;
    }

    public void justifyH(int eNewJustifyH) {
        this.meJustifyH = eNewJustifyH;
        this.mbJustifyHEnable = this.meJustifyH != 4;
    }

    public boolean justifyHEnable() {
        return this.mbJustifyHEnable;
    }

    public void justifyHEnable(boolean bNewEnable) {
        this.mbJustifyHEnable = bNewEnable;
        if (!this.mbJustifyHEnable) {
            this.meJustifyH = 4;
        }
    }

    public TextMeasurement radixOffset() {
        return this.getUnitValue(3);
    }

    public void radixOffset(TextMeasurement oNewRadixOffset) {
        this.setUnitValue(3, oNewRadixOffset);
    }

    public boolean radixOffsetEnable() {
        return this.isUnitEnabled(3);
    }

    public void radixOffsetEnable(boolean bNewEnable) {
        this.enableUnit(3, bNewEnable);
    }

    public int radixPos() {
        return this.getIntValue(0);
    }

    public void radixPos(int nNewRadixPos) {
        this.setIntValue(0, nNewRadixPos);
    }

    public boolean radixPosEnable() {
        return this.isIntEnabled(0);
    }

    public void radixPosEnable(boolean bNewEnable) {
        this.enableInt(0, bNewEnable);
    }

    public TextTabList tabs() {
        return this.mpoTabs == null ? TextTabList.DEFAULT_TAB_LIST : this.mpoTabs;
    }

    public void tabs(TextTabList oNewTabs) {
        this.mpoTabs = oNewTabs == TextTabList.DEFAULT_TAB_LIST ? TextTabList.DEFAULT_TAB_LIST : new TextTabList(oNewTabs);
    }

    public boolean tabsEnable() {
        return this.mpoTabs != null;
    }

    public void tabsEnable(boolean bNewEnable) {
        if (bNewEnable) {
            if (this.mpoTabs == null) {
                this.mpoTabs = TextTabList.DEFAULT_TAB_LIST;
            }
        } else {
            this.mpoTabs = null;
        }
    }

    public TextMeasurement special() {
        return this.getUnitValue(4);
    }

    public void special(TextMeasurement oNewSpecial) {
        this.setUnitValue(4, oNewSpecial);
    }

    public boolean specialEnable() {
        return this.isUnitEnabled(4);
    }

    public void specialEnable(boolean bNewEnable) {
        this.enableUnit(4, bNewEnable);
    }

    public TextMeasurement spaceBefore() {
        return this.getUnitValue(5);
    }

    public void spaceBefore(TextMeasurement oNewSpaceBefore) {
        this.setUnitValue(5, oNewSpaceBefore);
    }

    public boolean spaceBeforeEnable() {
        return this.isUnitEnabled(5);
    }

    public void spaceBeforeEnable(boolean bNewEnable) {
        this.enableUnit(5, bNewEnable);
    }

    public TextMeasurement spaceAfter() {
        return this.getUnitValue(6);
    }

    public void spaceAfter(TextMeasurement oNewSpaceAfter) {
        this.setUnitValue(6, oNewSpaceAfter);
    }

    public boolean spaceAfterEnable() {
        return this.isUnitEnabled(6);
    }

    public void spaceAfterEnable(boolean bNewEnable) {
        this.enableUnit(6, bNewEnable);
    }

    public boolean invisible() {
        return this.getBoolValue(2);
    }

    public void invisible(boolean bNewInvisible) {
        this.setBoolValue(2, bNewInvisible);
    }

    public boolean invisibleEnable() {
        return this.isBoolEnabled(2);
    }

    public void invisibleEnable(boolean bNewEnable) {
        this.enableBool(2, bNewEnable);
    }

    public char invisChar() {
        return (char)this.getIntValue(1);
    }

    public void invisChar(char cNewInvisChar) {
        this.setIntValue(1, cNewInvisChar);
    }

    public boolean invisCharEnable() {
        return this.isIntEnabled(1);
    }

    public void invisCharEnable(boolean bNewEnable) {
        this.enableInt(1, bNewEnable);
    }

    public TextBaselineShift baselineShift() {
        return this.mpoExtra == null || this.mpoExtra.moShift == null ? TextBaselineShift.DEFAULT_SHIFT : this.mpoExtra.moShift;
    }

    public void baselineShift(TextBaselineShift oNewShift) {
        if (oNewShift != this.baselineShift()) {
            this.needExtra();
            this.mpoExtra.moShift = oNewShift;
        }
        this.mbBaselineShiftEnable = oNewShift != null;
    }

    public boolean baselineShiftEnable() {
        return this.mbBaselineShiftEnable;
    }

    public void baselineShiftEnable(boolean bNewEnable) {
        this.mbBaselineShiftEnable = bNewEnable;
    }

    public UnitSpan flattenMeasurement(TextMeasurement oMeasurement) {
        if (this.fontEnable() && this.moFontInstance != null) {
            return oMeasurement.flatten(this.moFontInstance);
        }
        return oMeasurement.flatten(this.moSize);
    }

    public boolean flatten() {
        if (!this.sizeEnable()) {
            return false;
        }
        UnitSpan oFontSize = this.size();
        if (oFontSize.value() == 0) {
            return false;
        }
        boolean bFlattened = false;
        if (this.canFlattenBaselineShift()) {
            TextBaselineShift oOldShift = this.baselineShift();
            UnitSpan oOldSize = oFontSize;
            UnitSpan[] flat = oOldShift.flatten(UnitSpan.ZERO, oOldSize, oFontSize);
            this.size(flat[1]);
            this.baselineShift(new TextBaselineShift(flat[0]));
            bFlattened = true;
        }
        FontInstance oFontInstance = null;
        if (this.fontEnable()) {
            oFontInstance = this.fontInstance();
        }
        if (this.mpoExtra != null) {
            for (int i = 0; i < 11; ++i) {
                TextMeasurement oMeasurement = this.mpoExtra.moUnit[i];
                if (oMeasurement.getType() == 0) continue;
                UnitSpan oFlat = oFontInstance == null ? oMeasurement.flatten(oFontSize) : oMeasurement.flatten(oFontInstance);
                this.mpoExtra.moUnit[i] = new TextMeasurement(oFlat);
            }
        }
        return bFlattened;
    }

    public TextAttr conditionalFlatten() {
        if (!this.sizeEnable() || this.size().value() == 0) {
            return null;
        }
        boolean bFlatten = false;
        if (this.canFlattenBaselineShift()) {
            bFlatten = true;
        } else if (this.mpoExtra != null) {
            for (int i = 0; i < 11; ++i) {
                if (this.mpoExtra.moUnit[i].getType() == 0) continue;
                bFlatten = true;
                break;
            }
        }
        if (!bFlatten) {
            return null;
        }
        TextAttr poNewAttr = new TextAttr(this);
        poNewAttr.flatten();
        poNewAttr.needExtra();
        poNewAttr.mpoExtra.mpoOriginalAttr = this;
        return poNewAttr;
    }

    public TextAttr getOriginalAttr() {
        return this.mpoExtra == null ? null : this.mpoExtra.mpoOriginalAttr;
    }

    public String locale() {
        return this.msLocale;
    }

    public void locale(String sNewLocale) {
        this.msLocale = sNewLocale;
        this.mbLocaleEnable = true;
    }

    public boolean localeEnable() {
        return this.mbLocaleEnable;
    }

    public void localeEnable(boolean bNewEnable) {
        this.mbLocaleEnable = bNewEnable;
    }

    public String actualLocale() {
        String sLocale = !this.mbLocaleEnable ? "en_US" : (this.msLocale.length() == 0 ? LcLocale.getLocale() : this.msLocale);
        return sLocale;
    }

    public String radixText() {
        String sRadixText;
        LcLocale oLocale = new LcLocale(this.actualLocale());
        if (oLocale.isValid()) {
            LcData oLocaleData = new LcData(oLocale.getName());
            sRadixText = oLocaleData.getRadixSymbol();
        } else {
            sRadixText = ".";
        }
        return sRadixText;
    }

    public char radixChar() {
        String sRadixText = this.radixText();
        char c = sRadixText.charAt(0);
        return c == '\u0000' ? (char)'.' : (char)c;
    }

    public int digits() {
        return this.getIntValue(2);
    }

    public void digits(int eNewDigits) {
        this.setIntValue(2, eNewDigits);
    }

    public boolean digitsEnable() {
        return this.isIntEnabled(2);
    }

    public void digitsEnable(boolean bNewEnable) {
        this.enableInt(2, bNewEnable);
    }

    public int direction() {
        return this.getIntValue(3);
    }

    public void direction(int eNewDirection) {
        this.setIntValue(3, eNewDirection);
    }

    public boolean directionEnable() {
        return this.isIntEnabled(3);
    }

    public void directionEnable(boolean bNewEnable) {
        this.enableInt(3, bNewEnable);
    }

    public int paraDirection() {
        return this.getIntValue(4);
    }

    public void paraDirection(int eNewDirection) {
        this.setIntValue(4, eNewDirection);
    }

    public boolean paraDirectionEnable() {
        return this.isIntEnabled(4);
    }

    public void paraDirectionEnable(boolean bNewEnable) {
        this.enableInt(4, bNewEnable);
    }

    public int layoutOrientation() {
        return this.getIntValue(5);
    }

    public void layoutOrientation(int eNewLayoutOrientation) {
        this.setIntValue(5, eNewLayoutOrientation);
    }

    public boolean layoutOrientationEnable() {
        return this.isIntEnabled(5);
    }

    public void layoutOrientationEnable(boolean bNewEnable) {
        this.enableInt(5, bNewEnable);
    }

    public int ligature() {
        return this.getIntValue(6);
    }

    public void ligature(int eNewLigature) {
        this.setIntValue(6, eNewLigature);
    }

    public boolean ligatureEnable() {
        return this.isIntEnabled(6);
    }

    public void ligatureEnable(boolean bNewEnable) {
        this.enableInt(6, bNewEnable);
    }

    public TextMeasurement charSpacing() {
        return this.getUnitValue(7);
    }

    public void charSpacing(TextMeasurement nNewCharSpacing) {
        this.setUnitValue(7, nNewCharSpacing);
    }

    public boolean charSpacingEnable() {
        return this.isUnitEnabled(7);
    }

    public void charSpacingEnable(boolean bNewEnable) {
        this.enableUnit(7, bNewEnable);
    }

    public TextMeasurement wordSpacing() {
        return this.getUnitValue(8);
    }

    public void wordSpacing(TextMeasurement nNewWordSpacing) {
        this.setUnitValue(8, nNewWordSpacing);
    }

    public boolean wordSpacingEnable() {
        return this.isUnitEnabled(8);
    }

    public void wordSpacingEnable(boolean bNewEnable) {
        this.enableUnit(8, bNewEnable);
    }

    public boolean kerning() {
        return this.getBoolValue(3);
    }

    public void kerning(boolean bNewKerning) {
        this.setBoolValue(3, bNewKerning);
    }

    public boolean kerningEnable() {
        return this.isBoolEnabled(3);
    }

    public void kerningEnable(boolean bNewEnable) {
        this.enableBool(3, bNewEnable);
    }

    public int hyphLevel() {
        return this.getIntValue(7);
    }

    public void hyphLevel(int eNewHyphLevel) {
        this.setIntValue(7, eNewHyphLevel);
    }

    public boolean hyphLevelEnable() {
        return this.isIntEnabled(7);
    }

    public void hyphLevelEnable(boolean bNewEnable) {
        this.enableInt(7, bNewEnable);
    }

    public int hyphMinWord() {
        return this.getIntValue(8);
    }

    public void hyphMinWord(int nNewHyphMinWord) {
        this.setIntValue(8, nNewHyphMinWord);
    }

    public boolean hyphMinWordEnable() {
        return this.isIntEnabled(8);
    }

    public void hyphMinWordEnable(boolean bNewEnable) {
        this.enableInt(8, bNewEnable);
    }

    public int hyphMinPrefix() {
        return this.getIntValue(9);
    }

    public void hyphMinPrefix(int nNewHyphMinPrefix) {
        this.setIntValue(9, nNewHyphMinPrefix);
    }

    public boolean hyphMinPrefixEnable() {
        return this.isIntEnabled(9);
    }

    public void hyphMinPrefixEnable(boolean bNewEnable) {
        this.enableInt(9, bNewEnable);
    }

    public int hyphMinSuffix() {
        return this.getIntValue(10);
    }

    public void hyphMinSuffix(int nNewHyphMinSuffix) {
        this.setIntValue(10, nNewHyphMinSuffix);
    }

    public boolean hyphMinSuffixEnable() {
        return this.isIntEnabled(10);
    }

    public void hyphMinSuffixEnable(boolean bNewEnable) {
        this.enableInt(10, bNewEnable);
    }

    public int hyphMaxLines() {
        return this.getIntValue(11);
    }

    public void hyphMaxLines(int nNewHyphMaxLines) {
        this.setIntValue(11, nNewHyphMaxLines);
    }

    public boolean hyphMaxLinesEnable() {
        return this.isIntEnabled(11);
    }

    public void hyphMaxLinesEnable(boolean bNewEnable) {
        this.enableInt(11, bNewEnable);
    }

    public boolean hyphSuppressNames() {
        return this.getBoolValue(4);
    }

    public void hyphSuppressNames(boolean bNewHyphSuppressNames) {
        this.setBoolValue(4, bNewHyphSuppressNames);
    }

    public boolean hyphSuppressNamesEnable() {
        return this.isBoolEnabled(4);
    }

    public void hyphSuppressNamesEnable(boolean bNewEnable) {
        this.enableBool(4, bNewEnable);
    }

    public boolean hyphSuppressAcronyms() {
        return this.getBoolValue(5);
    }

    public void hyphSuppressAcronyms(boolean bNewHyphSuppressAcronyms) {
        this.setBoolValue(5, bNewHyphSuppressAcronyms);
    }

    public boolean hyphSuppressAcronymsEnable() {
        return this.isBoolEnabled(5);
    }

    public void hyphSuppressAcronymsEnable(boolean bNewEnable) {
        this.enableBool(5, bNewEnable);
    }

    public int leaderPattern() {
        return this.getIntValue(12);
    }

    public void leaderPattern(int eNewLeaderPattern) {
        this.setIntValue(12, eNewLeaderPattern);
    }

    public boolean leaderPatternEnable() {
        return this.isIntEnabled(12);
    }

    public void leaderPatternEnable(boolean bNewEnable) {
        this.enableInt(12, bNewEnable);
    }

    public TextMeasurement leaderPatternWidth() {
        return this.getUnitValue(9);
    }

    public void leaderPatternWidth(TextMeasurement oNewLeaderPatternWidth) {
        this.setUnitValue(9, oNewLeaderPatternWidth);
    }

    public boolean leaderPatternWidthEnable() {
        return this.isUnitEnabled(9);
    }

    public void leaderPatternWidthEnable(boolean bNewEnable) {
        this.enableUnit(9, bNewEnable);
    }

    public int leaderAlign() {
        return this.getIntValue(13);
    }

    public void leaderAlign(int eNewLeaderAlign) {
        this.setIntValue(13, eNewLeaderAlign);
    }

    public boolean leaderAlignEnable() {
        return this.isIntEnabled(13);
    }

    public void leaderAlignEnable(boolean bNewEnable) {
        this.enableInt(13, bNewEnable);
    }

    public TextStream leaderContent() {
        if (!this.mbLeaderContentEnable || this.mpoExtra == null || this.mpoExtra.mpoLeaderContent == null) {
            return TextStream.defaultStream();
        }
        return this.mpoExtra.mpoLeaderContent;
    }

    public void leaderContent(TextStream oNewLeaderContent) {
        if (oNewLeaderContent.posnCount() == 0) {
            if (this.mpoExtra != null) {
                this.mpoExtra.clearLeaderContent();
            }
        } else {
            this.needExtra();
            this.mpoExtra.setLeaderContent(oNewLeaderContent, this.fontService());
        }
        this.mbLeaderContentEnable = true;
    }

    public boolean leaderContentEnable() {
        return this.mbLeaderContentEnable;
    }

    public void leaderContentEnable(boolean bNewEnable) {
        this.mbLeaderContentEnable = bNewEnable;
    }

    public int ruleStyle() {
        return this.getIntValue(14);
    }

    public void ruleStyle(int eNewRuleStyle) {
        this.setIntValue(14, eNewRuleStyle);
    }

    public boolean ruleStyleEnable() {
        return this.isIntEnabled(14);
    }

    public void ruleStyleEnable(boolean bNewEnable) {
        this.enableInt(14, bNewEnable);
    }

    public TextMeasurement ruleThickness() {
        return this.getUnitValue(10);
    }

    public void ruleThickness(TextMeasurement oNewRuleThickness) {
        this.setUnitValue(10, oNewRuleThickness);
    }

    public boolean ruleThicknessEnable() {
        return this.isUnitEnabled(10);
    }

    public void ruleThicknessEnable(boolean bNewEnable) {
        this.enableUnit(10, bNewEnable);
    }

    public double horizontalScale() {
        return this.getFloatValue(0);
    }

    public void horizontalScale(double nNewHorizontalScale) {
        this.setFloatValue(0, nNewHorizontalScale);
        FontDesc oFontDesc = new FontDesc();
        oFontDesc.setHorizontalScale(nNewHorizontalScale);
        this.updateFont(oFontDesc);
    }

    public boolean horizontalScaleEnable() {
        return this.isFloatEnabled(0);
    }

    public void horizontalScaleEnable(boolean bNewEnable) {
        this.enableFloat(0, bNewEnable);
        this.updateFont();
    }

    public double verticalScale() {
        return this.getFloatValue(1);
    }

    public void verticalScale(double nNewVerticalScale) {
        this.setFloatValue(1, nNewVerticalScale);
        FontDesc oFontDesc = new FontDesc();
        oFontDesc.setVerticalScale(nNewVerticalScale);
        this.updateFont(oFontDesc);
    }

    public boolean verticalScaleEnable() {
        return this.isFloatEnabled(1);
    }

    public void verticalScaleEnable(boolean bNewEnable) {
        this.enableFloat(1, bNewEnable);
        this.updateFont();
    }

    public void setDefault(boolean bDefault) {
        if (bDefault) {
            UnitSpan o12pt = new UnitSpan(19, 12000);
            int iWeight = 400;
            boolean bItalic = false;
            this.moFontInstance = null;
            String sDefaultTypeface = gmsDefaultTypeface;
            FontDesc oFontDesc = new FontDesc();
            oFontDesc.setTypeface(sDefaultTypeface);
            oFontDesc.setSize(o12pt);
            oFontDesc.setWeight(iWeight);
            oFontDesc.setItalic(bItalic);
            oFontDesc.setEncoding(gsDefaultEncoding);
            oFontDesc.setHorizontalScale(1.0);
            oFontDesc.setVerticalScale(1.0);
            this.updateFont(oFontDesc);
            this.setGfxTextAttrDefault(true);
            this.transparent(false);
            this.justifyV(1);
            this.justifyH(5);
            this.tabs(TextTabList.DEFAULT_TAB_LIST);
            this.invisible(false);
            this.localeEnable(true);
            if (this.mpoExtra != null) {
                this.mpoExtra.initialize();
            }
            this.spacingEnable(true);
            this.marginLEnable(true);
            this.marginREnable(true);
            this.radixOffsetEnable(true);
            this.radixPosEnable(true);
            this.specialEnable(true);
            this.spaceBeforeEnable(true);
            this.spaceAfterEnable(true);
            this.invisCharEnable(true);
            this.baselineShiftEnable(true);
            this.digitsEnable(true);
            this.directionEnable(true);
            this.paraDirectionEnable(true);
            this.layoutOrientationEnable(true);
            this.ligatureEnable(true);
            this.charSpacingEnable(true);
            this.wordSpacingEnable(true);
            this.kerning(false);
            this.hyphLevelEnable(true);
            this.hyphMinWordEnable(true);
            this.hyphMinPrefixEnable(true);
            this.hyphMinSuffixEnable(true);
            this.hyphMaxLinesEnable(true);
            this.hyphSuppressNames(false);
            this.hyphSuppressAcronyms(false);
            this.leaderPatternEnable(true);
            this.leaderPatternWidthEnable(true);
            this.leaderAlignEnable(true);
            this.leaderContentEnable(true);
            this.ruleStyleEnable(true);
            this.ruleThicknessEnable(true);
        } else {
            this.fontEnable(false);
            this.typefaceEnable(false);
            this.encodingEnable(false);
            this.sizeEnable(false);
            this.weightEnable(false);
            this.italicEnable(false);
            this.horizontalScaleEnable(false);
            this.verticalScaleEnable(false);
            this.setGfxTextAttrDefault(false);
            this.transparent(false);
            this.transparentEnable(false);
            this.spacingEnable(false);
            this.marginLEnable(false);
            this.marginREnable(false);
            this.justifyVEnable(false);
            this.justifyHEnable(false);
            this.radixOffsetEnable(false);
            this.radixPosEnable(false);
            this.tabsEnable(false);
            this.specialEnable(false);
            this.spaceBeforeEnable(false);
            this.spaceAfterEnable(false);
            this.invisible(false);
            this.invisibleEnable(false);
            this.invisCharEnable(false);
            this.baselineShiftEnable(false);
            this.localeEnable(false);
            this.digitsEnable(false);
            this.directionEnable(false);
            this.paraDirectionEnable(false);
            this.layoutOrientationEnable(false);
            this.ligatureEnable(false);
            this.charSpacingEnable(false);
            this.wordSpacingEnable(false);
            this.kerning(false);
            this.kerningEnable(false);
            this.hyphLevelEnable(false);
            this.hyphMinWordEnable(false);
            this.hyphMinPrefixEnable(false);
            this.hyphMinSuffixEnable(false);
            this.hyphMaxLinesEnable(false);
            this.hyphSuppressNamesEnable(false);
            this.hyphSuppressAcronymsEnable(false);
            this.leaderPatternEnable(false);
            this.leaderPatternWidthEnable(false);
            this.leaderAlignEnable(false);
            this.leaderContentEnable(false);
            this.ruleStyleEnable(false);
            this.ruleThicknessEnable(false);
        }
    }

    public void addDisabled(TextAttr oSource) {
        AttrCopy copier = new AttrCopy(oSource, 2);
        copier.copy(this);
    }

    public void override(TextAttr oOverride, TextAttr poDiffs) {
        AttrCopy copier = new AttrCopy(oOverride, 1);
        copier.copy(this, poDiffs);
    }

    public void override(TextAttr oOverride) {
        this.override(oOverride, null);
    }

    public void dropDiff(TextAttr oCompare) {
        int i;
        if (oCompare.fontEnable() && !FontInstance.match(this.moFontInstance, oCompare.moFontInstance)) {
            this.fontEnable(false);
        }
        if (this.typefaceEnable() && oCompare.typefaceEnable() && !this.typeface().equals(oCompare.typeface())) {
            this.typefaceEnable(false);
        }
        if (this.encodingEnable() && oCompare.encodingEnable() && this.encoding() != oCompare.encoding()) {
            this.encodingEnable(false);
        }
        if (this.sizeEnable() && oCompare.sizeEnable() && this.size() != oCompare.size()) {
            this.sizeEnable(false);
        }
        if (this.weightEnable() && oCompare.weightEnable() && this.weight() != oCompare.weight()) {
            this.weightEnable(false);
        }
        if (this.italicEnable() && oCompare.italicEnable() && this.italic() != oCompare.italic()) {
            this.italicEnable(false);
        }
        if (this.horizontalScaleEnable() && oCompare.horizontalScaleEnable() && this.horizontalScale() != oCompare.horizontalScale()) {
            this.horizontalScaleEnable(false);
        }
        if (this.verticalScaleEnable() && oCompare.verticalScaleEnable() && this.verticalScale() != oCompare.verticalScale()) {
            this.verticalScaleEnable(false);
        }
        if (this.underlineEnable() && oCompare.underlineEnable() && this.underline() != oCompare.underline()) {
            this.underlineEnable(false);
        }
        if (this.overlineEnable() && oCompare.overlineEnable() && this.overline() != oCompare.overline()) {
            this.overlineEnable(false);
        }
        if (this.strikeoutEnable() && oCompare.strikeoutEnable() && this.strikeout() != oCompare.strikeout()) {
            this.strikeoutEnable(false);
        }
        if (this.overlineEnable() && oCompare.overlineEnable() && this.overline() != oCompare.overline()) {
            this.overlineEnable(false);
        }
        if (this.colourEnable() && oCompare.colourEnable() && this.colour() != oCompare.colour()) {
            this.colourEnable(false);
        }
        if (this.colourBgEnable() && oCompare.colourBgEnable() && this.colourBg() != oCompare.colourBg()) {
            this.colourBgEnable(false);
        }
        if (this.styleEnable() && oCompare.styleEnable() && this.style() != oCompare.style()) {
            this.styleEnable(false);
        }
        if (this.shadeEnable() && oCompare.shadeEnable() && this.shade() != oCompare.shade()) {
            this.shadeEnable(false);
        }
        if (this.shadeScaleEnable() && oCompare.shadeScaleEnable() && this.shadeScale() != oCompare.shadeScale()) {
            this.shadeScaleEnable(false);
        }
        if (this.graphicContextEnable() && oCompare.graphicContextEnable() && this.graphicContext() != oCompare.graphicContext()) {
            this.graphicContextEnable(false);
        }
        if (this.justifyVEnable() && oCompare.justifyVEnable() && this.justifyV() != oCompare.justifyV()) {
            this.justifyVEnable(false);
        }
        if (this.justifyHEnable() && oCompare.justifyHEnable() && this.justifyH() != oCompare.justifyH()) {
            this.justifyHEnable(false);
        }
        if (this.tabsEnable() && oCompare.tabsEnable() && this.tabs() != oCompare.tabs()) {
            this.tabsEnable(false);
        }
        if (this.baselineShiftEnable() && oCompare.baselineShiftEnable() && this.baselineShift() != oCompare.baselineShift()) {
            this.baselineShiftEnable(false);
        }
        if (this.localeEnable() && oCompare.localeEnable() && this.locale() != oCompare.locale()) {
            this.localeEnable(false);
        }
        if (this.leaderContentEnable() && oCompare.leaderContentEnable() && this.leaderContent() != oCompare.leaderContent()) {
            this.leaderContentEnable(false);
        }
        for (i = 0; i < 6; ++i) {
            if (i == 0 || !this.isBoolEnabled(i) || !oCompare.isBoolEnabled(i) || this.getBoolValue(i) == oCompare.getBoolValue(i)) continue;
            this.enableBool(i, false);
        }
        for (i = 0; i < 11; ++i) {
            if (!this.isUnitEnabled(i) || !oCompare.isUnitEnabled(i) || this.getUnitValue(i) == oCompare.getUnitValue(i)) continue;
            this.enableUnit(i, false);
        }
        for (i = 0; i < 15; ++i) {
            if (!this.isIntEnabled(i) || !oCompare.isIntEnabled(i) || this.getIntValue(i) == oCompare.getIntValue(i)) continue;
            this.enableInt(i, false);
        }
        for (i = 0; i < 2; ++i) {
            if (i == 0 || i == 1 || !this.isFloatEnabled(i) || !oCompare.isFloatEnabled(i) || this.getFloatValue(i) == oCompare.getFloatValue(i)) continue;
            this.enableFloat(i, false);
        }
    }

    public void dropSame(TextAttr oCompare, boolean bPreserveGfx) {
        int i;
        boolean bPreserving = bPreserveGfx;
        if (this.fontEnable() && oCompare.fontEnable() && FontInstance.match(this.moFontInstance, oCompare.moFontInstance)) {
            this.fontEnable(false);
        }
        if (this.typefaceEnable() && oCompare.typefaceEnable() && this.typeface().equals(oCompare.typeface())) {
            this.typefaceEnable(false);
        }
        if (this.sizeEnable() && oCompare.sizeEnable() && UnitSpan.match(this.size(), oCompare.size())) {
            this.sizeEnable(false);
        }
        if (this.weightEnable() && oCompare.weightEnable() && this.weight() == oCompare.weight()) {
            this.weightEnable(false);
        }
        if (this.italicEnable() && oCompare.italicEnable() && this.italic() == oCompare.italic()) {
            this.italicEnable(false);
        }
        if (this.horizontalScaleEnable() && oCompare.horizontalScaleEnable() && this.horizontalScale() == oCompare.horizontalScale()) {
            this.horizontalScaleEnable(false);
        }
        if (this.verticalScaleEnable() && oCompare.verticalScaleEnable() && this.verticalScale() == oCompare.verticalScale()) {
            this.verticalScaleEnable(false);
        }
        if (this.encodingEnable() && oCompare.encodingEnable() && this.encoding() == oCompare.encoding()) {
            this.encodingEnable(false);
        }
        if (!(this.typefaceEnable() && this.sizeEnable() && this.weightEnable() && this.italicEnable() && this.horizontalScaleEnable() && this.verticalScaleEnable())) {
            this.fontEnable(false);
        }
        boolean bSkipGfx = false;
        if (bPreserving) {
            // empty if block
        }
        if (!bSkipGfx) {
            if (this.underlineEnable() && oCompare.underlineEnable() && this.underline() == oCompare.underline()) {
                this.underlineEnable(false);
            }
            if (this.overlineEnable() && oCompare.overlineEnable() && this.overline() == oCompare.overline()) {
                this.overlineEnable(false);
            }
            if (this.strikeoutEnable() && oCompare.strikeoutEnable() && this.strikeout() == oCompare.strikeout()) {
                this.strikeoutEnable(false);
            }
            if (this.overlineEnable() && oCompare.overlineEnable() && this.overline() == oCompare.overline()) {
                this.overlineEnable(false);
            }
            if (this.colourEnable() && oCompare.colourEnable() && this.colour() == oCompare.colour()) {
                this.colourEnable(false);
            }
            if (this.colourBgEnable() && oCompare.colourBgEnable() && this.colourBg() == oCompare.colourBg()) {
                this.colourBgEnable(false);
            }
            if (this.styleEnable() && oCompare.styleEnable() && this.style() == oCompare.style()) {
                this.styleEnable(false);
            }
            if (this.shadeEnable() && oCompare.shadeEnable() && this.shade() == oCompare.shade()) {
                this.shadeEnable(false);
            }
            if (this.shadeScaleEnable() && oCompare.shadeScaleEnable() && this.shadeScale() == oCompare.shadeScale()) {
                this.shadeScaleEnable(false);
            }
            if (this.graphicContextEnable() && oCompare.graphicContextEnable() && this.graphicContext() == oCompare.graphicContext()) {
                this.graphicContextEnable(false);
            }
        }
        if (this.justifyVEnable() && oCompare.justifyVEnable() && this.justifyV() == oCompare.justifyV()) {
            this.justifyVEnable(false);
        }
        if (this.justifyHEnable() && oCompare.justifyHEnable() && this.justifyH() == oCompare.justifyH()) {
            this.justifyHEnable(false);
        }
        if (this.tabsEnable() && oCompare.tabsEnable() && this.tabs() == oCompare.tabs()) {
            this.tabsEnable(false);
        }
        if (this.baselineShiftEnable() && oCompare.baselineShiftEnable() && this.baselineShift() == oCompare.baselineShift()) {
            this.baselineShiftEnable(false);
        }
        if (this.localeEnable() && oCompare.localeEnable() && this.locale() == oCompare.locale()) {
            this.localeEnable(false);
        }
        if (this.leaderContentEnable() && oCompare.leaderContentEnable() && this.leaderContent() == oCompare.leaderContent()) {
            this.leaderContentEnable(false);
        }
        for (i = 0; i < 6; ++i) {
            if (i == 0 || !this.isBoolEnabled(i) || !oCompare.isBoolEnabled(i) || this.getBoolValue(i) != oCompare.getBoolValue(i)) continue;
            this.enableBool(i, false);
        }
        for (i = 0; i < 11; ++i) {
            if (!this.isUnitEnabled(i) || !oCompare.isUnitEnabled(i) || this.getUnitValue(i) != oCompare.getUnitValue(i)) continue;
            this.enableUnit(i, false);
        }
        for (i = 0; i < 15; ++i) {
            if (!this.isIntEnabled(i) || !oCompare.isIntEnabled(i) || this.getIntValue(i) != oCompare.getIntValue(i)) continue;
            this.enableInt(i, false);
        }
        for (i = 0; i < 2; ++i) {
            if (i == 0 || i == 1 || !this.isFloatEnabled(i) || !oCompare.isFloatEnabled(i) || this.getFloatValue(i) != oCompare.getFloatValue(i)) continue;
            this.enableFloat(i, false);
        }
    }

    public void dropSame(TextAttr oCompare) {
        this.dropSame(oCompare, false);
    }

    public void isolatePara(boolean bKeep, boolean bLegacyPositioning) {
        if (bKeep) {
            this.fontEnable(false);
            this.typefaceEnable(false);
            this.encodingEnable(false);
            this.sizeEnable(false);
            this.weightEnable(false);
            this.italicEnable(false);
            this.horizontalScaleEnable(false);
            this.verticalScaleEnable(false);
            this.underlineEnable(false);
            this.overlineEnable(false);
            this.strikeoutEnable(false);
            this.overlineEnable(false);
            this.colourEnable(false);
            this.colourBgEnable(false);
            this.styleEnable(false);
            this.shadeEnable(false);
            this.shadeScaleEnable(false);
            this.graphicContextEnable(false);
            this.transparentEnable(false);
            this.invisibleEnable(false);
            this.invisCharEnable(false);
            this.baselineShiftEnable(false);
            this.localeEnable(false);
            this.digitsEnable(false);
            this.directionEnable(false);
            this.ligatureEnable(false);
            this.charSpacingEnable(false);
            this.wordSpacingEnable(false);
            this.kerningEnable(false);
            this.leaderPatternEnable(false);
            this.leaderPatternWidthEnable(false);
            this.leaderAlignEnable(false);
            this.leaderContentEnable(false);
            this.ruleStyleEnable(false);
            this.ruleThicknessEnable(false);
        } else {
            this.marginLEnable(false);
            this.marginREnable(false);
            this.justifyVEnable(false);
            this.justifyHEnable(false);
            this.radixOffsetEnable(false);
            this.radixPosEnable(false);
            this.tabsEnable(false);
            this.specialEnable(false);
            this.spaceBeforeEnable(false);
            this.spaceAfterEnable(false);
            this.paraDirectionEnable(false);
            this.layoutOrientationEnable(false);
            this.hyphLevelEnable(false);
            this.hyphMinWordEnable(false);
            this.hyphMinPrefixEnable(false);
            this.hyphMinSuffixEnable(false);
            this.hyphMaxLinesEnable(false);
            this.hyphSuppressNamesEnable(false);
            this.hyphSuppressAcronymsEnable(false);
        }
        if (bKeep == bLegacyPositioning) {
            this.spacingEnable(false);
        }
    }

    public void isolatePara(boolean bKeep) {
        this.isolatePara(bKeep, false);
    }

    public boolean isComplete() {
        return this.typefaceEnable() && this.encodingEnable() && this.sizeEnable() && this.weightEnable() && this.italicEnable() && this.horizontalScaleEnable() && this.verticalScaleEnable() && this.gfxTextAttrEnable() && this.transparentEnable() && this.spacingEnable() && this.marginLEnable() && this.marginREnable() && this.justifyVEnable() && this.justifyHEnable() && this.radixOffsetEnable() && this.radixPosEnable() && this.tabsEnable() && this.specialEnable() && this.spaceBeforeEnable() && this.spaceAfterEnable() && this.invisibleEnable() && this.invisCharEnable() && this.baselineShiftEnable() && this.localeEnable() && this.digitsEnable() && this.directionEnable() && this.paraDirectionEnable() && this.layoutOrientationEnable() && this.ligatureEnable() && this.charSpacingEnable() && this.wordSpacingEnable() && this.kerningEnable() && this.hyphLevelEnable() && this.hyphMinWordEnable() && this.hyphMinPrefixEnable() && this.hyphMinSuffixEnable() && this.hyphMaxLinesEnable() && this.hyphSuppressNamesEnable() && this.hyphSuppressAcronymsEnable() && this.leaderPatternEnable() && this.leaderPatternWidthEnable() && this.leaderAlignEnable() && this.leaderContentEnable() && this.ruleStyleEnable() && this.ruleThicknessEnable();
    }

    public boolean isEmpty() {
        return !this.typefaceEnable() && !this.encodingEnable() && !this.sizeEnable() && !this.weightEnable() && !this.italicEnable() && !this.horizontalScaleEnable() && !this.verticalScaleEnable() && !this.underlineEnable() && !this.overlineEnable() && !this.strikeoutEnable() && !this.overlineEnable() && !this.colourEnable() && !this.colourBgEnable() && !this.styleEnable() && !this.shadeEnable() && !this.shadeScaleEnable() && !this.graphicContextEnable() && !this.transparentEnable() && !this.spacingEnable() && !this.marginLEnable() && !this.marginREnable() && !this.justifyVEnable() && !this.justifyHEnable() && !this.radixOffsetEnable() && !this.radixPosEnable() && !this.tabsEnable() && !this.specialEnable() && !this.spaceBeforeEnable() && !this.spaceAfterEnable() && !this.invisibleEnable() && !this.invisCharEnable() && !this.baselineShiftEnable() && !this.localeEnable() && !this.digitsEnable() && !this.directionEnable() && !this.paraDirectionEnable() && !this.layoutOrientationEnable() && !this.ligatureEnable() && !this.charSpacingEnable() && !this.wordSpacingEnable() && !this.kerningEnable() && !this.hyphLevelEnable() && !this.hyphMinWordEnable() && !this.hyphMinPrefixEnable() && !this.hyphMinSuffixEnable() && !this.hyphMaxLinesEnable() && !this.hyphSuppressNamesEnable() && !this.hyphSuppressAcronymsEnable() && !this.leaderPatternEnable() && !this.leaderPatternWidthEnable() && !this.leaderAlignEnable() && !this.leaderContentEnable() && !this.ruleStyleEnable() && !this.ruleThicknessEnable();
    }

    public boolean hasParaAttrs() {
        return this.marginLEnable() || this.marginREnable() || this.justifyVEnable() || this.justifyHEnable() || this.radixOffsetEnable() || this.radixPosEnable() || this.tabsEnable() || this.specialEnable() || this.spacingEnable() || this.spaceBeforeEnable() || this.spaceAfterEnable() || this.paraDirectionEnable() || this.layoutOrientationEnable() || this.hyphLevelEnable() || this.hyphMinWordEnable() || this.hyphMinPrefixEnable() || this.hyphMinSuffixEnable() || this.hyphMaxLinesEnable() || this.hyphSuppressNamesEnable() || this.hyphSuppressAcronymsEnable();
    }

    public static String formatPercent(double dRelative) {
        return Units.doubleToString(dRelative, 3) + '%';
    }

    public static double parsePercent(String sText, boolean bAllowNegative) {
        int last;
        double dValue = 0.0;
        StringBuilder sContent = new StringBuilder(sText);
        for (last = sContent.length() - 1; last > 0 && sContent.charAt(last) == ' '; --last) {
        }
        if (last >= 0 && sContent.charAt(last) == '%') {
            --last;
        }
        sContent.delete(last + 1, sContent.length());
        try {
            dValue = Double.parseDouble(sContent.toString());
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
        if (!bAllowNegative && dValue < 0.0) {
            return Double.NaN;
        }
        return dValue / 100.0;
    }

    public void copyFrom(TextAttr oSource) {
        this.moGfxSource = oSource.moGfxSource;
        this.moFontInstance = oSource.moFontInstance;
        this.msTypeface = oSource.msTypeface;
        this.msOriginalTypeface = oSource.msOriginalTypeface;
        assert (this.msOriginalTypeface != null);
        this.msEncoding = oSource.msEncoding;
        this.moSize = oSource.moSize;
        this.miWeight = oSource.miWeight;
        super.copyFrom(oSource);
        if (oSource.mpoExtra == null) {
            if (this.mpoExtra != null) {
                this.mpoExtra.initialize();
            }
        } else {
            this.needExtra();
            this.mpoExtra.copyFrom(oSource.mpoExtra);
        }
        this.meJustifyV = oSource.meJustifyV;
        this.meJustifyH = oSource.meJustifyH;
        if (oSource.mpoTabs == null) {
            this.tabsEnable(false);
        } else {
            this.mpoTabs = oSource.mpoTabs;
        }
        this.msLocale = oSource.msLocale;
        this.mbBoolValue = oSource.mbBoolValue;
        this.mbBoolEnable = oSource.mbBoolEnable;
        this.mbUnitEnable = oSource.mbUnitEnable;
        this.mbIntEnable = oSource.mbIntEnable;
        this.mbFloatEnable = oSource.mbFloatEnable;
        this.mbBaselineShiftEnable = oSource.mbBaselineShiftEnable;
        this.mbJustifyVEnable = oSource.mbJustifyVEnable;
        this.mbJustifyHEnable = oSource.mbJustifyHEnable;
        this.mbLocaleEnable = oSource.mbLocaleEnable;
        this.mbLeaderContentEnable = oSource.mbLeaderContentEnable;
    }

    @Override
    public boolean equals(Object object) {
        int i;
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        TextAttr oCompare = (TextAttr)object;
        if (this.fontEnable() != oCompare.fontEnable()) {
            return false;
        }
        if (this.typefaceEnable() != oCompare.typefaceEnable()) {
            return false;
        }
        if (this.encodingEnable() != oCompare.encodingEnable()) {
            return false;
        }
        if (this.sizeEnable() != oCompare.sizeEnable()) {
            return false;
        }
        if (this.weightEnable() != oCompare.weightEnable()) {
            return false;
        }
        if (this.justifyVEnable() != oCompare.justifyVEnable()) {
            return false;
        }
        if (this.justifyHEnable() != oCompare.justifyHEnable()) {
            return false;
        }
        if (this.tabsEnable() != oCompare.tabsEnable()) {
            return false;
        }
        if (this.baselineShiftEnable() != oCompare.baselineShiftEnable()) {
            return false;
        }
        if (this.localeEnable() != oCompare.localeEnable()) {
            return false;
        }
        if (this.leaderContentEnable() != oCompare.leaderContentEnable()) {
            return false;
        }
        if (this.mbUnitEnable != oCompare.mbUnitEnable) {
            return false;
        }
        if (this.mbIntEnable != oCompare.mbIntEnable) {
            return false;
        }
        if (this.mbBoolEnable != oCompare.mbBoolEnable) {
            return false;
        }
        if (this.mbFloatEnable != oCompare.mbFloatEnable) {
            return false;
        }
        if (this.fontEnable() && !FontInstance.match(this.fontInstance(), oCompare.fontInstance())) {
            return false;
        }
        if (this.typefaceEnable() && this.typeface() != oCompare.typeface()) {
            return false;
        }
        if (this.encodingEnable() && this.encoding() != oCompare.encoding()) {
            return false;
        }
        if (this.sizeEnable() && this.size() != oCompare.size()) {
            return false;
        }
        if (this.weightEnable() && this.weight() != oCompare.weight()) {
            return false;
        }
        if (this.justifyVEnable() && this.justifyV() != oCompare.justifyV()) {
            return false;
        }
        if (this.justifyHEnable() && this.justifyH() != oCompare.justifyH()) {
            return false;
        }
        if (this.tabsEnable() && this.tabs() != oCompare.tabs()) {
            return false;
        }
        if (this.baselineShiftEnable() && this.baselineShift() != oCompare.baselineShift()) {
            return false;
        }
        if (this.localeEnable() && this.locale() != oCompare.locale()) {
            return false;
        }
        for (i = 0; i < 11; ++i) {
            if (!this.isUnitEnabled(i) || TextMeasurement.match(this.getUnitValue(i), oCompare.getUnitValue(i))) continue;
            return false;
        }
        for (i = 0; i < 15; ++i) {
            if (!this.isIntEnabled(i) || this.getIntValue(i) == oCompare.getIntValue(i)) continue;
            return false;
        }
        for (i = 0; i < 6; ++i) {
            if (!this.isBoolEnabled(i) || this.getBoolValue(i) == oCompare.getBoolValue(i)) continue;
            return false;
        }
        for (i = 0; i < 2; ++i) {
            if (!this.isFloatEnabled(i) || this.getFloatValue(i) == oCompare.getFloatValue(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int i;
        int hashCode = 13;
        hashCode = hashCode * 31 ^ Boolean.valueOf(this.fontEnable()).hashCode();
        hashCode = hashCode * 31 ^ Boolean.valueOf(this.typefaceEnable()).hashCode();
        hashCode = hashCode * 31 ^ Boolean.valueOf(this.encodingEnable()).hashCode();
        hashCode = hashCode * 31 ^ Boolean.valueOf(this.sizeEnable()).hashCode();
        hashCode = hashCode * 31 ^ Boolean.valueOf(this.weightEnable()).hashCode();
        hashCode = hashCode * 31 ^ Boolean.valueOf(this.justifyVEnable()).hashCode();
        hashCode = hashCode * 31 ^ Boolean.valueOf(this.justifyHEnable()).hashCode();
        hashCode = hashCode * 31 ^ Boolean.valueOf(this.tabsEnable()).hashCode();
        hashCode = hashCode * 31 ^ Boolean.valueOf(this.baselineShiftEnable()).hashCode();
        hashCode = hashCode * 31 ^ Boolean.valueOf(this.localeEnable()).hashCode();
        hashCode = hashCode * 31 ^ Boolean.valueOf(this.leaderContentEnable()).hashCode();
        hashCode = hashCode * 31 ^ this.mbUnitEnable;
        hashCode = hashCode * 31 ^ this.mbIntEnable;
        hashCode = hashCode * 31 ^ this.mbBoolEnable;
        hashCode = hashCode * 31 ^ this.mbFloatEnable;
        if (this.fontEnable()) {
            hashCode = hashCode * 31 ^ this.fontInstance().hashCode();
        }
        if (this.typefaceEnable()) {
            hashCode = hashCode * 31 ^ this.typeface().hashCode();
        }
        if (this.encodingEnable()) {
            hashCode = hashCode * 31 ^ this.encoding().hashCode();
        }
        if (this.sizeEnable()) {
            hashCode = hashCode * 31 ^ this.size().hashCode();
        }
        if (this.weightEnable()) {
            hashCode = hashCode * 31 ^ this.weight();
        }
        if (this.justifyVEnable()) {
            hashCode = hashCode * 31 ^ this.justifyV();
        }
        if (this.justifyHEnable()) {
            hashCode = hashCode * 31 ^ this.justifyH();
        }
        if (this.tabsEnable()) {
            hashCode = hashCode * 31 ^ this.tabs().hashCode();
        }
        if (this.baselineShiftEnable()) {
            hashCode = hashCode * 31 ^ this.baselineShift().hashCode();
        }
        if (this.localeEnable()) {
            hashCode = hashCode * 31 ^ this.locale().hashCode();
        }
        for (i = 0; i < 11; ++i) {
            if (!this.isUnitEnabled(i)) continue;
            hashCode = hashCode * 31 ^ this.getUnitValue(i).hashCode();
        }
        for (i = 0; i < 15; ++i) {
            if (!this.isIntEnabled(i)) continue;
            hashCode = hashCode * 31 ^ this.getIntValue(i);
        }
        for (i = 0; i < 6; ++i) {
            if (!this.isBoolEnabled(i)) continue;
            hashCode = hashCode * 31 ^ Boolean.valueOf(this.getBoolValue(i)).hashCode();
        }
        for (i = 0; i < 2; ++i) {
            if (!this.isFloatEnabled(i)) continue;
            long bits = Double.doubleToLongBits(this.getFloatValue(i));
            hashCode = hashCode * 31 ^ (int)(bits ^ bits >>> 32);
        }
        return hashCode;
    }

    public boolean notEqual(TextAttr oCompare) {
        return !this.equals(oCompare);
    }

    public static boolean match(TextAttr poAttr1, TextAttr poAttr2) {
        if (poAttr1 == poAttr2) {
            return true;
        }
        if (poAttr1 == null || poAttr2 == null) {
            return false;
        }
        return poAttr1.equals(poAttr2);
    }

    public static TextAttr defaultAttr(boolean bDefault) {
        return bDefault ? defaultFull : defaultEmpty;
    }

    public void updateFont() {
        this.updateFont((FontDesc)null);
    }

    public void updateFont(FontDesc oNewFontDesc) {
        FontDesc oFontDesc = new FontDesc(this);
        if (oNewFontDesc != null) {
            if (oNewFontDesc.hasTypeface() != 0) {
                this.msTypeface = oNewFontDesc.getTypeface();
                oFontDesc.setTypeface(this.msTypeface);
            }
            if (oNewFontDesc.hasEncoding() != 0) {
                this.msEncoding = oNewFontDesc.getEncoding();
                oFontDesc.setEncoding(this.msEncoding);
            }
            if (oNewFontDesc.hasSize() != 0) {
                this.moSize = oNewFontDesc.getSize();
                oFontDesc.setSize(this.moSize);
            }
            if (oNewFontDesc.hasWeight() != 0) {
                this.miWeight = oNewFontDesc.getWeight();
                oFontDesc.setWeight(this.miWeight);
            }
            if (oNewFontDesc.hasItalic() != 0) {
                this.setBoolValue(0, oNewFontDesc.getItalic());
                oFontDesc.setItalic(this.italic());
            }
            if (oNewFontDesc.hasHorizontalScale() != 0) {
                this.setFloatValue(0, oNewFontDesc.getHorizontalScale());
                oFontDesc.setHorizontalScale(this.horizontalScale());
            }
            if (oNewFontDesc.hasVerticalScale() != 0) {
                this.setFloatValue(1, oNewFontDesc.getVerticalScale());
                oFontDesc.setVerticalScale(this.verticalScale());
            }
        }
        if (!oFontDesc.isValid() || this.fontService() == null) {
            this.cleanupFont();
            return;
        }
        ReconcileInfo reconcile = this.reconcileFont(this.fontService(), oFontDesc);
        if (reconcile.mFontInstance != null) {
            this.updateFont(reconcile.mFontInstance, reconcile.mOriginalTypeface);
        }
    }

    public void updateFont(FontInstance oNewFont, String sOriginalTypeface, boolean bUpdateOptional) {
        if (oNewFont == null && this.moFontInstance == null) {
            return;
        }
        this.cleanupFont();
        if (oNewFont == null) {
            return;
        }
        this.moFontInstance = oNewFont;
        this.msTypeface = this.moFontInstance.getTypeface();
        this.moSize = this.moFontInstance.getSize();
        this.miWeight = FontDesc.coerceWeight(this.moFontInstance.getWeight());
        this.setBoolValue(0, this.moFontInstance.getItalic());
        double dHorizontalScale = this.moFontInstance.getHorizontalScale();
        this.setFloatValue(0, dHorizontalScale, bUpdateOptional || dHorizontalScale != 1.0);
        double dVerticalScale = this.moFontInstance.getVerticalScale();
        this.setFloatValue(1, dVerticalScale, bUpdateOptional || dVerticalScale != 1.0);
        this.msOriginalTypeface = sOriginalTypeface == null ? "" : sOriginalTypeface;
    }

    public void updateFont(FontInstance oNewFont, String sOriginalTypeface) {
        this.updateFont(oNewFont, sOriginalTypeface, false);
    }

    public void updateFont(TextAttr oSource) {
        this.moFontInstance = oSource.fontInstance();
        this.msTypeface = oSource.typeface();
        this.msOriginalTypeface = oSource.originalTypeface();
        assert (this.msOriginalTypeface != null);
        this.msEncoding = oSource.encoding();
        this.moSize = oSource.size();
        this.miWeight = oSource.weight();
        this.setBoolValue(0, oSource.italic());
        this.enableBool(0, oSource.italicEnable());
        this.setFloatValue(0, oSource.horizontalScale(), oSource.horizontalScaleEnable());
        this.setFloatValue(1, oSource.verticalScale(), oSource.verticalScaleEnable());
    }

    void updateGfxTextAttr(TextGfxAttr oNewAttr) {
        this.cleanupGfxTextAttr();
        super.copyFrom(oNewAttr);
    }

    static int getDefaultIntValue(int nIndex) {
        switch (nIndex) {
            case 0: {
                return -1;
            }
            case 1: {
                return 32;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 0;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 3;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 2;
            }
            case 12: {
                return 0;
            }
            case 13: {
                return 0;
            }
            case 14: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    protected void onUpdateGfxTextAttr() {
        this.updateGfxTextAttr(this);
    }

    private void initialize(boolean bDefault) {
        this.mpoExtra = null;
        this.mpoTabs = null;
        this.mbBoolValue = 0;
        this.mbBoolEnable = 0;
        this.mbUnitEnable = 0;
        this.mbIntEnable = 0;
        this.mbFloatEnable = 0;
        this.setDefault(bDefault);
    }

    private void needExtra() {
        if (this.mpoExtra == null) {
            this.mpoExtra = new AttrExtra();
            if (!this.spacingEnable()) {
                this.mpoExtra.moUnit[0] = goDefaultMeasureNeg;
            }
            if (!this.marginLEnable()) {
                this.mpoExtra.moUnit[1] = goDefaultMeasureNeg;
            }
            if (!this.marginREnable()) {
                this.mpoExtra.moUnit[2] = goDefaultMeasureNeg;
            }
            if (!this.spaceBeforeEnable()) {
                this.mpoExtra.moUnit[5] = goDefaultMeasureNeg;
            }
            if (!this.spaceAfterEnable()) {
                this.mpoExtra.moUnit[6] = goDefaultMeasureNeg;
            }
            if (!this.leaderPatternWidthEnable()) {
                this.mpoExtra.moUnit[9] = goDefaultMeasureNeg;
            }
            if (!this.ruleThicknessEnable()) {
                this.mpoExtra.moUnit[10] = goDefaultMeasureNeg;
            }
        }
    }

    public void debug() {
        this.debug(0);
    }

    void debug(int indent) {
        String prefix = Pkg.doIndent(indent + 1);
        System.out.println(prefix + "Text attribute");
        prefix = prefix + ' ';
        if (this.typefaceEnable()) {
            System.out.println(prefix + "Typeface:      " + this.typeface());
        }
        if (this.encodingEnable()) {
            System.out.println(prefix + "Encoding:      " + this.encoding());
        }
        if (this.sizeEnable()) {
            System.out.println(prefix + "Size:          " + this.size());
        }
        if (this.weightEnable()) {
            System.out.println(prefix + "Weight:        " + this.weight());
        }
        if (this.italicEnable()) {
            System.out.println(prefix + "Italic:        " + this.italic());
        }
        if (this.underlineEnable()) {
            System.out.println(prefix + "Underline:     " + this.underline());
        }
        if (this.overlineEnable()) {
            System.out.println(prefix + "Overline:      " + this.overline());
        }
        if (this.strikeoutEnable()) {
            System.out.println(prefix + "Strikeout:     " + this.strikeout());
        }
        if (this.colourEnable()) {
            System.out.println(prefix + "Colour:        " + this.colour().r() + " " + this.colour().g() + " " + this.colour().b());
        }
        if (this.colourBgEnable()) {
            System.out.println(prefix + "ColourBg:      " + this.colourBg().r() + " " + this.colourBg().g() + " " + this.colourBg().b());
        }
        if (this.styleEnable()) {
            System.out.println(prefix + "Style:         " + this.style());
        }
        if (this.shadeEnable()) {
            System.out.println(prefix + "Shade:         " + this.shade());
        }
        if (this.shadeScaleEnable()) {
            System.out.println(prefix + "ShadeScale:    " + this.shadeScale());
        }
        if (this.transparentEnable()) {
            System.out.println(prefix + "Transparent:   " + this.transparent());
        }
        if (this.spacingEnable()) {
            System.out.println(prefix + "Spacing:       " + this.spacing());
        }
        if (this.marginLEnable()) {
            System.out.println(prefix + "MarginL:       " + this.marginL());
        }
        if (this.marginREnable()) {
            System.out.println(prefix + "MarginR:       " + this.marginR());
        }
        if (this.justifyVEnable()) {
            System.out.println(prefix + "JustifyV:      " + this.justifyV());
        }
        if (this.justifyHEnable()) {
            System.out.println(prefix + "JustifyH:      " + this.justifyH());
        }
        if (this.radixOffsetEnable()) {
            System.out.println(prefix + "RadixOffset:   " + this.radixOffset());
        }
        if (this.radixPosEnable()) {
            System.out.println(prefix + "RadixPos:      " + this.radixPos());
        }
        if (this.specialEnable()) {
            System.out.println(prefix + "Special:       " + this.special());
        }
        if (this.spaceBeforeEnable()) {
            System.out.println(prefix + "SpaceBefore:   " + this.spaceBefore());
        }
        if (this.spaceAfterEnable()) {
            System.out.println(prefix + "SpaceAfter:    " + this.spaceAfter());
        }
        if (this.invisibleEnable()) {
            System.out.println(prefix + "Invisible:     " + this.invisible());
        }
        if (this.invisCharEnable()) {
            System.out.println(prefix + "InvisChar:     " + this.invisChar());
        }
        if (this.baselineShiftEnable()) {
            System.out.println(prefix + "BaselineShift: " + this.baselineShift().getString(false));
        }
        if (this.localeEnable()) {
            System.out.println(prefix + "Locale:        " + this.locale());
        }
        if (this.digitsEnable()) {
            System.out.println(prefix + "Digits:        " + this.digits());
        }
        if (this.directionEnable()) {
            System.out.println(prefix + "Direction:     " + this.direction());
        }
        if (this.ligatureEnable()) {
            System.out.println(prefix + "Ligature:      " + this.ligature());
        }
        if (this.tabsEnable()) {
            this.tabs().debug(indent + 1);
        }
    }

    private boolean bitTest(int nIndex, int nMask) {
        return (nMask & 1 << nIndex) != 0;
    }

    private int bitSet(int nIndex, int nMask, boolean bValue) {
        if (bValue) {
            return nMask | 1 << nIndex;
        }
        return nMask & ~(1 << nIndex);
    }

    private boolean getBoolValue(int nIndex) {
        return this.bitTest(nIndex, this.mbBoolValue);
    }

    private void setBoolValue(int nIndex, boolean bNewValue) {
        this.mbBoolValue = this.bitSet(nIndex, this.mbBoolValue, bNewValue);
        this.enableBool(nIndex, true);
    }

    private boolean isBoolEnabled(int nIndex) {
        return this.bitTest(nIndex, this.mbBoolEnable);
    }

    private void enableBool(int nIndex, boolean bEnable) {
        this.mbBoolEnable = this.bitSet(nIndex, this.mbBoolEnable, bEnable);
    }

    private TextMeasurement getUnitValue(int nIndex) {
        if (this.mpoExtra == null) {
            if (!this.isUnitEnabled(nIndex)) {
                switch (nIndex) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 6: 
                    case 9: 
                    case 10: {
                        return goDefaultMeasureNeg;
                    }
                }
            }
            return TextMeasurement.zero();
        }
        return this.mpoExtra.moUnit[nIndex];
    }

    private void setUnitValue(int nIndex, TextMeasurement oNewValue) {
        boolean bEnable = true;
        boolean bSet = false;
        if (nIndex == 0 || nIndex == 1 || nIndex == 2 || nIndex == 6 || nIndex == 9 || nIndex == 10) {
            int nValue = oNewValue.getLength().value();
            if (nValue > 0) {
                bSet = true;
            } else {
                if (this.mpoExtra != null) {
                    bSet = true;
                }
                if (nValue < 0) {
                    bEnable = false;
                }
            }
        } else if (oNewValue != this.getUnitValue(nIndex)) {
            bSet = true;
        }
        if (bSet) {
            this.needExtra();
            this.mpoExtra.moUnit[nIndex] = oNewValue;
        }
        this.enableUnit(nIndex, bEnable);
    }

    private boolean isUnitEnabled(int nIndex) {
        return this.bitTest(nIndex, this.mbUnitEnable);
    }

    private void enableUnit(int nIndex, boolean bEnable) {
        this.mbUnitEnable = this.bitSet(nIndex, this.mbUnitEnable, bEnable);
    }

    private int getIntValue(int nIndex) {
        if (this.mpoExtra == null) {
            return TextAttr.getDefaultIntValue(nIndex);
        }
        return this.mpoExtra.moInt[nIndex];
    }

    private void setIntValue(int nIndex, int oNewValue) {
        if (oNewValue != this.getIntValue(nIndex)) {
            this.needExtra();
            this.mpoExtra.moInt[nIndex] = oNewValue;
        }
        this.enableInt(nIndex, true);
    }

    public double getFloatValue(int nIndex) {
        if (!this.isFloatEnabled(nIndex)) {
            return -1.0;
        }
        if (this.mpoExtra == null) {
            return 1.0;
        }
        return this.mpoExtra.moFloat[nIndex];
    }

    public void setFloatValue(int nIndex, double nNewValue, boolean bEnable) {
        if (nNewValue < 0.0) {
            bEnable = false;
        }
        if (nNewValue != this.getFloatValue(nIndex)) {
            this.needExtra();
            this.mpoExtra.moFloat[nIndex] = nNewValue;
        }
        if (bEnable) {
            this.enableFloat(nIndex, true);
        }
    }

    public void setFloatValue(int nIndex, double nNewValue) {
        this.setFloatValue(nIndex, nNewValue, true);
    }

    public boolean isFloatEnabled(int nIndex) {
        return this.bitTest(nIndex, this.mbFloatEnable);
    }

    public void enableFloat(int nIndex, boolean bEnable) {
        this.mbFloatEnable = this.bitSet(nIndex, this.mbFloatEnable, bEnable);
    }

    private boolean isIntEnabled(int nIndex) {
        return this.bitTest(nIndex, this.mbIntEnable);
    }

    private void enableInt(int nIndex, boolean bEnable) {
        this.mbIntEnable = this.bitSet(nIndex, this.mbIntEnable, bEnable);
    }

    private ReconcileInfo reconcileFont(FontService poFontService, FontDesc oFontDesc) {
        double dVerticalScale;
        FontInfo oFontInfo = new FontInfo(oFontDesc.getTypeface(), oFontDesc.getWeight(), oFontDesc.getItalic());
        double dHorizontalScale = oFontDesc.getHorizontalScale();
        if (dHorizontalScale < 0.0) {
            dHorizontalScale = 1.0;
        }
        if ((dVerticalScale = oFontDesc.getVerticalScale()) < 0.0) {
            dVerticalScale = 1.0;
        }
        FontInstance oFontInstance = poFontService.reconcile(oFontInfo, this.size(), dHorizontalScale, dVerticalScale);
        assert (oFontInstance != null);
        String sOriginalTypeface = oFontInfo.equals(oFontInstance.getFontItem()) ? "" : oFontDesc.getTypeface();
        return new ReconcileInfo(oFontInstance, sOriginalTypeface);
    }

    private void cleanupGfxTextAttr() {
    }

    private void cleanupFont() {
        if (this.moFontInstance != null) {
            this.msOriginalTypeface = "";
            this.moFontInstance = null;
        }
    }

    private boolean canFlattenBaselineShift() {
        if (!this.baselineShiftEnable()) {
            return false;
        }
        TextBaselineShift oOldShift = this.baselineShift();
        if (oOldShift.isNeutral()) {
            return false;
        }
        return oOldShift.getType() == 3 || oOldShift.getType() == 4;
    }

    private static class ReconcileInfo {
        final FontInstance mFontInstance;
        final String mOriginalTypeface;

        ReconcileInfo(FontInstance fontInstance, String originalTypeface) {
            this.mFontInstance = fontInstance;
            this.mOriginalTypeface = originalTypeface;
        }
    }

    private static class AttrExtra {
        TextMeasurement[] moUnit;
        int[] moInt;
        boolean[] moBool;
        double[] moFloat;
        TextBaselineShift moShift;
        TextAttr mpoOriginalAttr;
        TextStream mpoLeaderContent;

        AttrExtra() {
            this.initialize();
        }

        void initialize() {
            int i;
            this.moUnit = new TextMeasurement[11];
            this.moInt = new int[15];
            this.moFloat = new double[2];
            this.moBool = new boolean[6];
            for (i = 0; i < 11; ++i) {
                this.moUnit[i] = TextMeasurement.zero();
            }
            for (i = 0; i < 15; ++i) {
                this.moInt[i] = TextAttr.getDefaultIntValue(i);
            }
            for (i = 0; i < 2; ++i) {
                this.moFloat[i] = 1.0;
            }
            for (i = 0; i < 6; ++i) {
                this.moBool[i] = false;
            }
        }

        public void setLeaderContent(TextStream oLeaderContent, FontService poFontService) {
            this.clearLeaderContent();
            this.mpoLeaderContent = new TextStream(oLeaderContent);
            this.mpoLeaderContent.fontService(poFontService);
        }

        public void clearLeaderContent() {
            this.mpoLeaderContent = null;
        }

        void copyFrom(AttrExtra oSource) {
            int i;
            for (i = 0; i < 11; ++i) {
                this.moUnit[i] = oSource.moUnit[i];
            }
            for (i = 0; i < 15; ++i) {
                this.moInt[i] = oSource.moInt[i];
            }
            for (i = 0; i < 2; ++i) {
                this.moFloat[i] = oSource.moFloat[i];
            }
            for (i = 0; i < 6; ++i) {
                this.moBool[i] = oSource.moBool[i];
            }
            this.moShift = oSource.moShift;
            this.mpoOriginalAttr = oSource.mpoOriginalAttr;
            if (oSource.mpoLeaderContent != null) {
                this.setLeaderContent(oSource.mpoLeaderContent, oSource.mpoLeaderContent.fontService());
            } else {
                this.clearLeaderContent();
            }
        }
    }

    static class FontDesc {
        public static final int VALUE_ABSENT = 0;
        public static final int VALUE_PRESENT = 1;
        public static final int VALUE_VALID = 2;
        private String msTypeface;
        private String msEncoding;
        private UnitSpan moSize;
        private int mnWeight;
        private double mnHorizontalScale;
        private double mnVerticalScale;
        private boolean mbItalic;
        private boolean mbTypefacePresent;
        private boolean mbEncodingPresent;
        private boolean mbSizePresent;
        private boolean mbWeightPresent;
        private boolean mbItalicPresent;
        private boolean mbHorizontalScalePresent;
        private boolean mbVerticalScalePresent;

        public FontDesc() {
            this.initialize();
        }

        public FontDesc(TextAttr oAttr) {
            this.initialize();
            this.setAttr(oAttr);
        }

        public FontDesc(String sTypeface) {
            this.initialize();
            this.setTypeface(sTypeface);
        }

        public FontDesc(UnitSpan oSize) {
            this.initialize();
            this.setSize(oSize);
        }

        public FontDesc(int nWeight) {
            this.initialize();
            this.setWeight(nWeight);
        }

        public void setAttr(TextAttr oAttr) {
            this.setTypeface(oAttr.typeface());
            this.setEncoding(oAttr.encoding());
            this.setSize(oAttr.size());
            this.setWeight(oAttr.weight());
            this.setItalic(oAttr.italic(), oAttr.italicEnable());
            this.setHorizontalScale(oAttr.horizontalScale(), oAttr.horizontalScaleEnable());
            this.setVerticalScale(oAttr.verticalScale(), oAttr.verticalScaleEnable());
        }

        public int hasTypeface() {
            if (!this.mbTypefacePresent) {
                return 0;
            }
            if (this.msTypeface == null || this.msTypeface.length() == 0) {
                return 1;
            }
            return 2;
        }

        public String getTypeface() {
            return this.msTypeface;
        }

        public void setTypeface(String sTypeface) {
            this.msTypeface = sTypeface;
            this.mbTypefacePresent = true;
        }

        public int hasEncoding() {
            if (!this.mbEncodingPresent) {
                return 0;
            }
            if (this.msEncoding == null || this.msEncoding.length() == 0) {
                return 1;
            }
            return 2;
        }

        public String getEncoding() {
            return this.msEncoding;
        }

        public void setEncoding(String sEncoding) {
            this.msEncoding = sEncoding;
            this.mbEncodingPresent = true;
        }

        public int hasSize() {
            if (!this.mbSizePresent) {
                return 0;
            }
            if (this.moSize.value() < 0) {
                return 1;
            }
            return 2;
        }

        public UnitSpan getSize() {
            return this.moSize;
        }

        public void setSize(UnitSpan oSize) {
            this.moSize = oSize;
            this.mbSizePresent = true;
        }

        public int hasWeight() {
            if (!this.mbWeightPresent) {
                return 0;
            }
            if (this.mnWeight == 0) {
                return 1;
            }
            return 2;
        }

        public int getWeight() {
            return this.mnWeight;
        }

        public void setWeight(int nWeight) {
            this.mnWeight = nWeight == 0 ? nWeight : FontDesc.coerceWeight(nWeight);
            this.mbWeightPresent = true;
        }

        public static int coerceWeight(int nWeight) {
            return nWeight >= 700 ? 700 : 400;
        }

        public int hasItalic() {
            if (!this.mbItalicPresent) {
                return 0;
            }
            return 2;
        }

        public boolean getItalic() {
            return this.mbItalic;
        }

        public void setItalic(boolean bItalic, boolean bEnable) {
            this.mbItalic = bItalic;
            this.mbItalicPresent = bEnable;
        }

        public void setItalic(boolean bItalic) {
            this.setItalic(bItalic, true);
        }

        public int hasHorizontalScale() {
            if (!this.mbHorizontalScalePresent) {
                return 0;
            }
            if (this.mnHorizontalScale <= 0.0) {
                return 1;
            }
            return 2;
        }

        public double getHorizontalScale() {
            return this.mnHorizontalScale;
        }

        public void setHorizontalScale(double nHorizontalScale, boolean bEnable) {
            this.mnHorizontalScale = nHorizontalScale;
            this.mbHorizontalScalePresent = bEnable;
        }

        public void setHorizontalScale(double nHorizontalScale) {
            this.setHorizontalScale(nHorizontalScale, true);
        }

        public int hasVerticalScale() {
            if (!this.mbVerticalScalePresent) {
                return 0;
            }
            if (this.mnVerticalScale <= 0.0) {
                return 1;
            }
            return 2;
        }

        public double getVerticalScale() {
            return this.mnVerticalScale;
        }

        public void setVerticalScale(double nVerticalScale, boolean bEnable) {
            this.mnVerticalScale = nVerticalScale;
            this.mbVerticalScalePresent = bEnable;
        }

        public void setVerticalScale(double nVerticalScale) {
            this.setVerticalScale(nVerticalScale, true);
        }

        public boolean isEmpty() {
            return this.hasTypeface() == 0 && this.hasEncoding() == 0 && this.hasSize() == 0 && this.hasWeight() == 0 && this.hasItalic() == 0 && this.hasHorizontalScale() == 0 && this.hasVerticalScale() == 0;
        }

        public boolean isValid() {
            return this.hasTypeface() == 2 && this.hasSize() == 2 && this.hasWeight() == 2 && this.hasItalic() == 2;
        }

        private void initialize() {
            this.moSize = new UnitSpan(19, -1);
            this.mnWeight = 0;
            this.mbItalic = false;
            this.mnHorizontalScale = -1.0;
            this.mnVerticalScale = -1.0;
            this.mbTypefacePresent = false;
            this.mbEncodingPresent = false;
            this.mbSizePresent = false;
            this.mbWeightPresent = false;
            this.mbItalicPresent = false;
            this.mbHorizontalScalePresent = false;
            this.mbVerticalScalePresent = false;
        }
    }
}

