/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXLineAttr;
import com.adobe.xfa.text.ABXY;
import com.adobe.xfa.text.DrawAttr;
import com.adobe.xfa.text.DrawParm;
import com.adobe.xfa.text.LeaderFill;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.UnitSpan;

class LeaderRule
extends LeaderFill {
    private static final double RULE_DASH_PATTERN_WIDTH_RATIO = 0.666667;
    private static final double RULE_DASH_THICKNESS_RATIO = 4.0;
    private static final double RULE_WIDTH_THICKNESS_RATIO = 6.0;
    private final DrawAttr moDrawAttr;
    private GFXLineAttr moLineAttr;
    private UnitSpan moRuleThickness;

    LeaderRule(DrawParm oDrawParm, DrawAttr oDrawAttr) {
        super(oDrawParm);
        this.moDrawAttr = oDrawAttr;
    }

    @Override
    boolean onSetup() {
        assert (this.attr().leaderPattern() == 1);
        if (!this.attr().ruleStyleEnable()) {
            return false;
        }
        if (!this.attr().ruleThicknessEnable()) {
            return false;
        }
        this.moRuleThickness = this.attr().ruleThickness().getLength();
        if (this.moRuleThickness.value() <= 0) {
            return false;
        }
        switch (this.attr().ruleStyle()) {
            case 1: {
                this.setBasePatternWidth(this.tabWidth());
                this.setPatternWidth(this.tabWidth());
                this.setSuppressAlign(true);
                break;
            }
            case 2: {
                this.setBasePatternWidth(this.moRuleThickness);
                UnitSpan oWidth = this.moRuleThickness.multiply(2);
                if (!this.patternWidth().lt(oWidth)) break;
                this.setPatternWidth(oWidth);
                break;
            }
            case 3: {
                if (this.patternWidth().value() <= 0) {
                    this.setBasePatternWidth(this.moRuleThickness.multiply(4.0));
                    this.setPatternWidth(this.moRuleThickness.multiply(6.0));
                    break;
                }
                this.setBasePatternWidth(this.patternWidth().multiply(0.666667));
                break;
            }
            default: {
                return false;
            }
        }
        this.setRenderGlyph(true);
        return true;
    }

    @Override
    void onRender(UnitSpan oOffsetX) {
        if (this.moLineAttr == null) {
            this.moLineAttr = new GFXLineAttr();
            this.moLineAttr.colour(this.moDrawAttr.getGfxAttr().colour());
            this.moLineAttr.colourBg(this.moDrawAttr.getGfxAttr().colour());
            this.moLineAttr.style(2);
            this.moLineAttr.width(this.moRuleThickness);
            this.moLineAttr.hand(2);
            this.moLineAttr.cap(0);
            this.driver().lineAttr(this.moLineAttr);
        }
        CoordPair oStart = new CoordPair(oOffsetX, this.textOffset());
        oStart = ABXY.toXY(this.line().getXYOrigin(), oStart, this.line().frame().getLayoutOrientation());
        CoordPair oEnd = new CoordPair(oOffsetX.add(this.basePatternWidth()), this.textOffset());
        oEnd = ABXY.toXY(this.line().getXYOrigin(), oEnd, this.line().frame().getLayoutOrientation());
        this.driver().relLine(oStart, oEnd);
    }
}

