/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.InterElementAttribute;
import com.adobe.fontengine.inlineformatting.LigatureLevel;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import com.adobe.xfa.font.FontInstance;
import com.adobe.xfa.text.AFEAttrMap;
import com.adobe.xfa.text.AFEAttrSet;
import com.adobe.xfa.text.DispRun;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.Units;
import java.util.List;

class AFEFixedAttr
extends AFEAttrSet {
    private static final DebugInfo[] gDebugInfo = new DebugInfo[]{new DebugInfo(ElementAttribute.CSS20Attribute, "Font"), new DebugInfo(ElementAttribute.locale, "Locale"), new DebugInfo(ElementAttribute.bidiLevel, "BIDI"), new DebugInfo(InterElementAttribute.ligatureLevel, "Ligature")};
    private static final Integer BIDI_DEFAULT_LTR = 0;
    private static final Integer BIDI_DEFAULT_RTL = 1;
    private FontInstance mFontInstance;
    private String mLocale;
    private int mBIDILevel;
    private boolean mLigature;
    private CSS20Attribute mAFEAttrs;
    private Font mAFEFont;
    private Double mAFESize;
    private ULocale mAFELocale;
    private Integer mAFEBIDILevel;
    private Object mAFELigature;
    private double mFontSize;
    private double mFontXScale;
    private double mFontYScale;
    private double mCTXScale;
    private double mCTYScale;

    AFEFixedAttr(AFEAttrMap afeAttrMap) {
        super(afeAttrMap);
    }

    boolean populate(DispRun dispRun, int bidiLevel) {
        TextAttr textAttr = dispRun.getAttr();
        this.mLigature = false;
        this.mAFELigature = LigatureLevel.MINIMUM;
        if (dispRun.allowLigatures()) {
            this.mLigature = true;
            this.mAFELigature = LigatureLevel.COMMON;
        }
        this.mBIDILevel = bidiLevel;
        switch (bidiLevel) {
            case 0: {
                this.mAFEBIDILevel = BIDI_DEFAULT_LTR;
                break;
            }
            case 1: {
                this.mAFEBIDILevel = BIDI_DEFAULT_RTL;
                break;
            }
            default: {
                this.mAFEBIDILevel = bidiLevel;
            }
        }
        this.mFontInstance = textAttr.fontInstance();
        String[] familyNames = new String[]{this.mFontInstance.getTypeface()};
        this.mFontSize = Units.toFloat(this.mFontInstance.getSize());
        CSS20Attribute.CSSStyleValue italic = textAttr.italic() ? CSS20Attribute.CSSStyleValue.ITALIC : CSS20Attribute.CSSStyleValue.NORMAL;
        CSS20Attribute.CSSWeightValue weight = textAttr.weight() >= 700 ? CSS20Attribute.CSSWeightValue.BOLD : CSS20Attribute.CSSWeightValue.NORMAL;
        this.mAFEAttrs = new CSS20Attribute(familyNames, italic, CSS20Attribute.CSSVariantValue.NORMAL, CSS20Attribute.CSSStretchValue.NORMAL, weight, this.mFontSize);
        this.mAFEFont = this.mFontInstance.getAFEFont();
        this.mAFESize = new Double(this.mFontSize);
        this.mLocale = textAttr.actualLocale();
        this.mAFELocale = new ULocale(this.mLocale);
        try {
            this.mCTXScale = this.mAFEFont.getUnitsPerEmX();
            this.mCTYScale = this.mAFEFont.getUnitsPerEmY();
            if (this.mCTXScale != 0.0) {
                this.mFontXScale = this.mFontSize / this.mCTXScale;
            }
            if (this.mCTYScale != 0.0) {
                this.mFontYScale = this.mFontSize / this.mCTYScale;
            }
        }
        catch (Exception e) {
            assert (false);
            return false;
        }
        return true;
    }

    @Override
    Object getAttr(Object key) {
        if (key == ElementAttribute.CSS20Attribute) {
            return this.mAFEAttrs;
        }
        if (key == ElementAttribute.font) {
            return this.mAFEFont;
        }
        if (key == ElementAttribute.pointSize) {
            return this.mAFESize;
        }
        if (key == ElementAttribute.bidiLevel) {
            return this.mAFEBIDILevel;
        }
        if (key == InterElementAttribute.ligatureLevel) {
            return this.mAFELigature;
        }
        if (key == ElementAttribute.locale) {
            return this.mAFELocale;
        }
        return null;
    }

    FontInstance getFontInstance() {
        return this.mFontInstance;
    }

    double getFontSize() {
        return this.mFontSize;
    }

    double getFontXScale() {
        return this.mFontXScale;
    }

    double getFontYScale() {
        return this.mFontYScale;
    }

    double getCTXScale() {
        return this.mCTXScale;
    }

    double getCTYScale() {
        return this.mCTYScale;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < gDebugInfo.length; ++i) {
            if (result.length() > 0) {
                result.append(", ");
            }
            DebugInfo info = gDebugInfo[i];
            Object key = info.mKey;
            Object value = this.getAttr(key);
            if (value == null) continue;
            result.append(info.mName);
            result.append(": ");
            if (key == ElementAttribute.CSS20Attribute) {
                CSS20Attribute css20Attr = (CSS20Attribute)value;
                result.append("(" + AFEFixedAttr.cssToString(css20Attr) + ")");
                continue;
            }
            result.append(value.toString());
        }
        return result.toString();
    }

    @Override
    public int compareTo(AFEAttrSet compare) {
        if (compare == this) {
            return 0;
        }
        if (compare == null) {
            throw new NullPointerException();
        }
        if (!(compare instanceof AFEFixedAttr)) {
            return 1;
        }
        AFEFixedAttr other = (AFEFixedAttr)compare;
        int result = this.mFontInstance.compareTo(other.mFontInstance);
        if (result != 0) {
            return result;
        }
        result = this.mLocale.compareTo(other.mLocale);
        if (result != 0) {
            return 0;
        }
        if (this.mBIDILevel < other.mBIDILevel) {
            return -1;
        }
        if (this.mBIDILevel < other.mBIDILevel) {
            return 1;
        }
        if (this.mLigature != other.mLigature) {
            return this.mLigature ? 1 : -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        AFEFixedAttr other = (AFEFixedAttr)object;
        if (!this.mFontInstance.equals(other.mFontInstance)) {
            return false;
        }
        if (!this.mLocale.equals(other.mLocale)) {
            return false;
        }
        if (this.mBIDILevel != other.mBIDILevel) {
            return false;
        }
        return this.mLigature == other.mLigature;
    }

    public int hashCode() {
        int result = this.mFontInstance.hashCode();
        result = result * 31 ^ this.mLocale.hashCode();
        result = result * 31 ^ this.mBIDILevel;
        result = result * 31 ^ Boolean.valueOf(this.mLigature).hashCode();
        return result;
    }

    private static String cssToString(CSS20Attribute attr) {
        List names = attr.getFamilyNamesList();
        String result = "Face: " + (String)names.get(0);
        result = result + ", Italic: " + (attr.getStyle() == CSS20Attribute.CSSStyleValue.ITALIC ? "yes" : "no");
        result = result + ", Weight: " + (attr.getWeight() >= 700 ? "bold" : "normal");
        result = result + ", Size: " + attr.getPointSize();
        return result;
    }

    private static class DebugInfo {
        Object mKey;
        String mName;

        DebugInfo(Object key, String name) {
            this.mKey = key;
            this.mName = name;
        }
    }
}

