/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.protocol;

import com.adobe.xfa.protocol.AuthenticationHandler;
import com.adobe.xfa.protocol.Protocol;
import com.adobe.xfa.protocol.ProtocolUtils;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.Resolver;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.List;
import java.util.Map;

public class SysProtocol
implements Protocol {
    protected final AuthenticationHandler mAuthHandler;
    protected final URLStreamHandler mURLStreamHandler;
    private static final int BUFFSIZE = 1024;

    public SysProtocol() {
        this(null, null);
    }

    public SysProtocol(AuthenticationHandler authenticationHandler, URLStreamHandler urlStreamHandler) {
        this.mAuthHandler = authenticationHandler;
        this.mURLStreamHandler = urlStreamHandler;
        Resolver.setProtocol(this);
    }

    @Override
    public InputStream get(String sUrl) {
        URL url = null;
        URLConnection connection = null;
        InputStream iFile = null;
        try {
            url = new URL(sUrl);
            connection = url.openConnection();
            connection.setUseCaches(true);
            iFile = connection.getInputStream();
        }
        catch (MalformedURLException e) {
            ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_READ, sUrl));
            ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
            oEx.insert(oSysEx, true);
            throw oEx;
        }
        catch (IOException e) {
            ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_READ, sUrl));
            ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
            oEx.insert(oSysEx, true);
            throw oEx;
        }
        return iFile;
    }

    @Override
    public void put(String sFileName, String sUrl) {
        InputStream iFile = null;
        try {
            iFile = new BufferedInputStream(new FileInputStream(sFileName));
            this.put(iFile, sUrl);
        }
        catch (IOException e) {
            ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_WRITE, sUrl));
            ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
            oEx.insert(oSysEx, true);
            throw oEx;
        }
        finally {
            try {
                if (iFile != null) {
                    iFile.close();
                }
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void put(InputStream iFile, String sUrl) {
        URL url = null;
        URLConnection connection = null;
        OutputStream oFile = null;
        try {
            HttpURLConnection httpConnection;
            url = new URL(sUrl);
            connection = url.openConnection();
            connection.setUseCaches(true);
            connection.setDoOutput(true);
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setRequestMethod("PUT");
            }
            oFile = connection.getOutputStream();
            byte[] buf = new byte[1024];
            int iCnt = 0;
            while ((iCnt = iFile.read(buf)) != -1) {
                oFile.write(buf, 0, iCnt);
            }
            if (connection instanceof HttpURLConnection && (httpConnection = (HttpURLConnection)connection).getResponseCode() >= 300) {
                ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_WRITE, sUrl));
                ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, httpConnection.getResponseMessage()));
                oEx.insert(oSysEx, true);
                throw oEx;
            }
        }
        catch (MalformedURLException e) {
            ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_WRITE, sUrl));
            ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
            oEx.insert(oSysEx, true);
            throw oEx;
        }
        catch (IOException e) {
            ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_WRITE, sUrl));
            ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
            oEx.insert(oSysEx, true);
            throw oEx;
        }
        finally {
            try {
                if (oFile != null) {
                    oFile.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Protocol.PostRsvp post(Protocol.SimplePostData oData, String sUrl) {
        URL url = null;
        HttpURLConnection connection = null;
        String sResponseType = null;
        byte[] response = null;
        ExFull exception = null;
        try {
            url = new URL(sUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            if (oData.headerMap != null && oData.headerMap.size() > 0) {
                for (Map.Entry<String, String> entry : oData.headerMap.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            } else {
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            }
            OutputStream out = connection.getOutputStream();
            try {
                if (oData.data != null) {
                    out.write(oData.data);
                    out.flush();
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            InputStream responseStream = connection.getResponseCode() >= 300 ? connection.getErrorStream() : connection.getInputStream();
            try {
                response = this.readResponseStream(responseStream, connection.getContentLength());
            }
            finally {
                if (responseStream != null) {
                    try {
                        responseStream.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            sResponseType = connection.getContentType();
            if (connection.getResponseCode() >= 300) {
                ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_POST, sUrl));
                String detail = response == null ? connection.getResponseMessage() : new String(response, this.getResponseCharset(sResponseType));
                ExFull oSysEx = new ExFull(detail, ResId.PROTOCOL_ERR_SYS);
                oEx.insert(oSysEx, true);
                exception = oEx;
            }
        }
        catch (MalformedURLException e) {
            ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_POST, sUrl));
            ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
            oEx.insert(oSysEx, true);
            exception = oEx;
        }
        catch (IOException e) {
            ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_POST, sUrl));
            ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
            oEx.insert(oSysEx, true);
            exception = oEx;
        }
        return new Protocol.PostRsvp(0, sResponseType, response, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Protocol.PostRsvp post(List<? extends Protocol.MultiPartDesc> oData, String sUrl) {
        URL url = null;
        HttpURLConnection connection = null;
        ExFull exception = null;
        String sResponseType = null;
        byte[] response = null;
        try {
            url = new URL(sUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("MIME-version", "1.0");
            byte[] boundary = ProtocolUtils.mimeBoundary(null);
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + new String(boundary, "US-ASCII"));
            connection.setRequestMethod("POST");
            OutputStream out = connection.getOutputStream();
            boolean bReset = true;
            byte[] name = null;
            byte[] file = null;
            byte[] type = null;
            byte[] value = null;
            for (Protocol.MultiPartDesc multiPartDesc : oData) {
                Protocol.SectionDataOption eOption;
                if (bReset) {
                    value = null;
                    type = null;
                    file = null;
                    name = null;
                    bReset = false;
                }
                if ((eOption = multiPartDesc.eSectionDataOption) != Protocol.SectionDataOption.SECTION_END) {
                    if (eOption == Protocol.SectionDataOption.SECTION_CONTENT_NAME) {
                        name = multiPartDesc.value;
                        continue;
                    }
                    if (eOption == Protocol.SectionDataOption.SECTION_CONTENT_FILE) {
                        file = multiPartDesc.value;
                        continue;
                    }
                    if (eOption == Protocol.SectionDataOption.SECTION_CONTENT_TYPE) {
                        type = multiPartDesc.value;
                        continue;
                    }
                    if (eOption != Protocol.SectionDataOption.SECTION_CONTENT_VALUE) continue;
                    value = multiPartDesc.value;
                    continue;
                }
                out.write(ProtocolUtils.mimeSection(boundary, name, file, type, value));
                out.write(ProtocolUtils.mimeTrailer(boundary));
                out.flush();
                bReset = true;
            }
            out.close();
            if (connection.getResponseCode() >= 300) {
                ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_POST, sUrl));
                ExFull exFull = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, connection.getResponseMessage()));
                oEx.insert(exFull, true);
                exception = oEx;
            }
            sResponseType = connection.getContentType();
            InputStream responseStream = connection.getInputStream();
            try {
                response = this.readResponseStream(responseStream, connection.getContentLength());
            }
            finally {
                if (responseStream != null) {
                    try {
                        responseStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (MalformedURLException e) {
            ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_POST, sUrl));
            ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
            oEx.insert(oSysEx, true);
            exception = oEx;
        }
        catch (IOException e) {
            ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_POST, sUrl));
            ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
            oEx.insert(oSysEx, true);
            exception = oEx;
        }
        return new Protocol.PostRsvp(0, sResponseType, response, exception);
    }

    private byte[] readResponseStream(InputStream responseStream, int nContentLength) throws IOException {
        if (responseStream == null) {
            return null;
        }
        byte[] response = null;
        if (nContentLength != -1) {
            response = new byte[nContentLength];
            int nBytesRead = responseStream.read(response);
            assert (nBytesRead == nContentLength);
        } else {
            int nBytesRead;
            ByteArrayOutputStream responseBuffer = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((nBytesRead = responseStream.read(buffer)) != -1) {
                responseBuffer.write(buffer, 0, nBytesRead);
            }
            response = responseBuffer.toByteArray();
        }
        return response;
    }

    private String getResponseCharset(String sResponseType) {
        int i;
        String sCharset = "ISO-8859-1";
        if (sResponseType != null && (i = sResponseType.indexOf("charset=")) != -1) {
            int endIndex;
            int beginIndex = i + "charset=".length();
            int endDelimiter = 59;
            if (beginIndex < sResponseType.length() && sResponseType.charAt(beginIndex) == '\"') {
                ++beginIndex;
                endDelimiter = 34;
            }
            if ((endIndex = sResponseType.indexOf(endDelimiter, beginIndex)) == -1) {
                endIndex = sResponseType.length();
            }
            sCharset = endIndex == -1 ? sResponseType.substring(beginIndex) : sResponseType.substring(beginIndex, endIndex);
        }
        return sCharset;
    }

    @Override
    public AuthenticationHandler getAuthenticationHandler() {
        return this.mAuthHandler;
    }

    @Override
    public URLStreamHandler getURLStreamHandler() {
        return this.mURLStreamHandler;
    }

    @Override
    public boolean isTrusted(String sURL, Protocol.TrustType eTrustType, boolean bThrow) {
        return true;
    }

    @Override
    public String scheme() {
        return "";
    }
}

