/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.formcalc.CalcSymbol;

public final class Stack {
    static final int SIZE = 64;
    private int mnStackSize;
    private CalcSymbol[] moStackBase;
    private int moStackPtr;

    Stack() {
    }

    int create(int nStackSize) {
        this.mnStackSize = nStackSize;
        this.moStackBase = new CalcSymbol[this.mnStackSize];
        this.moStackPtr = 0;
        return 1;
    }

    void init() {
        for (int i = 0; i < this.mnStackSize; ++i) {
            this.moStackBase[i] = null;
        }
        this.moStackPtr = 0;
    }

    CalcSymbol pop() {
        assert (this.moStackPtr > 0);
        return this.moStackBase[--this.moStackPtr];
    }

    void push(CalcSymbol sym) {
        if (this.moStackPtr >= this.mnStackSize) {
            this.mnStackSize <<= 1;
            CalcSymbol[] oNewBase = new CalcSymbol[this.mnStackSize];
            System.arraycopy(this.moStackBase, 0, oNewBase, 0, this.mnStackSize >> 1);
            this.moStackBase = oNewBase;
            this.moStackPtr = this.mnStackSize >> 1;
        }
        this.moStackBase[this.moStackPtr++] = sym;
    }

    int getOffset() {
        return this.moStackPtr;
    }

    public CalcSymbol peek(int nOffset) {
        assert (0 <= nOffset && nOffset <= this.moStackPtr);
        return this.moStackBase[nOffset];
    }
}

