/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.UuidFactory;
import java.util.ArrayList;
import java.util.List;

public final class IDValueMap {
    private Model mpoInstalledModelImpl;
    private IDValueMap mpoModelPreviousIDValueMap;
    private String msPrefix;
    private final List<String> mReferenceList = new ArrayList<String>();

    public void destroy() {
        if (this.mpoInstalledModelImpl != null) {
            this.mpoInstalledModelImpl.setIDValueMap(this.mpoModelPreviousIDValueMap);
        }
    }

    public void installOnModel(Model poModelImpl) {
        this.mpoModelPreviousIDValueMap = poModelImpl.getIDValueMap();
        this.mpoInstalledModelImpl = poModelImpl;
        this.mpoInstalledModelImpl.setIDValueMap(this);
    }

    public String getPrefix() {
        if (StringUtils.isEmpty(this.msPrefix)) {
            this.msPrefix = UuidFactory.getUuid();
        }
        return this.msPrefix;
    }

    public List<String> getReferenceList() {
        return this.mReferenceList;
    }

    public boolean isActive() {
        return this.mpoInstalledModelImpl != null;
    }

    public boolean verifySelfContained(String sHRefExpression, String sNodeContainingHRef, Node srcNode) {
        if (this.mpoInstalledModelImpl == null) {
            return true;
        }
        for (int i = 0; i < this.mReferenceList.size(); ++i) {
            Element targetNode;
            String sReference = this.mReferenceList.get(i);
            for (targetNode = srcNode.getModel().getNode(sReference); targetNode != null && targetNode != srcNode; targetNode = targetNode.getXMLParent()) {
            }
            if (targetNode != null) continue;
            MsgFormatPos message = new MsgFormatPos(ResId.FragmentIDNotSelfContained);
            message.format(sReference);
            message.format(sHRefExpression);
            message.format(sNodeContainingHRef);
            this.mpoInstalledModelImpl.addErrorList(new ExFull(message), 3, this.mpoInstalledModelImpl);
            return false;
        }
        return true;
    }
}

