/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.reef.siren.builder;

import com.adobe.reef.siren.Field;
import com.adobe.reef.siren.builder.Builder;
import com.adobe.reef.siren.builder.BuilderException;
import com.adobe.reef.siren.builder.BuilderValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldBuilder
extends Builder<Field> {
    private String name;
    private String title;
    private Field.FieldType type = Field.FieldType.TEXT;
    private String value;

    public FieldBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public FieldBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public FieldBuilder setType(Field.FieldType type) {
        this.type = type;
        return this;
    }

    public FieldBuilder setValue(String value) {
        this.value = value;
        return this;
    }

    public FieldBuilder clear() {
        this.name = null;
        this.title = null;
        this.type = null;
        this.value = null;
        return this;
    }

    @Override
    protected Field doBuild() throws BuilderException {
        try {
            Field field = new Field(this.name);
            field.setTitle(this.title);
            field.setType(this.type);
            field.setValue(this.value);
            return field;
        }
        catch (IllegalArgumentException e) {
            throw new BuilderException(e.getMessage(), e);
        }
    }

    @Override
    protected void validate(Field field) throws BuilderValidationException {
        if (field.getName() == null || field.getName().isEmpty()) {
            throw new BuilderValidationException("name cannot be null or empty.");
        }
    }
}

