/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

class HuffTree {
    static final int BMAX = 15;
    static final int N_MAX = 288;
    static final int EXOP_TYPE_MASK = 224;
    static final int EXOP_UNIBYTE_LITERAL = 0;
    static final int EXOP_SUBTREE = 0;
    static final int EXOP_LEN_DIST = 64;
    static final int EXOP_END_OF_BLOCK = 96;
    static final int EXOP_ILLEGAL_CODE = 192;
    static final int EXOP_MULTIBYTE_LITERAL = 160;
    protected byte[] Exop;
    protected byte[] Bits;
    protected int[] Base;
    protected int maxLook;

    public HuffTree(int[] b, int n, int s, short[] d, byte[] e, int m) {
        int maxCodeLength;
        int minCodeLength;
        int i;
        int[] codeCount = new int[16];
        int[] u = new int[15];
        int[] v = new int[288];
        int[] x = new int[16];
        this.Exop = null;
        this.Bits = null;
        this.Base = null;
        for (i = 0; i <= 15; ++i) {
            codeCount[i] = 0;
        }
        for (i = 0; i < n; ++i) {
            int n2 = b[i];
            codeCount[n2] = codeCount[n2] + 1;
        }
        if (codeCount[0] == n) {
            return;
        }
        for (minCodeLength = 1; minCodeLength <= 15 && codeCount[minCodeLength] <= 0; ++minCodeLength) {
        }
        for (maxCodeLength = 15; maxCodeLength > 0 && codeCount[maxCodeLength] <= 0; --maxCodeLength) {
        }
        this.maxLook = m;
        if (this.maxLook < minCodeLength) {
            this.maxLook = minCodeLength;
        }
        if (this.maxLook > maxCodeLength) {
            this.maxLook = maxCodeLength;
        }
        int nt_carry = 1 << minCodeLength - 1;
        for (i = minCodeLength; i <= maxCodeLength; ++i) {
            if ((nt_carry <<= 1) < codeCount[i]) {
                return;
            }
            nt_carry -= codeCount[i];
        }
        if (1 << this.maxLook < nt_carry) {
            return;
        }
        int n3 = maxCodeLength;
        codeCount[n3] = codeCount[n3] + nt_carry;
        int n_terms = 0;
        int n_links = 1;
        int t_avail = 0;
        int t_needed = 0;
        for (i = minCodeLength; i <= maxCodeLength; ++i) {
            int lev_diff = (i - 1) % this.maxLook + 1;
            int n_tables = 0;
            n_terms = 2 * n_terms + codeCount[i];
            if (lev_diff == this.maxLook) {
                n_tables = n_links;
                n_links = (n_tables << this.maxLook) - n_terms;
                n_terms = 0;
            } else if (this.maxLook < i || i == maxCodeLength) {
                n_tables = n_terms >> lev_diff;
                n_links -= n_tables;
                n_terms -= n_tables << lev_diff;
            }
            t_needed += n_tables << lev_diff;
        }
        this.Exop = new byte[t_needed];
        this.Bits = new byte[t_needed];
        this.Base = new int[t_needed];
        x[0] = 0;
        x[1] = 0;
        for (i = 1; i < maxCodeLength; ++i) {
            x[i + 1] = x[i] + codeCount[i];
        }
        for (i = 0; i < n; ++i) {
            if (b[i] == 0) continue;
            int n4 = b[i];
            int n5 = x[n4];
            x[n4] = n5 + 1;
            v[n5] = i;
        }
        n = x[maxCodeLength];
        i = 0;
        int p = 0;
        int h = -1;
        int w = -this.maxLook;
        u[0] = 0;
        int q = 0;
        int z = 0;
        for (int k = minCodeLength; k <= maxCodeLength; ++k) {
            int a = codeCount[k];
            while (a-- > 0) {
                int r_base;
                int r_exop;
                byte r_bits;
                int j;
                int f;
                while (k > w + this.maxLook) {
                    ++h;
                    z = maxCodeLength - (w += this.maxLook);
                    if (this.maxLook < z) {
                        z = this.maxLook;
                    }
                    if ((f = 1 << (j = k - w)) > a + 1) {
                        f -= a + 1;
                        int xp = k;
                        if (j < z) {
                            while (++j < z && (f <<= 1) > codeCount[++xp]) {
                                f -= codeCount[xp];
                            }
                        }
                    }
                    z = 1 << j;
                    q = t_avail;
                    t_avail += z;
                    u[h] = q;
                    if (h <= 0) continue;
                    x[h] = i;
                    r_bits = (byte)this.maxLook;
                    r_exop = (byte)(0 + j);
                    j = i >> w - this.maxLook;
                    r_base = q;
                    this.Exop[u[h - 1] + j] = r_exop;
                    this.Bits[u[h - 1] + j] = r_bits;
                    this.Base[u[h - 1] + j] = r_base;
                }
                r_bits = (byte)(k - w);
                if (p >= n) {
                    r_exop = -64;
                    r_base = 0;
                } else if (v[p] < s) {
                    r_exop = (byte)(v[p] < 256 ? 0 : 96);
                    r_base = v[p++];
                } else {
                    int index = v[p++] - s;
                    r_exop = (byte)(64 + e[index]);
                    r_base = d[index];
                }
                f = 1 << k - w;
                for (j = i >> w; j < z; j += f) {
                    this.Exop[q + j] = r_exop;
                    this.Bits[q + j] = r_bits;
                    this.Base[q + j] = r_base;
                }
                j = 1 << k - 1;
                while ((i & j) != 0) {
                    i ^= j;
                    j >>= 1;
                }
                i ^= j;
                while ((i & (1 << w) - 1) != x[h]) {
                    --h;
                    w -= this.maxLook;
                }
            }
        }
    }
}

