/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.ASCII85FilterException;
import com.adobe.internal.pdftoolkit.core.filter.DecodeInputStream;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import java.io.InputStream;

public class ASCII85InputStream
extends DecodeInputStream {
    private static final int WS = 85;
    private static final int ZZ = 86;
    private static final int ED = 87;
    private static final int IL = 88;
    private static byte[] asc85DecodeTable = new byte[128];
    private static long[] M085;
    private static int[] M185;
    private static int[] M285;
    private static short[] M385;
    private int[] digit = new int[5];

    public ASCII85InputStream(InputStream in, int inSize, int outSize, FilterParams diparams) {
        super(in, inSize, outSize, 4, diparams);
    }

    public ASCII85InputStream(InputStream in, FilterParams p) {
        super(in, 4, p);
    }

    public ASCII85InputStream(InputStream in) {
        this(in, null);
    }

    @Override
    public void fill() {
        block12: while (this.outCount <= this.outBuf.length - 4 && !this.pendingEOF && this.pendingException == null) {
            long value;
            this.digit[4] = 0;
            this.digit[3] = 0;
            this.digit[2] = 0;
            this.digit[1] = 0;
            this.digit[0] = 0;
            int dp = 0;
            block13: while (dp < 5) {
                int newChar;
                int digitVal;
                if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
                    this.pendingException = new ASCII85FilterException("Asc85 missing EOF");
                    break block12;
                }
                if ((digitVal = asc85DecodeTable[newChar = this.inBuf[this.inPos++] & 0x7F]) < 85) {
                    this.digit[dp++] = digitVal;
                    continue;
                }
                switch (digitVal) {
                    case 85: {
                        continue block13;
                    }
                    case 86: {
                        if (dp != 0) {
                            this.pendingException = new ASCII85FilterException("Asc85 misaligned 'z'");
                            break block13;
                        }
                        dp = 5;
                        break block13;
                    }
                    case 87: {
                        if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
                            this.pendingException = new ASCII85FilterException("Asc85 missing final '>'");
                            break block13;
                        }
                        if ((newChar = this.inBuf[this.inPos++] & 0xFF) != 62) {
                            this.pendingException = new ASCII85FilterException("Asc85 missing final '>'");
                        }
                        this.pendingEOF = true;
                        break block13;
                    }
                    default: {
                        this.pendingException = new ASCII85FilterException("Asc85 illegal char");
                        break block13;
                    }
                }
            }
            if ((value = M085[this.digit[0]] + (long)M185[this.digit[1]] + (long)M285[this.digit[2]] + (long)M385[this.digit[3]] + (long)this.digit[4]) > 0xFFFFFFFFL) {
                dp = 0;
            }
            switch (dp) {
                case 5: {
                    this.outBuf[this.outCount++] = (byte)(value >>> 24);
                    this.outBuf[this.outCount++] = (byte)(value >>> 16);
                    this.outBuf[this.outCount++] = (byte)(value >>> 8);
                    this.outBuf[this.outCount++] = (byte)value;
                    continue block12;
                }
                case 4: {
                    this.outBuf[this.outCount++] = (byte)((value += 255L) >>> 24);
                    this.outBuf[this.outCount++] = (byte)(value >>> 16);
                    this.outBuf[this.outCount++] = (byte)(value >>> 8);
                    continue block12;
                }
                case 3: {
                    this.outBuf[this.outCount++] = (byte)((value += 65535L) >>> 24);
                    this.outBuf[this.outCount++] = (byte)(value >>> 16);
                    continue block12;
                }
                case 1: {
                    this.pendingException = new ASCII85FilterException("Asc85 short pentet");
                }
                case 2: {
                    this.outBuf[this.outCount++] = (byte)((value += 0xFFFFFFL) >>> 24);
                    continue block12;
                }
            }
        }
    }

    static {
        block5: for (int i = 0; i < 128; ++i) {
            switch ((char)i) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    ASCII85InputStream.asc85DecodeTable[i] = 85;
                    continue block5;
                }
                case 'z': {
                    ASCII85InputStream.asc85DecodeTable[i] = 86;
                    continue block5;
                }
                case '~': {
                    ASCII85InputStream.asc85DecodeTable[i] = 87;
                    continue block5;
                }
                default: {
                    ASCII85InputStream.asc85DecodeTable[i] = 33 <= i && i <= 117 ? (int)(i - 33) : 88;
                }
            }
        }
        M085 = new long[85];
        M185 = new int[85];
        M285 = new int[85];
        M385 = new short[85];
        short m3 = 0;
        int i3 = 85;
        int m2 = 0;
        int i2 = i3 * 85;
        int m1 = 0;
        int i1 = i2 * 85;
        long m0 = 0L;
        long i0 = (long)i1 * 85L;
        for (int i = 0; i < 85; ++i) {
            ASCII85InputStream.M085[i] = m0;
            m0 += i0;
            ASCII85InputStream.M185[i] = m1;
            m1 += i1;
            ASCII85InputStream.M285[i] = m2;
            m2 += i2;
            ASCII85InputStream.M385[i] = m3;
            m3 = (short)(m3 + i3);
        }
    }
}

