/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.credentials.impl.utils;

import com.adobe.internal.pdftoolkit.core.credentials.PrivateKeyHolder;
import com.adobe.internal.pdftoolkit.core.credentials.PrivateKeyHolderFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class CertUtils {
    private static final String RSA = "RSA";
    private static final String DSA = "DSA";

    private CertUtils() {
    }

    public static Certificate importCertificate(byte[] certData) throws CertificateException, IOException {
        ByteArrayInputStream dataStream = new ByteArrayInputStream(certData);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate cert = cf.generateCertificate(dataStream);
        dataStream.close();
        return cert;
    }

    public static Certificate[] importCertificateChain(byte[][] certData) throws CertificateException, IOException {
        if (certData != null) {
            Certificate[] jceCertChain = new Certificate[certData.length];
            for (int i = 0; i < certData.length; ++i) {
                jceCertChain[i] = CertUtils.importCertificate(certData[i]);
            }
            return jceCertChain;
        }
        return null;
    }

    public static PrivateKey createJCEPrivateKey(byte[] encodedPriKey, String keyWrappingFormat) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec pvtKeySpec = new PKCS8EncodedKeySpec(encodedPriKey);
        PrivateKey privateKey = null;
        if (keyWrappingFormat.equals(RSA)) {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            return keyFactory.generatePrivate(pvtKeySpec);
        }
        if (keyWrappingFormat.equals(DSA)) {
            KeyFactory keyFactory = KeyFactory.getInstance(keyWrappingFormat);
            privateKey = keyFactory.generatePrivate(pvtKeySpec);
        }
        return privateKey;
    }

    public static PrivateKeyHolder createJCEPrivateKeyHolder(byte[] encodedPriKey, String keyWrappingFormat) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec pvtKeySpec = new PKCS8EncodedKeySpec(encodedPriKey);
        KeyFactory keyFactory = null;
        PrivateKey privateKey = null;
        if (keyWrappingFormat.equals(RSA)) {
            keyFactory = KeyFactory.getInstance(RSA);
            privateKey = keyFactory.generatePrivate(pvtKeySpec);
        } else if (keyWrappingFormat.equals(DSA)) {
            keyFactory = KeyFactory.getInstance(keyWrappingFormat);
            privateKey = keyFactory.generatePrivate(pvtKeySpec);
        }
        if (keyFactory != null && privateKey != null) {
            PrivateKeyHolderFactory factory = PrivateKeyHolderFactory.newInstance();
            return factory.createPrivateKey(privateKey, keyFactory.getProvider().getName());
        }
        return null;
    }

    public static byte[][] buildDERCertChain(Certificate[] certChain) throws CertificateEncodingException, CertificateException {
        if (certChain != null) {
            byte[][] derCertChain = new byte[certChain.length][];
            for (int i = 0; i < certChain.length; ++i) {
                X509Certificate javaCert = (X509Certificate)certChain[i];
                derCertChain[i] = javaCert.getEncoded();
            }
            return derCertChain;
        }
        return null;
    }

    public static int computeJavaPrivateKeySize(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger modulus = null;
        String algorithm = privateKey.getAlgorithm();
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        if (algorithm.equals(RSA)) {
            RSAPrivateKeySpec rsaKeySpec = keyFactory.getKeySpec(privateKey, RSAPrivateKeySpec.class);
            modulus = rsaKeySpec.getModulus();
        }
        if (algorithm.equals(DSA)) {
            DSAPrivateKeySpec dsaKeySpec = keyFactory.getKeySpec(privateKey, DSAPrivateKeySpec.class);
            modulus = dsaKeySpec.getP();
        }
        return modulus.bitLength();
    }

    public static String getCommonSubjectName(X509Certificate x509Certificate) {
        String subjectCN;
        block3: {
            subjectCN = null;
            try {
                String subjectNameDN = x509Certificate.getSubjectX500Principal().getName();
                if (subjectNameDN == null) break block3;
                LdapName ldapName = new LdapName(subjectNameDN);
                for (Rdn rdn : ldapName.getRdns()) {
                    if (!rdn.getType().equals("CN")) continue;
                    subjectCN = (String)rdn.getValue();
                    break;
                }
            }
            catch (InvalidNameException e) {
                throw new IllegalArgumentException("Certificate DN is incorrectly formatted", e);
            }
        }
        return subjectCN;
    }
}

