/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;

public class CosScalarOps {
    private static int compareTo(CosNumeric a, CosNumeric b) {
        Number aNumber = (Number)a.getValue();
        Number bNumber = (Number)b.getValue();
        if (aNumber instanceof Double || aNumber instanceof Float) {
            return (int)(aNumber.doubleValue() - bNumber.doubleValue());
        }
        return (int)(aNumber.longValue() - bNumber.longValue());
    }

    private static int compareTo(CosString a, CosString b) throws PDFSecurityException {
        byte[] v1 = a.byteArrayValue();
        byte[] v2 = b.byteArrayValue();
        int len1 = v1.length;
        int len2 = v2.length;
        int n = Math.min(len1, len2);
        for (int k = 0; k < n; ++k) {
            if (v1[k] == v2[k]) continue;
            return (v1[k] & 0xFF) - (v2[k] & 0xFF);
        }
        return len1 - len2;
    }

    public static int compareTo(CosScalar a, CosScalar b) throws PDFSecurityException {
        if (a == b) {
            return 0;
        }
        if (a instanceof CosString && b instanceof CosString) {
            return CosScalarOps.compareTo((CosString)a, (CosString)b);
        }
        if (a instanceof CosNumeric && b instanceof CosNumeric) {
            return CosScalarOps.compareTo((CosNumeric)a, (CosNumeric)b);
        }
        return 0;
    }

    private static boolean equivalent(CosString a, CosString b) throws PDFSecurityException {
        return CosScalarOps.compareTo(a, b) == 0;
    }

    private static boolean equivalent(CosNumeric a, CosNumeric b) {
        Number bNumber = b.numberValue();
        Number aNumber = a.numberValue();
        return bNumber.equals(aNumber);
    }

    public static boolean equivalent(CosScalar a, CosScalar b) throws PDFSecurityException {
        if (a == b) {
            return true;
        }
        if (a instanceof CosString) {
            if (b instanceof CosString) {
                return CosScalarOps.equivalent((CosString)a, (CosString)b);
            }
            return false;
        }
        if (a instanceof CosNumeric) {
            if (b instanceof CosNumeric) {
                return CosScalarOps.equivalent((CosNumeric)a, (CosNumeric)b);
            }
            return false;
        }
        return false;
    }
}

