/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import java.util.Collections;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.CompositeValueMap;

public class Config {
    @CheckForNull
    private Resource resource;
    @Nonnull
    private ValueMap properties;
    @Nonnull
    private ValueMap propertiesWithParent;
    @CheckForNull
    private Resource parentResource;
    private boolean isParentProcessed;
    @Nonnull
    public static String DEFAULTS = "defaults";
    @Nonnull
    public static String ITEMS = "items";
    @Nonnull
    public static String LAYOUT = "layout";
    @Nonnull
    public static String DATASOURCE = "datasource";
    @Nonnull
    public static String RENDERCONDITION = "rendercondition";

    public Config(@CheckForNull Resource resource) {
        this(resource, false);
    }

    public Config(@CheckForNull Resource resource, boolean inherit) {
        Resource parentResource;
        this.resource = resource;
        ValueMap prop = resource != null ? resource.getValueMap() : ValueMap.EMPTY;
        ValueMap defaults = null;
        ValueMap parent = null;
        if (inherit && (parentResource = this.getParentResource()) != null) {
            Resource defaultsResource = parentResource.getChild(DEFAULTS);
            if (defaultsResource != null) {
                defaults = defaultsResource.getValueMap();
            }
            parent = parentResource.getValueMap();
        }
        this.properties = new CompositeValueMap(prop, defaults);
        this.propertiesWithParent = new CompositeValueMap(prop, parent);
    }

    public Config(@CheckForNull Resource resource, @CheckForNull ValueMap defaults, @CheckForNull ValueMap parentProperties) {
        this.resource = resource;
        ValueMap prop = resource != null ? resource.getValueMap() : ValueMap.EMPTY;
        this.properties = new CompositeValueMap(prop, defaults);
        this.propertiesWithParent = new CompositeValueMap(prop, parentProperties);
    }

    @Nonnull
    public String get(@Nonnull String name) {
        return this.get(name, "");
    }

    @Nonnull
    public <T> T get(@Nonnull String name, @Nonnull T defaultValue) {
        return this.properties.get(name, defaultValue);
    }

    @CheckForNull
    public <T> T get(@Nonnull String name, @Nonnull Class<T> type) {
        return (T)this.properties.get(name, type);
    }

    @Nonnull
    public String getInherited(@Nonnull String name) {
        return this.getInherited(name, "");
    }

    @Nonnull
    public <T> T getInherited(@Nonnull String name, @Nonnull T defaultValue) {
        return this.propertiesWithParent.get(name, defaultValue);
    }

    @CheckForNull
    public <T> T getInherited(@Nonnull String name, @Nonnull Class<T> type) {
        return (T)this.propertiesWithParent.get(name, type);
    }

    @Nonnull
    public String getInheritedDefault(@Nonnull String name) {
        return this.getInheritedDefault(name, "");
    }

    @Nonnull
    public <T> T getInheritedDefault(@Nonnull String name, @Nonnull T defaultValue) {
        return this.get(name, defaultValue);
    }

    @CheckForNull
    public <T> T getInheritedDefault(@Nonnull String name, @Nonnull Class<T> type) {
        return this.get(name, type);
    }

    @Nonnull
    public ValueMap getDefaultProperties() {
        Resource r = this.resource;
        Resource defaults = null;
        if (r != null) {
            defaults = r.getChild(DEFAULTS);
        }
        return defaults != null ? defaults.getValueMap() : ValueMap.EMPTY;
    }

    @Nonnull
    public ValueMap getProperties() {
        return this.properties;
    }

    @Nonnull
    public Iterator<Resource> getItems() {
        return this.getItems(ITEMS);
    }

    @Nonnull
    public Iterator<Resource> getItems(@CheckForNull String name) {
        return this.getItems(this.resource, name);
    }

    @Nonnull
    public Iterator<Resource> getItems(@CheckForNull Resource resource) {
        return this.getItems(resource, null);
    }

    @Nonnull
    public Iterator<Resource> getItems(@CheckForNull Resource resource, @CheckForNull String name) {
        Resource items;
        if (name == null || name.length() == 0) {
            name = ITEMS;
        }
        if (resource != null && (items = resource.getChild(name)) != null) {
            return items.listChildren();
        }
        return Collections.emptyList().iterator();
    }

    @CheckForNull
    public Resource getChild(@Nonnull String name) {
        Resource r = this.resource;
        return r == null ? null : r.getChild(name);
    }

    @CheckForNull
    public Resource getParentResource() {
        if (this.isParentProcessed) {
            return this.parentResource;
        }
        Resource r = this.resource;
        Resource parent = null;
        if (r != null) {
            parent = r.getParent();
        }
        if (parent != null && "nt:unstructured".equals(parent.getResourceType())) {
            parent = parent.getParent();
        }
        this.isParentProcessed = true;
        this.parentResource = parent;
        return parent;
    }
}

