/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.translation.connector.msft.core.ui.models;

import com.adobe.granite.translation.connector.msft.core.ui.utils.MicrosoftCloudServiceUtils;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class MicrosoftTranslationConnector {
    private static final Logger logger = LoggerFactory.getLogger(MicrosoftTranslationConnector.class);
    @Self
    private SlingHttpServletRequest request;
    private Resource microsoftConfigResource;
    private ResourceResolver resourceResolver;
    private static final String SERVICE_LABEL = "servicelabel";
    private static final String SERVICE_ATTRIBUTION = "serviceattribution";
    private static final String WORKSPACE_ID = "workspaceId";
    private static final String SUBSCRIPTION_KEY = "subscriptionkey";
    private static final String DESCRIPTION = "cq:description";
    private static final String EXTENDED_DESCRIPTION = "descriptionExtended";
    private static final String ENDPOINT_URL = "endpointUrl";
    private static String microsoftConfigPath;

    @PostConstruct
    public void postConstruct() throws Exception {
        microsoftConfigPath = this.request.getRequestPathInfo().getSuffix();
        this.resourceResolver = this.request.getResourceResolver();
        this.microsoftConfigResource = this.resourceResolver.getResource(microsoftConfigPath);
    }

    public boolean isOverLayRequired() {
        return microsoftConfigPath.startsWith("/libs/settings/cloudconfigs/translation");
    }

    public Map<String, String> getHiddenFields() {
        return MicrosoftCloudServiceUtils.getHiddenFields(this.request);
    }

    public String getConfOverlayPath() {
        return MicrosoftCloudServiceUtils.getConfOverlayPath(microsoftConfigPath) + '/' + "jcr:content";
    }

    public String getServiceLabel() {
        return MicrosoftCloudServiceUtils.getStringPropertyFromContent(this.microsoftConfigResource, SERVICE_LABEL);
    }

    public String getServiceAttribution() {
        return MicrosoftCloudServiceUtils.getStringPropertyFromContent(this.microsoftConfigResource, SERVICE_ATTRIBUTION);
    }

    public String getWorkspaceId() {
        return MicrosoftCloudServiceUtils.getStringPropertyFromContent(this.microsoftConfigResource, WORKSPACE_ID);
    }

    public String getEndpointUrl() {
        return MicrosoftCloudServiceUtils.getStringPropertyFromContent(this.microsoftConfigResource, ENDPOINT_URL);
    }

    public String getSubscriptionKey() {
        return MicrosoftCloudServiceUtils.getStringPropertyFromContent(this.microsoftConfigResource, SUBSCRIPTION_KEY);
    }

    public String getDescription() {
        return MicrosoftCloudServiceUtils.getConnectorProperty(this.resourceResolver, microsoftConfigPath, DESCRIPTION);
    }

    public String getExtendedDescription() {
        return MicrosoftCloudServiceUtils.getConnectorProperty(this.resourceResolver, microsoftConfigPath, EXTENDED_DESCRIPTION);
    }

    public boolean getConnectEnabled() {
        String connectEnabled = MicrosoftCloudServiceUtils.getConnectorProperty(this.resourceResolver, microsoftConfigPath, SUBSCRIPTION_KEY);
        return "".equals(connectEnabled);
    }
}

