/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.rest.utils;

import com.adobe.granite.rest.filter.Filter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

public final class Resources {
    private Resources() {
    }

    public static int getSize(Iterator<Resource> children, Filter<Resource> filter) {
        LinkedList<Resource> filteredChildren = new LinkedList<Resource>();
        Iterator<Resource> it = children;
        while (it.hasNext()) {
            Resource child = it.next();
            ValueMap vm = child.adaptTo(ValueMap.class);
            if (vm != null && Boolean.TRUE.equals(vm.get("hidden", Boolean.class)) || filter != null && !filter.matches(child)) continue;
            filteredChildren.add(child);
        }
        return filteredChildren.size();
    }

    public static Resource copy(Resource src, Resource dstParent, String name, int depth) throws PersistenceException {
        HashSet<String> ignoreProperties = new HashSet<String>();
        ignoreProperties.add("jcr:uuid");
        return Resources.copy(src, dstParent, name, depth, ignoreProperties);
    }

    public static Resource copy(Resource src, Resource dstParent, String name, int depth, Set<String> ignoreProperties, Set<String> ignoreChildren) throws PersistenceException {
        if (Resources.isAncestorOrSameNode(src, dstParent)) {
            throw new PersistenceException("Cannot copy ancestor " + src.getPath() + " to descendant " + dstParent.getPath());
        }
        ResourceResolver resolver = src.getResourceResolver();
        if (name == null) {
            name = src.getName();
        }
        if (dstParent.getChild(name) != null) {
            Resource child = dstParent.getChild(name);
            resolver.delete(child);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (Map.Entry entry : src.adaptTo(ValueMap.class).entrySet()) {
            if (ignoreProperties.contains(entry.getKey())) continue;
            properties.put((String)entry.getKey(), entry.getValue());
        }
        Resource dst = resolver.create(dstParent, name, properties);
        if (depth == 0) {
            return dst;
        }
        Iterator<Resource> it = src.listChildren();
        while (it.hasNext()) {
            Resource child = it.next();
            if (ignoreChildren.contains(child.getName())) continue;
            Resources.copy(child, dst, null, --depth, ignoreProperties, ignoreChildren);
        }
        return dst;
    }

    public static Resource copy(Resource src, Resource dstParent, String name, int depth, Set<String> ignoreProperties) throws PersistenceException {
        HashSet<String> ignoreChildren = new HashSet<String>();
        return Resources.copy(src, dstParent, name, depth, ignoreProperties, ignoreChildren);
    }

    private static boolean isAncestorOrSameNode(Resource src, Resource dest) {
        if ("/".equals(src.getPath())) {
            return true;
        }
        if (src.getPath().equals(dest.getPath())) {
            return true;
        }
        return dest.getPath().startsWith(src.getPath() + "/");
    }
}

