/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.agl.lang.UCharacter;
import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.CharUtil;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTSelector;
import com.adobe.fontengine.font.opentype.OTSelectorOnElementAttribute;
import com.adobe.fontengine.font.opentype.OTSelectors;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.InterElementAttribute;
import com.adobe.fontengine.inlineformatting.LigatureLevel;
import com.adobe.fontengine.inlineformatting.infontformatting.BaseFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.LookupsCache;

final class ArabicFormatter
extends BaseFormatter {
    private static final ElementAttribute joiningShape = new ElementAttribute("joiningShape");
    private static final OTSelector initSelector = new OTSelectorOnElementAttribute(joiningShape, JoiningShapes.init, true);
    private static final OTSelector mediSelector = new OTSelectorOnElementAttribute(joiningShape, JoiningShapes.medi, true);
    private static final OTSelector finaSelector = new OTSelectorOnElementAttribute(joiningShape, JoiningShapes.fina, true);
    private static final OTSelector isolSelector = new OTSelectorOnElementAttribute(joiningShape, JoiningShapes.isol, true);
    private static final int[] gsubFeatures = new int[]{Tag.feature_ccmp, Tag.feature_locl, Tag.feature_init, Tag.feature_medi, Tag.feature_fina, Tag.feature_isol, Tag.feature_rtla, Tag.feature_rlig, Tag.feature_liga};
    private static final int[] gposFeatures = new int[]{Tag.feature_kern, Tag.feature_mark, Tag.feature_mkmk};

    ArabicFormatter() {
    }

    protected void setJoiningShape(AttributedRun run, int start, int limit) {
        int previousIndex = Integer.MIN_VALUE;
        boolean previousJoinsItsRight = false;
        int previousType = 0;
        for (int i = start; i < limit + 1; ++i) {
            JoiningShapes previousShape;
            int thisType = i == limit ? 0 : (run.getElementStyle(i, ElementAttribute.isGlyph) != Boolean.TRUE ? UCharacter.getIntPropertyValue(run.elementAt(i), 4103) : (Integer)run.getElementStyle(i, ElementAttribute.joiningType));
            if (thisType == 5) continue;
            if (!(thisType != 1 && thisType != 2 && thisType != 4 || previousType != 1 && previousType != 2 && previousType != 3)) {
                previousShape = previousJoinsItsRight ? JoiningShapes.medi : JoiningShapes.init;
                previousJoinsItsRight = true;
            } else {
                previousShape = previousJoinsItsRight ? JoiningShapes.fina : JoiningShapes.isol;
                previousJoinsItsRight = false;
            }
            if (previousIndex != Integer.MIN_VALUE && previousType != 1 && previousType != 0) {
                run.setElementStyle(previousIndex, joiningShape, previousShape);
            }
            previousIndex = i;
            previousType = thisType;
        }
    }

    @Override
    public int firstPass(AttributedRun run, int start, int limit) {
        while (start < limit) {
            int bidiRunLimit = run.getSubrunLimit(start, limit, ElementAttribute.bidiLevel);
            this.setJoiningShape(run, start, bidiRunLimit);
            start = bidiRunLimit;
        }
        return super.firstPass(run, start, limit);
    }

    protected int setGlyphs(AttributedRun run, int start, int limit) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        Font font = (Font)run.getElementStyle(start, ElementAttribute.font);
        OpenTypeFont otFont = (OpenTypeFont)((FontImpl)font).getFontData();
        while (start < limit) {
            int usvc;
            int gid;
            int i;
            int graphemeLimit;
            if (run.getElementStyle(start, ElementAttribute.isGlyph) == Boolean.TRUE) {
                ++start;
                continue;
            }
            int usv = run.elementAt(start);
            if (usv == 8205 || usv == 8204) {
                run.remove(start);
                --limit;
                run.setInterElementStyleBefore(start, InterElementAttribute.ligatureLevel, LigatureLevel.NONE);
                continue;
            }
            if (CharUtil.isControl(usv)) {
                run.remove(start);
                --limit;
                continue;
            }
            if ((Integer)run.getElementStyle(start, ElementAttribute.bidiLevel) % 2 == 1) {
                usv = UCharacter.getMirror(usv);
            }
            if (!CharUtil.isBase(usv) || start + 1 == limit || run.getElementStyle(start + 1, ElementAttribute.isGlyph) == Boolean.TRUE || !CharUtil.isCombining(run.elementAt(start + 1))) {
                int gid2 = otFont.getGlyphForChar(usv);
                run.replace(start, gid2);
                run.setElementStyle(start, ElementAttribute.isGlyph, Boolean.TRUE);
                ++start;
                continue;
            }
            for (graphemeLimit = start + 1; graphemeLimit < limit && run.getElementStyle(graphemeLimit, ElementAttribute.isGlyph) != Boolean.TRUE && CharUtil.isCombining(run.elementAt(graphemeLimit)); ++graphemeLimit) {
            }
            boolean directMappingHasNotdef = false;
            int[] usvs = new int[graphemeLimit - start];
            int[] gids = new int[graphemeLimit - start];
            for (i = start; i < graphemeLimit; ++i) {
                usvs[i - start] = run.elementAt(i);
                gid = otFont.getGlyphForChar(usvs[i - start]);
                if (gid == 0) {
                    directMappingHasNotdef = true;
                }
                gids[i - start] = gid;
            }
            if (directMappingHasNotdef && (usvc = CharUtil.compose(usvs, 0, graphemeLimit - start)) != -1 && (gid = otFont.getGlyphForChar(usvc)) != 0) {
                run.replace(start, graphemeLimit, gid);
                run.setElementStyle(start, ElementAttribute.isGlyph, Boolean.TRUE);
                limit -= graphemeLimit - start - 1;
                ++start;
                continue;
            }
            for (i = start; i < graphemeLimit; ++i) {
                run.replace(i, gids[i - start]);
                run.setElementStyle(start, ElementAttribute.isGlyph, Boolean.TRUE);
            }
            start = graphemeLimit;
        }
        return limit;
    }

    @Override
    protected boolean canFormatOT() {
        return true;
    }

    @Override
    protected int formatOT(OpenTypeFont otFont, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        Integer bidiLevel = (Integer)run.getElementStyle(start, ElementAttribute.bidiLevel);
        int scriptTag = ArabicFormatter.getOTScriptTag((Integer)run.getElementStyle(start, InFontFormatter.scriptAttribute));
        int langTag = ArabicFormatter.getOTLanguageTag((ULocale)run.getElementStyle(start, ElementAttribute.locale));
        limit = this.setGlyphs(run, start, limit);
        if (otFont.gsub != null) {
            int[][] gsubLookups = LookupsCache.resolveFeatureTag(otFont.gsub, scriptTag, langTag, gsubFeatures);
            limit = otFont.gsub.applyLookups(gsubLookups[0], run, start, limit, OTSelectors.everywhere, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[1], run, start, limit, OTSelectors.everywhere, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[2], run, start, limit, initSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[3], run, start, limit, mediSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[4], run, start, limit, finaSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[5], run, start, limit, isolSelector, otFont.gdef);
            if (bidiLevel % 2 == 1) {
                limit = otFont.gsub.applyLookups(gsubLookups[6], run, start, limit, OTSelectors.everywhere, otFont.gdef);
            }
            limit = otFont.gsub.applyLookups(gsubLookups[7], run, start, limit, OTSelectors.minimumLigatures, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[8], run, start, limit, OTSelectors.commonLigatures, otFont.gdef);
        }
        this.posFromAdvanceWidth(run, otFont, start, limit);
        if (otFont.gpos != null) {
            int[][] gposLookups = LookupsCache.resolveFeatureTag(otFont.gpos, scriptTag, langTag, gposFeatures);
            if (shouldKern) {
                if (gposLookups[0].length != 0) {
                    limit = otFont.gpos.applyLookups(gposLookups[0], run, start, limit, OTSelectors.everywhere, otFont.gdef);
                } else {
                    this.applyKernTable(otFont, run, start, limit);
                }
            }
            limit = otFont.gpos.applyLookups(gposLookups[1], run, start, limit, OTSelectors.everywhere, otFont.gdef);
            limit = otFont.gpos.applyLookups(gposLookups[2], run, start, limit, OTSelectors.everywhere, otFont.gdef);
        } else {
            this.applyKernTable(otFont, run, start, limit);
        }
        return limit;
    }

    private static class JoiningShapes {
        private String name;
        public static final JoiningShapes init = new JoiningShapes("init");
        public static final JoiningShapes isol = new JoiningShapes("isol");
        public static final JoiningShapes medi = new JoiningShapes("medi");
        public static final JoiningShapes fina = new JoiningShapes("fina");

        private JoiningShapes(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

