/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement.fxg;

public class FXGFontSearchAttributes {
    private final String familyName;
    private final boolean isBold;
    private final boolean isItalic;

    public FXGFontSearchAttributes(String platformName, boolean isBold, boolean isItalic) {
        if (platformName == null) {
            throw new NullPointerException("Platoform name can't be null");
        }
        this.familyName = platformName;
        this.isBold = isBold;
        this.isItalic = isItalic;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isBold ? 1231 : 1237);
        result = 31 * result + (this.isItalic ? 1231 : 1237);
        result = 31 * result + (this.familyName == null ? 0 : this.familyName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FXGFontSearchAttributes)) {
            return false;
        }
        FXGFontSearchAttributes other = (FXGFontSearchAttributes)obj;
        if (this.isBold != other.isBold) {
            return false;
        }
        if (this.isItalic != other.isItalic) {
            return false;
        }
        return this.familyName.equals(other.familyName);
    }

    public String toString() {
        return new String(this.familyName + (this.isBold ? ", bold" : "") + (this.isItalic ? ", italic" : ""));
    }
}

