/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import java.io.Serializable;

public final class FontResolutionPriority
implements Serializable {
    public static final FontResolutionPriority INTELLIGENT_LAST;
    public static final FontResolutionPriority INTELLIGENT;
    public static final FontResolutionPriority INTELLIGENT_FIRST;
    public static final FontResolutionPriority FIRST;
    public static final FontResolutionPriority LAST;
    private static final FontResolutionPriority[] priorityValues;
    static final long serialVersionUID = 1L;
    private final int id;
    private final String[] names;

    private FontResolutionPriority(String[] names, int id) {
        this.names = names;
        this.id = id;
    }

    private Object readResolve() {
        for (int i = 0; i < priorityValues.length; ++i) {
            if (this.id != FontResolutionPriority.priorityValues[i].id) continue;
            return priorityValues[i];
        }
        return null;
    }

    public static FontResolutionPriority parse(String text) {
        for (int priority = 0; priority < priorityValues.length; ++priority) {
            for (int name = 0; name < FontResolutionPriority.priorityValues[priority].names.length; ++name) {
                if (!FontResolutionPriority.priorityValues[priority].names[name].equalsIgnoreCase(text)) continue;
                return priorityValues[priority];
            }
        }
        return null;
    }

    public String toString() {
        return this.names[0];
    }

    static {
        INTELLIGENT = INTELLIGENT_LAST = new FontResolutionPriority(new String[]{"intelligent last", "intelligent"}, 1);
        INTELLIGENT_FIRST = new FontResolutionPriority(new String[]{"intelligent first"}, 4);
        FIRST = new FontResolutionPriority(new String[]{"first"}, 2);
        LAST = new FontResolutionPriority(new String[]{"last"}, 3);
        priorityValues = new FontResolutionPriority[]{INTELLIGENT_LAST, INTELLIGENT_FIRST, FIRST, LAST};
    }
}

