/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnderlineMetrics;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFFont;
import com.adobe.fontengine.font.cff.CIDKeyedFont;
import com.adobe.fontengine.font.cff.FontFactory;
import com.adobe.fontengine.font.cff.NameKeyedFont;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public final class Cff
extends Table {
    protected final CFFFont cffFont;

    protected Cff(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        CFFFont[] fonts = FontFactory.load(buffer);
        if (fonts == null || fonts.length != 1 || fonts[0] == null) {
            throw new InvalidFontException("CFFFontSet not appropriate for CFF table");
        }
        this.cffFont = fonts[0];
    }

    public CFFFont getCFFFont() {
        return this.cffFont;
    }

    String getGlyphName(int gid) throws InvalidFontException, UnsupportedFontException {
        return this.cffFont.getGlyphName(gid);
    }

    ROS getROS() {
        return this.cffFont.getROS();
    }

    int getGlyphCid(int glyphID) throws InvalidFontException, UnsupportedFontException {
        return this.cffFont.getGlyphCid(glyphID);
    }

    public Rect getGlyphBoundingBoxInMetricSpace(int gid) throws UnsupportedFontException, InvalidFontException {
        return this.cffFont.getGlyphBBox(gid);
    }

    public void getOutline(int gid, OutlineConsumer consumer) throws UnsupportedFontException, InvalidFontException {
        this.cffFont.getGlyphOutline(gid, consumer);
    }

    public Rect getFontBBox() throws UnsupportedFontException, InvalidFontException {
        return this.cffFont.getFontBBox();
    }

    Permission getEmbeddingPermission(boolean wasEmbedded) throws UnsupportedFontException, InvalidFontException {
        return this.cffFont.getEmbeddingPermission(wasEmbedded);
    }

    protected UnderlineMetrics getCoolTypeUnderlineMetrics(double coolTypeUnitsPerEm, double unitsPerEmY) throws UnsupportedFontException, InvalidFontException {
        return this.cffFont.getCoolTypeUnderlineMetrics(coolTypeUnitsPerEm, unitsPerEmY);
    }

    void subsetAndStream(Subset subset, OutputStream os, boolean preserveROS, Integer fsType) throws InvalidFontException, UnsupportedFontException, IOException {
        this.cffFont.subsetAndStream(subset, os, preserveROS, fsType);
    }

    void subsetAndStream(Subset subset, Map tables, boolean preserveROS, Integer fsType, boolean enableSubrizer) throws InvalidFontException, UnsupportedFontException, IOException {
        OTByteArray.OTByteArrayBuilder.OTByteArrayBuilderOutputStreamAdaptor stream = new OTByteArray.OTByteArrayBuilder.OTByteArrayBuilderOutputStreamAdaptor();
        if (this.cffFont instanceof NameKeyedFont) {
            ((NameKeyedFont)this.cffFont).subsetAndStream(subset, (OutputStream)stream, preserveROS, fsType, enableSubrizer);
        } else if (this.cffFont instanceof CIDKeyedFont) {
            ((CIDKeyedFont)this.cffFont).subsetAndStream(subset, stream, preserveROS, fsType, enableSubrizer);
        } else {
            throw new UnsupportedFontException("subsetAndStream of unsupported CFF font");
        }
        tables.put(new Integer(1128678944), stream.getBuilder());
    }

    void stream(Map tables, Integer fsType) throws InvalidFontException, UnsupportedFontException, IOException {
        OTByteArray.OTByteArrayBuilder.OTByteArrayBuilderOutputStreamAdaptor stream = new OTByteArray.OTByteArrayBuilder.OTByteArrayBuilderOutputStreamAdaptor();
        this.cffFont.stream(stream, fsType);
        tables.put(new Integer(1128678944), stream.getBuilder());
    }
}

