/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.BitmapConsumer;
import com.adobe.fontengine.font.OutlineConsumer2;
import com.adobe.fontengine.font.OutlineConsumer2BaseImpl;
import com.adobe.fontengine.font.ScalerDebugger;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.math.F26Dot6;
import com.adobe.fontengine.math.Math2;

public final class TTScan
implements ScanConverter {
    private ScanLines hScanLines;
    private ScanLines vScanLines;
    private int scanType = 2;
    private CrossBuilder crossBuilder = new CrossBuilder();
    private ScalerDebugger outlineDebugger;

    private int scanlineAbove(int y) {
        return F26Dot6.roundHalfUp(y);
    }

    private int scanlineBelow(int y) {
        return F26Dot6.roundHalfDown(y) - 64;
    }

    public TTScan() {
        this.crossBuilder.setFlatness(1.0);
    }

    @Override
    public void setScanType(int scanType) {
        this.scanType = scanType;
    }

    @Override
    public OutlineConsumer2 getOutlineConsumer2() {
        return this.crossBuilder;
    }

    @Override
    public void getBitmap(BitmapConsumer dest) {
        if (this.crossBuilder.zeroDimension) {
            this.scanType &= 0xFFFFFFFE;
        }
        if (!this.checkCrosses()) {
            return;
        }
        Bitmap bitmap = new Bitmap(F26Dot6.toInt(this.crossBuilder.xmin), F26Dot6.toInt(this.crossBuilder.xmax), F26Dot6.toInt(this.crossBuilder.ymin), F26Dot6.toInt(this.crossBuilder.ymax));
        this.buildInitialRuns(bitmap);
        if (this.isFixing(this.scanType)) {
            this.fixHDropouts(bitmap);
            this.fixVDropouts(bitmap);
        }
        bitmap.emitBitmap(dest);
    }

    private boolean checkCrosses() {
        ScanLine scanLine;
        int s;
        if (this.hScanLines.scanLines != null) {
            for (s = 0; s < this.hScanLines.scanLines.length; ++s) {
                scanLine = this.hScanLines.scanLines[s];
                if (scanLine == null || scanLine.onCrosses != null && scanLine.offCrosses != null && scanLine.onCrosses.values != null && scanLine.offCrosses.values != null && scanLine.onCrosses.values.length == scanLine.offCrosses.values.length) continue;
                System.err.println("****************** h crosses not paired!");
                return false;
            }
        }
        if (this.vScanLines.scanLines != null) {
            for (s = 0; s < this.vScanLines.scanLines.length; ++s) {
                scanLine = this.vScanLines.scanLines[s];
                if (scanLine == null || scanLine.onCrosses != null && scanLine.offCrosses != null && scanLine.onCrosses.values != null && scanLine.offCrosses.values != null && scanLine.onCrosses.values.length == scanLine.offCrosses.values.length) continue;
                System.err.println("****************** v crosses not paired!");
                return false;
            }
        }
        return true;
    }

    private void buildInitialRuns(Bitmap bitmap) {
        if (this.hScanLines.scanLines == null) {
            return;
        }
        for (int s = 0; s < this.hScanLines.scanLines.length; ++s) {
            ScanLine scanLine = this.hScanLines.scanLines[s];
            if (scanLine == null) continue;
            int y = this.hScanLines.firstScanLineCoordI + s;
            for (int i = 0; i < scanLine.onCrosses.values.length; ++i) {
                int x1 = scanLine.onCrosses.values[i];
                int x2 = scanLine.offCrosses.values[i];
                if (x1 > x2) {
                    int tmp = x1;
                    x1 = x2;
                    x2 = tmp;
                }
                bitmap.paintBlack(F26Dot6.toInt(F26Dot6.roundHalfDown(x1)), F26Dot6.toInt(F26Dot6.roundHalfUp(x2)), y);
            }
        }
    }

    private void fixHDropouts(Bitmap bitmap) {
        if (this.hScanLines.scanLines == null) {
            return;
        }
        for (int s = 0; s < this.hScanLines.scanLines.length; ++s) {
            ScanLine scanLine = this.hScanLines.scanLines[s];
            if (scanLine == null) continue;
            int y = this.hScanLines.firstScanLineCoordI + s;
            for (int i = 0; i < scanLine.onCrosses.values.length; ++i) {
                int pixel;
                int x;
                int x1 = scanLine.onCrosses.values[i];
                int x2 = scanLine.offCrosses.values[i];
                if (x1 > x2) {
                    int tmp = x1;
                    x1 = x2;
                    x2 = tmp;
                }
                if ((x = F26Dot6.toInt(this.scanlineAbove(x1))) <= F26Dot6.toInt(this.scanlineBelow(x2)) || bitmap.isBlack(x - 1, y) || bitmap.isBlack(x, y)) continue;
                if (this.isExcludingStubs(this.scanType)) {
                    int crossings = 0;
                    crossings += this.vScanLines.countCrosses(x - 1, y + 1);
                    crossings += this.hScanLines.countCrosses(y + 1, x);
                    if ((crossings += this.vScanLines.countCrosses(x, y + 1)) < 2) continue;
                    crossings = 0;
                    crossings += this.vScanLines.countCrosses(x - 1, y);
                    crossings += this.hScanLines.countCrosses(y - 1, x);
                    if ((crossings += this.vScanLines.countCrosses(x, y)) < 2) continue;
                }
                if ((pixel = this.isSmart(this.scanType) ? F26Dot6.toInt(F26Dot6.floor((scanLine.onCrosses.values[i] + scanLine.offCrosses.values[i]) / 2)) : x - 1) < F26Dot6.toInt(this.crossBuilder.xmin)) {
                    ++pixel;
                }
                if (F26Dot6.toInt(this.crossBuilder.xmax) < pixel) {
                    --pixel;
                }
                bitmap.paintBlack(pixel, y);
            }
        }
    }

    private void fixVDropouts(Bitmap bitmap) {
        if (this.vScanLines.scanLines == null) {
            return;
        }
        for (int s = 0; s < this.vScanLines.scanLines.length; ++s) {
            ScanLine scanLine = this.vScanLines.scanLines[s];
            if (scanLine == null) continue;
            int x = this.vScanLines.firstScanLineCoordI + s;
            for (int i = scanLine.onCrosses.values.length - 1; i >= 0; --i) {
                int pixel;
                int y;
                int y1 = scanLine.onCrosses.values[i];
                int y2 = scanLine.offCrosses.values[i];
                if (y1 > y2) {
                    int tmp = y1;
                    y1 = y2;
                    y2 = tmp;
                }
                if ((y = F26Dot6.toInt(this.scanlineAbove(y1))) <= F26Dot6.toInt(this.scanlineBelow(y2)) || bitmap.isBlack(x, y - 1) || bitmap.isBlack(x, y)) continue;
                if (this.isExcludingStubs(this.scanType)) {
                    int crossings = 0;
                    crossings += this.hScanLines.countCrosses(y - 1, x);
                    crossings += this.vScanLines.countCrosses(x - 1, y);
                    if ((crossings += this.hScanLines.countCrosses(y, x)) < 2) continue;
                    crossings = 0;
                    crossings += this.hScanLines.countCrosses(y - 1, x + 1);
                    crossings += this.vScanLines.countCrosses(x + 1, y);
                    if ((crossings += this.hScanLines.countCrosses(y, x + 1)) < 2) continue;
                }
                if ((pixel = this.isSmart(this.scanType) ? F26Dot6.toInt(F26Dot6.floor((scanLine.onCrosses.values[i] + scanLine.offCrosses.values[i]) / 2)) : y - 1) < F26Dot6.toInt(this.crossBuilder.ymin)) {
                    ++pixel;
                }
                if (F26Dot6.toInt(this.crossBuilder.ymax) < pixel) {
                    --pixel;
                }
                bitmap.paintBlack(x, pixel);
            }
        }
    }

    private boolean isFixing(int scanType) {
        return scanType == 0 || scanType == 1 || scanType == 4 || scanType == 5;
    }

    private boolean isSmart(int scanType) {
        return scanType == 4 || scanType == 5;
    }

    private boolean isExcludingStubs(int scanType) {
        return scanType == 1 || scanType == 5;
    }

    @Override
    public void setDebugger(ScalerDebugger outlineDebugger) {
        this.outlineDebugger = outlineDebugger;
    }

    private static class Bitmap {
        boolean[][] pixels;
        int blX;
        int blY;
        int width;

        public Bitmap(int xmin, int xmax, int ymin, int ymax) {
            if (xmin == Integer.MAX_VALUE) {
                this.pixels = null;
                return;
            }
            this.blX = xmin;
            this.blY = ymin;
            this.pixels = new boolean[xmax - xmin + 1][];
            this.width = ymax - ymin + 1;
            for (int x = 0; x < this.pixels.length; ++x) {
                this.pixels[x] = new boolean[this.width];
            }
        }

        public boolean isBlack(int x, int y) {
            int iX = x - this.blX;
            int iY = y - this.blY;
            if (iX < 0 || this.pixels.length <= iX || iY < 0 || this.width <= iY) {
                return false;
            }
            return this.pixels[iX][iY];
        }

        public void paintBlack(int x, int y) {
            this.pixels[x - this.blX][y - this.blY] = true;
        }

        protected void paintBlack(int xOn, int xOff, int y) {
            for (int x = xOn; x < xOff; ++x) {
                this.paintBlack(x, y);
            }
        }

        protected void emitBitmap(BitmapConsumer bitmapConsumer) {
            if (this.pixels == null) {
                return;
            }
            for (int x = 0; x < this.pixels.length; ++x) {
                for (int y = 0; y < this.width; ++y) {
                    if (!this.pixels[x][y]) continue;
                    bitmapConsumer.addRun(this.blX + x, this.blX + x + 1, this.blY + y);
                }
            }
        }
    }

    private class CrossBuilder
    extends OutlineConsumer2BaseImpl {
        int xmin;
        int ymin;
        int xmax;
        int ymax;
        boolean zeroDimension;
        Direction currentDir;
        Direction firstSegmentDir;
        int firstSegmentX;
        int firstSegmentY;
        private double THRESHOLD = 127.0;
        private double epsilon;
        int depth = 0;
        final int[] zShiftTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3};

        public void setFlatness(double flatness) {
            this.epsilon = Math.max(1.220703125E-4, 1.5 * flatness / 4.0);
        }

        @Override
        public void startOutline() {
            this.xmin = Integer.MAX_VALUE;
            this.ymin = Integer.MAX_VALUE;
            this.xmax = Integer.MIN_VALUE;
            this.ymax = Integer.MIN_VALUE;
            TTScan.this.hScanLines = new ScanLines(true);
            TTScan.this.vScanLines = new ScanLines(false);
        }

        @Override
        public void startContour() {
            this.currentDir = Direction.NONE;
        }

        @Override
        public void line(int x1, int y1, int x2, int y2) {
            this.xmin = F26Dot6.min(x1, F26Dot6.min(x2, this.xmin));
            this.ymin = F26Dot6.min(y1, F26Dot6.min(y2, this.ymin));
            this.xmax = F26Dot6.max(x1, F26Dot6.max(x2, this.xmax));
            this.ymax = F26Dot6.max(y1, F26Dot6.max(y2, this.ymax));
            Direction thisSegmentDir = Direction.ofSegment(x1, y1, x2, y2);
            if (thisSegmentDir == Direction.NO_MOVE) {
                return;
            }
            this.doLine(thisSegmentDir, x1, y1, x2, y2);
            if (this.currentDir == Direction.NONE) {
                this.firstSegmentX = x1;
                this.firstSegmentY = y1;
                this.firstSegmentDir = thisSegmentDir;
            } else {
                this.endPointH(this.currentDir, x1, y1, thisSegmentDir);
                if (TTScan.this.isFixing(TTScan.this.scanType)) {
                    this.endPointV(this.currentDir, x1, y1, thisSegmentDir);
                }
            }
            this.currentDir = thisSegmentDir;
        }

        private void doLine(Direction thisSegmentDir, int x1, int y1, int x2, int y2) {
            block15: {
                int fxXX2;
                int lXOffset;
                int lXIncr;
                int lXSteps;
                int lXScan;
                int fxXInit;
                int fxYY2;
                int lYOffset;
                int lYIncr;
                int lYSteps;
                int lYScan;
                int fxYInit;
                long q;
                block14: {
                    int fxXScan;
                    int fxYScan;
                    int quadrant;
                    if (!thisSegmentDir.isDown) {
                        quadrant = 1;
                        q = 0L;
                        fxYScan = TTScan.this.scanlineAbove(y1) + 32;
                        fxYInit = fxYScan - y1;
                        lYScan = F26Dot6.toInt(fxYScan);
                        lYSteps = F26Dot6.toInt(TTScan.this.scanlineBelow(y2)) - lYScan + 1;
                        lYIncr = 1;
                        lYOffset = 0;
                        fxYY2 = y2 - y1;
                    } else {
                        quadrant = 4;
                        q = 1L;
                        fxYScan = TTScan.this.scanlineBelow(y1) + 32;
                        fxYInit = y1 - fxYScan;
                        lYScan = F26Dot6.toInt(fxYScan);
                        lYSteps = lYScan - F26Dot6.toInt(TTScan.this.scanlineAbove(y2)) + 1;
                        lYIncr = -1;
                        lYOffset = 1;
                        fxYY2 = y1 - y2;
                    }
                    if (y2 == y1) {
                        if (!TTScan.this.isFixing(TTScan.this.scanType)) {
                            return;
                        }
                        lYScan = F26Dot6.toInt(TTScan.this.scanlineAbove(x2 < x1 ? y1 - 1 : y1));
                        lYSteps = 0;
                    }
                    if (!thisSegmentDir.isLeft) {
                        fxXScan = TTScan.this.scanlineAbove(x1) + 32;
                        fxXInit = fxXScan - x1;
                        lXScan = F26Dot6.toInt(fxXScan);
                        lXSteps = F26Dot6.toInt(TTScan.this.scanlineBelow(x2)) - lXScan + 1;
                        lXIncr = 1;
                        lXOffset = 0;
                        fxXX2 = x2 - x1;
                    } else {
                        q = 1L - q;
                        quadrant = quadrant == 1 ? 2 : 3;
                        fxXScan = TTScan.this.scanlineBelow(x1) + 32;
                        fxXInit = x1 - fxXScan;
                        lXScan = F26Dot6.toInt(fxXScan);
                        lXSteps = lXScan - F26Dot6.toInt(TTScan.this.scanlineAbove(x2)) + 1;
                        lXIncr = -1;
                        lXOffset = 1;
                        fxXX2 = x1 - x2;
                    }
                    if (x2 == x1) {
                        lXScan = F26Dot6.toInt(TTScan.this.scanlineAbove(y2 > y1 ? x1 - 1 : x1));
                        lXSteps = 0;
                    }
                    if (y1 != y2) break block14;
                    if (!TTScan.this.isFixing(TTScan.this.scanType)) break block15;
                    for (int i = 0; i < lXSteps; ++i) {
                        TTScan.this.vScanLines.addCross(F26Dot6.fromInt(lYScan), lXScan, thisSegmentDir.isLeft);
                        lXScan += lXIncr;
                    }
                    break block15;
                }
                if (x1 == x2) {
                    for (int i = 0; i < lYSteps; ++i) {
                        TTScan.this.hScanLines.addCross(F26Dot6.fromInt(lXScan), lYScan, thisSegmentDir.isUp);
                        lYScan += lYIncr;
                    }
                } else {
                    q += (long)fxXX2 * (long)fxYInit - (long)fxYY2 * (long)fxXInit;
                    long lDQy = fxXX2 << 6;
                    long lDQx = -fxYY2 << 6;
                    for (int i = 0; i < lXSteps + lYSteps; ++i) {
                        if (q > 0L) {
                            if (TTScan.this.isFixing(TTScan.this.scanType)) {
                                TTScan.this.vScanLines.addCross(F26Dot6.fromInt(lYScan + lYOffset), lXScan, thisSegmentDir.isLeft);
                            }
                            lXScan += lXIncr;
                            q += lDQx;
                            continue;
                        }
                        TTScan.this.hScanLines.addCross(F26Dot6.fromInt(lXScan + lXOffset), lYScan, thisSegmentDir.isUp);
                        lYScan += lYIncr;
                        q += lDQy;
                    }
                }
            }
        }

        @Override
        public void quadraticCurve(int x1, int y1, int x2, int y2, int x3, int y3) {
            this.depth = 0;
            this.doQuadraticCurve(x1, y1, x2, y2, x3, y3);
        }

        public void doQuadraticCurve(int x1, int y1, int x2, int y2, int x3, int y3) {
            int tZ;
            int sZ;
            int rZ;
            int dqy;
            int dqx;
            int xx3;
            int xx2;
            int xoffset;
            int xincr;
            int i_xstop;
            int i_xscan;
            int xinit;
            int xscan;
            int yy3;
            int yy2;
            int yoffset;
            int yincr;
            int i_ystop;
            int i_yscan;
            int yinit;
            int yscan;
            int q;
            ++this.depth;
            if (this.depth > 100) {
                System.err.println("dpeth!");
            }
            if (!(y1 <= y2 && y2 <= y3 || y3 <= y2 && y2 <= y1)) {
                int num = y2 - y1;
                int denom = num - (y3 - y2);
                int x4 = x1 + F26Dot6.multiplyDivide(x2 - x1, num, denom);
                int x6 = x2 + F26Dot6.multiplyDivide(x3 - x2, num, denom);
                int x5 = x4 + F26Dot6.multiplyDivide(x6 - x4, num, denom);
                int y456 = y1 + F26Dot6.multiplyDivide(y2 - y1, num, denom);
                this.doQuadraticCurve(x1, y1, x4, y456, x5, y456);
                this.doQuadraticCurve(x5, y456, x6, y456, x3, y3);
                return;
            }
            if (!(x1 <= x2 && x2 <= x3 || x3 <= x2 && x2 <= x1)) {
                int num = x2 - x1;
                int denom = num - (x3 - x2);
                int y4 = y1 + F26Dot6.multiplyDivide(y2 - y1, num, denom);
                int y6 = y2 + F26Dot6.multiplyDivide(y3 - y2, num, denom);
                int y5 = y4 + F26Dot6.multiplyDivide(y6 - y4, num, denom);
                int x456 = x1 + F26Dot6.multiplyDivide(x2 - x1, num, denom);
                this.doQuadraticCurve(x1, y1, x456, y4, x456, y5);
                this.doQuadraticCurve(x456, y5, x456, y6, x3, y3);
                return;
            }
            if (Math.abs(x3 - x1) > 3200 || Math.abs(y3 - y1) > 3200) {
                int fxX4 = x1 + x2 >> 1;
                int fxY4 = y1 + y2 >> 1;
                int fxX6 = x2 + x3 >> 1;
                int fxY6 = y2 + y3 >> 1;
                int fxX5 = fxX4 + fxX6 >> 1;
                int fxY5 = fxY4 + fxY6 >> 1;
                this.doQuadraticCurve(x1, y1, fxX4, fxY4, fxX5, fxY5);
                this.doQuadraticCurve(fxX5, fxY5, fxX6, fxY6, x3, y3);
                return;
            }
            Direction thisSegmentDir = Direction.ofSegment(x1, y1, x3, y3);
            if (thisSegmentDir == Direction.NO_MOVE) {
                return;
            }
            this.xmin = F26Dot6.min(x1, F26Dot6.min(x3, this.xmin));
            this.ymin = F26Dot6.min(y1, F26Dot6.min(y3, this.ymin));
            this.xmax = F26Dot6.max(x1, F26Dot6.max(x3, this.xmax));
            this.ymax = F26Dot6.max(y1, F26Dot6.max(y3, this.ymax));
            if (thisSegmentDir.isUp) {
                q = 0;
                yscan = TTScan.this.scanlineAbove(y1) + 32;
                yinit = yscan - y1;
                i_yscan = F26Dot6.toInt(yscan);
                i_ystop = F26Dot6.toInt(TTScan.this.scanlineBelow(y3) + 32) + 1;
                yincr = 1;
                yoffset = 0;
                yy2 = y2 - y1;
                yy3 = y3 - y1;
            } else {
                q = 1;
                yscan = TTScan.this.scanlineBelow(y1) + 32;
                yinit = y1 - yscan;
                i_yscan = F26Dot6.toInt(yscan);
                i_ystop = F26Dot6.toInt(TTScan.this.scanlineAbove(y3) + 32) - 1;
                yincr = -1;
                yoffset = 1;
                yy2 = y1 - y2;
                yy3 = y1 - y3;
            }
            if (thisSegmentDir.isRight) {
                xscan = TTScan.this.scanlineAbove(x1) + 32;
                xinit = xscan - x1;
                i_xscan = F26Dot6.toInt(xscan);
                i_xstop = F26Dot6.toInt(TTScan.this.scanlineBelow(x3) + 32) + 1;
                xincr = 1;
                xoffset = 0;
                xx2 = x2 - x1;
                xx3 = x3 - x1;
            } else {
                q = 1 - q;
                xscan = TTScan.this.scanlineBelow(x1) + 32;
                xinit = x1 - xscan;
                i_xscan = F26Dot6.toInt(xscan);
                i_xstop = F26Dot6.toInt(TTScan.this.scanlineAbove(x3) + 32) - 1;
                xincr = -1;
                xoffset = 1;
                xx2 = x1 - x2;
                xx3 = x1 - x3;
            }
            int alpha = 2 * (xx2 * yy3 - yy2 * xx3);
            if (alpha == 0) {
                this.line(x1, y1, x3, y3);
                return;
            }
            int aBits = Math2.powerOf2(alpha);
            int xyBits = Math2.powerOf2(xx3 > yy3 ? xx3 : yy3);
            int zShift = this.zShiftTable[aBits + xyBits];
            int zBits = 6 - zShift;
            if (zShift > 0) {
                int zRound = 1 << zShift - 1;
                xx2 = xx2 + zRound >> zShift;
                yy2 = yy2 + zRound >> zShift;
                xx3 = xx3 + zRound >> zShift;
                yy3 = yy3 + zRound >> zShift;
                xinit = xinit + zRound >> zShift;
                yinit = yinit + zRound >> zShift;
                alpha = 2 * (xx2 * yy3 - yy2 * xx3);
            }
            int ax = xx3 - xx2 * 2;
            int ay = yy3 - yy2 * 2;
            int r = ay * ay;
            int s2 = -ax * ay;
            int t = ax * ax;
            int u2 = yy2 * alpha;
            int v2 = -xx2 * alpha;
            int zSubpix = 1 << zBits;
            if (xyBits <= 7) {
                q += (r * xinit + (s2 << 1) * yinit + (u2 << 1)) * xinit + (t * yinit + (v2 << 1)) * yinit;
                dqx = r * ((xinit << 1) + zSubpix) + (s2 << 1) * yinit + (u2 << 1) << zBits;
                dqy = t * ((yinit << 1) + zSubpix) + (s2 << 1) * xinit + (v2 << 1) << zBits;
                rZ = r << (zBits << 1);
                sZ = s2 << 1 << (zBits << 1);
                tZ = t << (zBits << 1);
            } else {
                q += ((r >> 1) * xinit + s2 * yinit + u2 >> zBits) * xinit + ((t >> 1) * yinit + v2 >> zBits) * yinit;
                dqx = r * (xinit + (zSubpix >> 1)) + s2 * yinit + u2;
                dqy = t * (yinit + (zSubpix >> 1)) + s2 * xinit + v2;
                rZ = r << zBits - 1;
                sZ = s2 << zBits;
                tZ = t << zBits - 1;
            }
            int ddqx = 2 * rZ;
            int ddqy = 2 * tZ;
            if (alpha > 0) {
                while (i_xscan != i_xstop && i_yscan != i_ystop) {
                    if (q < 0 || dqy > tZ) {
                        if (TTScan.this.isFixing(TTScan.this.scanType)) {
                            TTScan.this.vScanLines.addCross(F26Dot6.fromInt(i_yscan + yoffset), i_xscan, thisSegmentDir.isLeft);
                        }
                        i_xscan += xincr;
                        q += dqx;
                        dqx += ddqx;
                        dqy += sZ;
                        continue;
                    }
                    TTScan.this.hScanLines.addCross(F26Dot6.fromInt(i_xscan + xoffset), i_yscan, thisSegmentDir.isUp);
                    i_yscan += yincr;
                    q += dqy;
                    dqy += ddqy;
                    dqx += sZ;
                }
            } else {
                while (i_xscan != i_xstop && i_yscan != i_ystop) {
                    if (q < 0 || dqx > rZ) {
                        TTScan.this.hScanLines.addCross(F26Dot6.fromInt(i_xscan + xoffset), i_yscan, thisSegmentDir.isUp);
                        i_yscan += yincr;
                        q += dqy;
                        dqy += ddqy;
                        dqx += sZ;
                        continue;
                    }
                    if (TTScan.this.isFixing(TTScan.this.scanType)) {
                        TTScan.this.vScanLines.addCross(F26Dot6.fromInt(i_yscan + yoffset), i_xscan, thisSegmentDir.isLeft);
                    }
                    i_xscan += xincr;
                    q += dqx;
                    dqx += ddqx;
                    dqy += sZ;
                }
            }
            while (i_xscan != i_xstop) {
                if (TTScan.this.isFixing(TTScan.this.scanType)) {
                    TTScan.this.vScanLines.addCross(F26Dot6.fromInt(i_yscan + yoffset), i_xscan, thisSegmentDir.isLeft);
                }
                i_xscan += xincr;
            }
            while (i_yscan != i_ystop) {
                TTScan.this.hScanLines.addCross(F26Dot6.fromInt(i_xscan + xoffset), i_yscan, thisSegmentDir.isUp);
                i_yscan += yincr;
            }
            if (this.currentDir == Direction.NONE) {
                this.firstSegmentX = x1;
                this.firstSegmentY = y1;
                this.firstSegmentDir = thisSegmentDir;
            } else {
                this.endPointH(this.currentDir, x1, y1, thisSegmentDir);
                if (TTScan.this.isFixing(TTScan.this.scanType)) {
                    this.endPointV(this.currentDir, x1, y1, thisSegmentDir);
                }
            }
            this.currentDir = thisSegmentDir;
        }

        @Override
        public void cubicCurve(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
            if ((x1 <= x2 && x2 <= x3 && x3 <= x4 || x4 <= x3 && x3 <= x2 && x2 <= x1) && Math.abs(x4 - x1) < this.THRESHOLD && Math.abs(x4 - x1 - 3.0 * (x2 - x1)) <= this.epsilon && Math.abs(x4 - x1 - 3.0 * (x4 - x3)) <= this.epsilon && (y1 <= y2 && y2 <= y3 && y3 <= y4 || y4 <= y3 && y3 <= y2 && y2 <= y1) && Math.abs(y4 - y1) < this.THRESHOLD && Math.abs(y4 - y1 - 3.0 * (y2 - y1)) <= this.epsilon && Math.abs(y4 - y1 - 3.0 * (y4 - y3)) <= this.epsilon) {
                this.line(x1, y1, x4, y4);
            } else {
                double x12 = (x2 + x1) / 2.0;
                double y12 = (y2 + y1) / 2.0;
                double x23 = (x3 + x2) / 2.0;
                double y23 = (y3 + y2) / 2.0;
                double x34 = (x4 + x3) / 2.0;
                double y34 = (y4 + y3) / 2.0;
                double x1223 = (x23 + x12) / 2.0;
                double y1223 = (y23 + y12) / 2.0;
                double x2334 = (x34 + x23) / 2.0;
                double y2334 = (y34 + y23) / 2.0;
                double xx = (x1223 + x2334) / 2.0;
                double yy = (y1223 + y2334) / 2.0;
                this.cubicCurve(x1, y1, x12, y12, x1223, y1223, xx, yy);
                this.cubicCurve(xx, yy, x2334, y2334, x34, y34, x4, y4);
            }
        }

        @Override
        public void endContour() {
            if (this.currentDir != Direction.NONE) {
                this.endPointH(this.currentDir, this.firstSegmentX, this.firstSegmentY, this.firstSegmentDir);
                if (TTScan.this.isFixing(TTScan.this.scanType)) {
                    this.endPointV(this.currentDir, this.firstSegmentX, this.firstSegmentY, this.firstSegmentDir);
                }
                this.currentDir = Direction.NONE;
            }
        }

        @Override
        public void endOutline() {
            this.xmin = F26Dot6.roundHalfDown(this.xmin);
            this.ymin = F26Dot6.roundHalfDown(this.ymin);
            this.xmax = F26Dot6.roundHalfUp(this.xmax);
            this.ymax = F26Dot6.roundHalfUp(this.ymax);
            this.zeroDimension = this.xmin == this.xmax || this.ymin == this.ymax;
        }

        void endPointH(Direction beforeDir, int x, int y, Direction afterDir) {
            int yI = F26Dot6.toInt(F26Dot6.floor(y));
            if (F26Dot6.fromInt(yI) + 32 != y) {
                return;
            }
            if (afterDir.isUp) {
                if (beforeDir.isUp) {
                    TTScan.this.hScanLines.addCross(x, yI, true);
                } else if (beforeDir.isDown) {
                    TTScan.this.hScanLines.addCross(x, yI, true);
                    TTScan.this.hScanLines.addCross(x, yI, false);
                } else if (beforeDir.isLeft) {
                    TTScan.this.hScanLines.addCross(x, yI, true);
                }
            } else if (afterDir.isDown) {
                if (beforeDir.isUp) {
                    TTScan.this.hScanLines.addCross(x, yI, true);
                    TTScan.this.hScanLines.addCross(x, yI, false);
                } else if (beforeDir.isDown) {
                    TTScan.this.hScanLines.addCross(x, yI, false);
                } else if (beforeDir.isRight) {
                    TTScan.this.hScanLines.addCross(x, yI, false);
                }
            } else if (beforeDir.isUp) {
                if (afterDir.isRight) {
                    TTScan.this.hScanLines.addCross(x, yI, true);
                }
            } else if (beforeDir.isDown) {
                if (afterDir.isLeft) {
                    TTScan.this.hScanLines.addCross(x, yI, false);
                }
            } else if (beforeDir.isRight && afterDir.isLeft) {
                TTScan.this.hScanLines.addCross(x, yI, false);
            } else if (beforeDir.isLeft && afterDir.isRight) {
                TTScan.this.hScanLines.addCross(x, yI, true);
            }
        }

        void endPointV(Direction beforeDir, int x, int y, Direction afterDir) {
            int xI = F26Dot6.toInt(F26Dot6.floor(x));
            if (F26Dot6.fromInt(xI) + 32 != x) {
                return;
            }
            if (afterDir.isLeft) {
                if (beforeDir.isLeft) {
                    TTScan.this.vScanLines.addCross(y, xI, true);
                } else if (beforeDir.isRight) {
                    TTScan.this.vScanLines.addCross(y, xI, true);
                    TTScan.this.vScanLines.addCross(y, xI, false);
                } else if (beforeDir.isDown) {
                    TTScan.this.vScanLines.addCross(y, xI, true);
                }
            } else if (afterDir.isRight) {
                if (beforeDir.isLeft) {
                    TTScan.this.vScanLines.addCross(y, xI, true);
                    TTScan.this.vScanLines.addCross(y, xI, false);
                } else if (beforeDir.isRight) {
                    TTScan.this.vScanLines.addCross(y, xI, false);
                } else if (beforeDir.isUp) {
                    TTScan.this.vScanLines.addCross(y, xI, false);
                }
            } else if (beforeDir.isLeft) {
                if (afterDir.isUp) {
                    TTScan.this.vScanLines.addCross(y, xI, true);
                }
            } else if (beforeDir.isRight) {
                if (afterDir.isDown) {
                    TTScan.this.vScanLines.addCross(y, xI, false);
                }
            } else if (beforeDir.isUp && afterDir.isDown) {
                TTScan.this.vScanLines.addCross(y, xI, false);
            } else if (beforeDir.isDown && afterDir.isUp) {
                TTScan.this.vScanLines.addCross(y, xI, true);
            }
        }

        private int getY(int x, int x1, int y1, int x2, int y2, int x3, int y3) {
            return 0;
        }

        private int getX(int y, int x1, int y1, int x2, int y2, int x3, int y3) {
            return 0;
        }
    }

    private class ScanLines {
        public int firstScanLineCoordI = Integer.MAX_VALUE;
        public ScanLine[] scanLines = null;
        public final boolean horizontal;

        public ScanLines(boolean horizontal) {
            this.horizontal = horizontal;
        }

        public void addCross(int coordOnScanLine, int scanLineCoordI, boolean on) {
            ScanLine[] newScanLines;
            if (this.scanLines == null) {
                this.scanLines = new ScanLine[1];
                this.firstScanLineCoordI = scanLineCoordI;
            } else if (scanLineCoordI < this.firstScanLineCoordI) {
                newScanLines = new ScanLine[this.firstScanLineCoordI - scanLineCoordI + this.scanLines.length];
                System.arraycopy(this.scanLines, 0, newScanLines, this.firstScanLineCoordI - scanLineCoordI, this.scanLines.length);
                this.scanLines = newScanLines;
                this.firstScanLineCoordI = scanLineCoordI;
            } else if (this.firstScanLineCoordI + this.scanLines.length - 1 < scanLineCoordI) {
                newScanLines = new ScanLine[scanLineCoordI - this.firstScanLineCoordI + 1];
                System.arraycopy(this.scanLines, 0, newScanLines, 0, this.scanLines.length);
                this.scanLines = newScanLines;
            }
            ScanLine scanLine = this.scanLines[scanLineCoordI - this.firstScanLineCoordI];
            if (scanLine == null) {
                this.scanLines[scanLineCoordI - this.firstScanLineCoordI] = scanLine = new ScanLine();
            }
            scanLine.addCross(coordOnScanLine, on);
        }

        public int countCrosses(int scanLineCoord, int v) {
            if (scanLineCoord < this.firstScanLineCoordI || this.firstScanLineCoordI + this.scanLines.length <= scanLineCoord) {
                return 0;
            }
            ScanLine r = this.scanLines[scanLineCoord - this.firstScanLineCoordI];
            if (r == null) {
                return 0;
            }
            int crossings = 0;
            int vv = F26Dot6.fromInt(v);
            for (int i = 0; i < r.onCrosses.values.length; ++i) {
                if (vv - 32 <= r.onCrosses.values[i] && r.onCrosses.values[i] < vv + 32) {
                    ++crossings;
                }
                if (vv - 32 > r.offCrosses.values[i] || r.offCrosses.values[i] >= vv + 32) continue;
                ++crossings;
            }
            return crossings;
        }
    }

    private static class ScanLine {
        F26Dot6List onCrosses = new F26Dot6List();
        F26Dot6List offCrosses = new F26Dot6List();

        private ScanLine() {
        }

        public void addCross(int coord, boolean on) {
            if (on) {
                this.onCrosses.add(coord);
            } else {
                this.offCrosses.add(coord);
            }
        }
    }

    private static class F26Dot6List {
        int[] values;

        private F26Dot6List() {
        }

        public void add(int v) {
            if (this.values == null) {
                this.values = new int[]{v};
            } else {
                int[] newValues = new int[this.values.length + 1];
                boolean inserted = false;
                int k = 0;
                for (int i = 0; i < this.values.length; ++i) {
                    if (!inserted && v < this.values[i]) {
                        newValues[k++] = v;
                        inserted = true;
                    }
                    newValues[k++] = this.values[i];
                }
                if (!inserted) {
                    newValues[k++] = v;
                }
                this.values = newValues;
            }
        }
    }

    private static class Direction {
        public final boolean isUp;
        public final boolean isDown;
        public final boolean isLeft;
        public final boolean isRight;
        public final String name;
        static final Direction E = new Direction("E", false, false, false, true);
        static final Direction NE = new Direction("NE", true, false, false, true);
        static final Direction N = new Direction("N", true, false, false, false);
        static final Direction NW = new Direction("NW", true, false, true, false);
        static final Direction W = new Direction("W", false, false, true, false);
        static final Direction SW = new Direction("SW", false, true, true, false);
        static final Direction S = new Direction("S", false, true, false, false);
        static final Direction SE = new Direction("SE", false, true, false, true);
        static final Direction NONE = new Direction("NONE", false, false, false, false);
        static final Direction NO_MOVE = new Direction("NO_MOVE", false, false, false, false);

        private Direction(String name, boolean isUp, boolean isDown, boolean isLeft, boolean isRight) {
            this.name = name;
            this.isUp = isUp;
            this.isDown = isDown;
            this.isLeft = isLeft;
            this.isRight = isRight;
        }

        public static Direction ofSegment(double x1, double y1, double x2, double y2) {
            if (x1 < x2) {
                if (y1 < y2) {
                    return NE;
                }
                if (y1 == y2) {
                    return E;
                }
                return SE;
            }
            if (x1 == x2) {
                if (y1 < y2) {
                    return N;
                }
                if (y1 == y2) {
                    return NO_MOVE;
                }
                return S;
            }
            if (y1 < y2) {
                return NW;
            }
            if (y1 == y2) {
                return W;
            }
            return SW;
        }
    }
}

