/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.CoolTypeScript;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontDescription;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.SWFFont4Description;
import com.adobe.fontengine.font.SWFFontDescription;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnderlineMetrics;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.fontmanagement.CacheSupportInfo;
import com.adobe.fontengine.fontmanagement.Platform;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDescription;
import java.util.Map;

public abstract class FontImpl
implements Font {
    static final long serialVersionUID = 1L;

    @Override
    public double getUnitsPerEmX() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getUnitsPerEmX();
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public double getUnitsPerEmY() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getUnitsPerEmY();
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public LineMetrics getLineMetrics() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getLineMetrics();
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public Rect getCoolTypeGlyphBBox(int glyphID) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getCoolTypeGlyphBBox(glyphID);
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public LineMetrics getCoolTypeLineMetrics() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getCoolTypeLineMetrics();
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public CoolTypeScript getCoolTypeScript() throws FontLoadingException, InvalidFontException, UnsupportedFontException {
        try {
            return this.getFontData().getCoolTypeScript();
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public UnderlineMetrics getCoolTypeUnderlineMetrics() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getCoolTypeUnderlineMetrics();
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public Rect getCoolTypeIdeoEmBox() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getCoolTypeIdeoEmBox();
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public boolean hasCoolTypeProportionalRoman() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().hasCoolTypeProportionalRoman();
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public Rect getCoolTypeIcfBox() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getCoolTypeIcfBox();
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public boolean isSymbolic() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().isSymbolic();
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public boolean canEmbedForEditting() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            Permission thePerm = this.getFontData().getEmbeddingPermission(this.wasEmbedded());
            return thePerm != Permission.RESTRICTED && thePerm != Permission.PREVIEW_AND_PRINT;
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public boolean canEmbedForPrintAndPreview() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return this.getFontData().getEmbeddingPermission(this.wasEmbedded()) != Permission.RESTRICTED;
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public Subset createSubset() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return this.getFontData().createSubset();
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    public FontData getFontData() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return this.retrieveFontData();
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public SWFFont4Description getSWFFont4Description() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return this.retrieveFontData().getSWFFont4Description(this.wasEmbedded());
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public SWFFontDescription getSWFFontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return this.retrieveFontData().getSWFFontDescription(this.wasEmbedded());
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public PDFFontDescription getPDFFontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return this.retrieveFontData().getPDFFontDescription(this);
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public XDCFontDescription getXDCFontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return this.retrieveFontData().getXDCFontDescription(this);
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public PostscriptFontDescription[] getPostscriptFontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return (PostscriptFontDescription[])this.getFontDescription(PostscriptFontDescription[].class.getSimpleName());
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public CSS20FontDescription[] getCSS20FontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return (CSS20FontDescription[])this.getFontDescription(CSS20FontDescription[].class.getSimpleName());
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public CSS20FontDescription getPreferredCSS20FontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return (CSS20FontDescription)this.getFontDescription(CSS20FontDescription.class.getSimpleName());
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public FXGFontDescription[] getFXGFontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        return this.getFXGFontDescription(null, null);
    }

    @Override
    public FXGFontDescription[] getFXGFontDescription(Platform platform) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        return this.getFXGFontDescription(platform, null);
    }

    @Override
    public FXGFontDescription[] getFXGFontDescription(Platform platform, ULocale locale) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            FXGFontDescription[] fxgDesc = (FXGFontDescription[])this.getFontDescription(FXGFontDescription[].class.getSimpleName());
            if (platform == null && locale == null) {
                return fxgDesc;
            }
            int itemCount = 0;
            for (int i = 0; i < fxgDesc.length; ++i) {
                if (platform != null && platform != fxgDesc[i].getPlatform() || locale != null && locale != fxgDesc[i].getLocale()) continue;
                ++itemCount;
            }
            FXGFontDescription[] fxgCopy = new FXGFontDescription[itemCount];
            itemCount = 0;
            for (int i = 0; i < fxgDesc.length; ++i) {
                if (platform != null && platform != fxgDesc[i].getPlatform() || locale != null && locale != fxgDesc[i].getLocale()) continue;
                fxgCopy[itemCount++] = fxgDesc[i];
            }
            return fxgCopy;
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    @Override
    public PlatformFontDescription[] getPlatformFontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        return this.getPlatformFontDescription(null, null);
    }

    @Override
    public PlatformFontDescription[] getPlatformFontDescription(Platform platform) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        return this.getPlatformFontDescription(platform, null);
    }

    @Override
    public PlatformFontDescription[] getPlatformFontDescription(Platform platform, ULocale locale) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            PlatformFontDescription[] platDesc = (PlatformFontDescription[])this.getFontDescription(PlatformFontDescription[].class.getSimpleName());
            if (platform == null && locale == null) {
                return platDesc;
            }
            int itemCount = 0;
            for (int i = 0; i < platDesc.length; ++i) {
                if (platform != null && platform != platDesc[i].getPlatform() || locale != null && locale != platDesc[i].getLocale()) continue;
                ++itemCount;
            }
            PlatformFontDescription[] platCopy = new PlatformFontDescription[itemCount];
            itemCount = 0;
            for (int i = 0; i < platDesc.length; ++i) {
                if (platform != null && platform != platDesc[i].getPlatform() || locale != null && locale != platDesc[i].getLocale()) continue;
                platCopy[itemCount++] = platDesc[i];
            }
            return platCopy;
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    public CacheSupportInfo getCacheSupportInfo() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return (CacheSupportInfo)this.getFontDescription(CacheSupportInfo.class.getSimpleName());
        }
        catch (InvalidFontException e) {
            e.initFont(this);
            throw e;
        }
        catch (UnsupportedFontException e) {
            e.initFont(this);
            throw e;
        }
    }

    private Object getFontDescription(String type) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontDescription[] cacheDes = this.getCachedFontDescription(type);
        if (cacheDes == null) {
            if (type.equals("CacheSupportInfo")) {
                cacheDes = this.retrieveFontData().getCacheSupportInfo();
            } else if (type.equals("CSS20FontDescription")) {
                cacheDes = this.retrieveFontData().getPreferredCSS20FontDescription();
            } else if (type.equals("CSS20FontDescription[]")) {
                cacheDes = this.retrieveFontData().getCSS20FontDescription();
            } else if (type.equals("FXGFontDescription[]")) {
                cacheDes = this.retrieveFontData().getFXGFontDescription(null, null);
            } else if (type.equals("PlatformFontDescription[]")) {
                cacheDes = this.retrieveFontData().getPlatformFontDescription(null, null);
            } else if (type.equals("PostscriptFontDescription[]")) {
                cacheDes = this.retrieveFontData().getPostscriptFontDescription();
            } else {
                throw new RuntimeException("Undefined font description class");
            }
            if (cacheDes != null) {
                this.setCachedFontDescription(type, cacheDes);
            }
        }
        return cacheDes;
    }

    public abstract String getCanonicalPath();

    public abstract long getLength();

    public abstract long getLastModified();

    public abstract Object getCachedFontDescription(String var1);

    public abstract Map<String, Object> getCachedFontDescriptionMap();

    public abstract void setCachedFontDescription(String var1, Object var2);

    public boolean wasEmbedded() {
        return false;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    protected abstract FontData retrieveFontData() throws InvalidFontException, UnsupportedFontException, FontLoadingException;
}

