/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine;

import java.io.Serializable;
import java.util.Arrays;

final class CombiningSequence
implements Serializable {
    static final long serialVersionUID = 1L;
    private final int composeTo;
    private final int[] mapFrom;
    private final int[] nextChar;
    private final CombiningSequence[] nextSequence;
    private static final int[] emptyIntArray = new int[0];

    CombiningSequence(int composeTo, int[] mapFrom, int[] nextChar, CombiningSequence[] nextSequence) {
        this.composeTo = composeTo;
        this.mapFrom = (int[])mapFrom.clone();
        this.nextChar = (int[])nextChar.clone();
        this.nextSequence = (CombiningSequence[])nextSequence.clone();
    }

    final int compose(int[] usvs, int start, int limit) {
        if (start >= limit) {
            return this.composeTo;
        }
        int index = Arrays.binarySearch(this.nextChar, usvs[start]);
        if (index < 0) {
            return -1;
        }
        return this.nextSequence[index].compose(usvs, start + 1, limit);
    }

    final int[] map(int[] usvs, int start, int limit) {
        if (start >= limit) {
            return (int[])this.mapFrom.clone();
        }
        int index = Arrays.binarySearch(this.nextChar, usvs[start]);
        if (index < 0) {
            return emptyIntArray;
        }
        return this.nextSequence[index].map(usvs, start + 1, limit);
    }
}

