/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.util;

import com.adobe.agl.impl.ICUResourceBundle;
import com.adobe.agl.impl.ICUResourceBundleReader;
import com.adobe.agl.impl.ResourceBundleWrapper;
import com.adobe.agl.util.ULocale;
import com.adobe.agl.util.UResourceBundleIterator;
import com.adobe.agl.util.UResourceTypeMismatchException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class UResourceBundle
extends ResourceBundle {
    private static SoftReference BUNDLE_CACHE;
    private static final ResourceCacheKey cacheKey;
    private static SoftReference ROOT_CACHE;
    private Vector keys = null;
    protected String key;
    protected int size = 1;
    protected long resource = -1L;
    protected boolean isTopLevel = false;

    public static UResourceBundle getBundleInstance(String baseName, String localeName) {
        return UResourceBundle.getBundleInstance(baseName, localeName, ICUResourceBundle.ICU_DATA_CLASS_LOADER, false);
    }

    public static UResourceBundle getBundleInstance(String baseName, String localeName, ClassLoader root) {
        return UResourceBundle.getBundleInstance(baseName, localeName, root, false);
    }

    protected static UResourceBundle getBundleInstance(String baseName, String localeName, ClassLoader root, boolean disableFallback) {
        return UResourceBundle.instantiateBundle(baseName, localeName, root, disableFallback);
    }

    public static UResourceBundle getBundleInstance(String baseName, ULocale locale) {
        if (baseName == null) {
            baseName = "com/adobe/agl/impl/data/icudt40b";
        }
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        return UResourceBundle.getBundleInstance(baseName, locale.toString(), ICUResourceBundle.ICU_DATA_CLASS_LOADER, false);
    }

    public abstract ULocale getULocale();

    protected abstract String getLocaleID();

    protected abstract String getBaseName();

    protected abstract UResourceBundle getParent();

    public Locale getLocale() {
        return this.getULocale().toLocale();
    }

    private static void addToCache(ResourceCacheKey key, UResourceBundle b) {
        HashMap<ResourceCacheKey, UResourceBundle> m = null;
        if (BUNDLE_CACHE != null) {
            m = (HashMap<ResourceCacheKey, UResourceBundle>)BUNDLE_CACHE.get();
        }
        if (m == null) {
            m = new HashMap<ResourceCacheKey, UResourceBundle>();
            BUNDLE_CACHE = new SoftReference(m);
        }
        m.put(key, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addToCache(ClassLoader cl, String fullName, ULocale defaultLocale, UResourceBundle b) {
        ResourceCacheKey resourceCacheKey = cacheKey;
        synchronized (resourceCacheKey) {
            UResourceBundle.cacheKey.setKeyValues(cl, fullName, defaultLocale);
            UResourceBundle.addToCache((ResourceCacheKey)cacheKey.clone(), b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static UResourceBundle loadFromCache(ClassLoader cl, String fullName, ULocale defaultLocale) {
        ResourceCacheKey resourceCacheKey = cacheKey;
        synchronized (resourceCacheKey) {
            UResourceBundle.cacheKey.setKeyValues(cl, fullName, defaultLocale);
            return UResourceBundle.loadFromCache(cacheKey);
        }
    }

    private static UResourceBundle loadFromCache(ResourceCacheKey key) {
        Map m;
        if (BUNDLE_CACHE != null && (m = (Map)BUNDLE_CACHE.get()) != null) {
            return (UResourceBundle)m.get(key);
        }
        return null;
    }

    private static int getRootType(String baseName, ClassLoader root) {
        Integer rootType;
        HashMap<String, Integer> m = null;
        if (ROOT_CACHE != null) {
            m = (HashMap<String, Integer>)ROOT_CACHE.get();
        }
        if (m == null) {
            m = new HashMap<String, Integer>();
            ROOT_CACHE = new SoftReference(m);
        }
        if ((rootType = (Integer)m.get(baseName)) == null) {
            String rootLocale = baseName.indexOf(46) == -1 ? "root" : "";
            int rt = 0;
            try {
                ICUResourceBundle.getBundleInstance(baseName, rootLocale, root, true);
                rt = 1;
            }
            catch (MissingResourceException ex) {
                try {
                    ResourceBundleWrapper.getBundleInstance(baseName, rootLocale, root, true);
                    rt = 2;
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
            }
            rootType = new Integer(rt);
            m.put(baseName, rootType);
        }
        return rootType;
    }

    private static void setRootType(String baseName, int rootType) {
        Integer rt = new Integer(rootType);
        HashMap<String, Integer> m = null;
        if (ROOT_CACHE != null) {
            m = (HashMap<String, Integer>)ROOT_CACHE.get();
        } else {
            m = new HashMap<String, Integer>();
            ROOT_CACHE = new SoftReference(m);
        }
        m.put(baseName, rt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static UResourceBundle instantiateBundle(String baseName, String localeName, ClassLoader root, boolean disableFallback) {
        UResourceBundle b = null;
        int rootType = UResourceBundle.getRootType(baseName, root);
        ULocale defaultLocale = ULocale.getDefault();
        switch (rootType) {
            case 1: {
                if (disableFallback) {
                    String fullName = ICUResourceBundleReader.getFullName(baseName, localeName);
                    ResourceCacheKey resourceCacheKey = cacheKey;
                    synchronized (resourceCacheKey) {
                        UResourceBundle.cacheKey.setKeyValues(root, fullName, defaultLocale);
                        b = UResourceBundle.loadFromCache(cacheKey);
                    }
                    if (b == null) {
                        b = ICUResourceBundle.getBundleInstance(baseName, localeName, root, disableFallback);
                        UResourceBundle.addToCache(cacheKey, b);
                    }
                } else {
                    b = ICUResourceBundle.getBundleInstance(baseName, localeName, root, disableFallback);
                }
                return b;
            }
            case 2: {
                return ResourceBundleWrapper.getBundleInstance(baseName, localeName, root, disableFallback);
            }
        }
        try {
            b = ICUResourceBundle.getBundleInstance(baseName, localeName, root, disableFallback);
            UResourceBundle.setRootType(baseName, 1);
        }
        catch (MissingResourceException ex) {
            b = ResourceBundleWrapper.getBundleInstance(baseName, localeName, root, disableFallback);
            UResourceBundle.setRootType(baseName, 2);
        }
        return b;
    }

    public ByteBuffer getBinary() {
        throw new UResourceTypeMismatchException("");
    }

    public String getString() {
        throw new UResourceTypeMismatchException("");
    }

    public int[] getIntVector() {
        throw new UResourceTypeMismatchException("");
    }

    public UResourceBundle get(String aKey) {
        UResourceBundle obj = this.handleGet(aKey, null, this);
        if (obj == null) {
            UResourceBundle res = this;
            while ((res = res.getParent()) != null && obj == null) {
                obj = res.handleGet(aKey, null, this);
            }
            if (obj == null) {
                String fullName = ICUResourceBundleReader.getFullName(this.getBaseName(), this.getLocaleID());
                throw new MissingResourceException("Can't find resource for bundle " + fullName + ", key " + aKey, this.getClass().getName(), aKey);
            }
        }
        ((ICUResourceBundle)obj).setLoadingStatus(this.getLocaleID());
        return obj;
    }

    public String getString(int index) {
        ICUResourceBundle temp = (ICUResourceBundle)this.get(index);
        if (temp.getType() == 0) {
            return temp.getString();
        }
        throw new UResourceTypeMismatchException("");
    }

    public UResourceBundle get(int index) {
        UResourceBundle obj = this.handleGet(index, null, this);
        if (obj == null) {
            obj = (ICUResourceBundle)this.getParent();
            if (obj != null) {
                obj = obj.get(index);
            }
            if (obj == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + this.getKey(), this.getClass().getName(), this.getKey());
            }
        }
        ((ICUResourceBundle)obj).setLoadingStatus(this.getLocaleID());
        return obj;
    }

    public Enumeration getKeys() {
        this.initKeysVector();
        return this.keys.elements();
    }

    private synchronized void initKeysVector() {
        if (this.keys != null) {
            return;
        }
        this.keys = new Vector();
        Enumeration e = this.handleGetKeys();
        while (e.hasMoreElements()) {
            String elem = (String)e.nextElement();
            if (this.keys.contains(elem)) continue;
            this.keys.add(elem);
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getType() {
        int type = ICUResourceBundle.RES_GET_TYPE(this.resource);
        if (type == 4) {
            return 2;
        }
        return type;
    }

    public UResourceBundleIterator getIterator() {
        return new UResourceBundleIterator(this);
    }

    public String getKey() {
        return this.key;
    }

    protected UResourceBundle handleGet(String aKey, HashMap table, UResourceBundle requested) {
        return null;
    }

    protected UResourceBundle handleGet(int index, HashMap table, UResourceBundle requested) {
        return null;
    }

    protected String[] handleGetStringArray() {
        return null;
    }

    protected Enumeration handleGetKeys() {
        Vector<String> resKeys = new Vector<String>();
        UResourceBundle item = null;
        for (int i = 0; i < this.size; ++i) {
            item = this.get(i);
            resKeys.add(item.getKey());
        }
        return resKeys.elements();
    }

    protected Object handleGetObject(String aKey) {
        return this.handleGetObjectImpl(aKey, this);
    }

    private Object handleGetObjectImpl(String aKey, UResourceBundle requested) {
        Object obj = this.resolveObject(aKey, requested);
        if (obj == null) {
            UResourceBundle parentBundle = this.getParent();
            if (parentBundle != null) {
                obj = parentBundle.handleGetObjectImpl(aKey, requested);
            }
            if (obj == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + aKey, this.getClass().getName(), aKey);
            }
        }
        return obj;
    }

    private Object resolveObject(String aKey, UResourceBundle requested) {
        if (this.getType() == 0) {
            return this.getString();
        }
        UResourceBundle obj = this.handleGet(aKey, null, requested);
        if (obj != null) {
            if (obj.getType() == 0) {
                return obj.getString();
            }
            try {
                if (obj.getType() == 8) {
                    return obj.handleGetStringArray();
                }
            }
            catch (UResourceTypeMismatchException ex) {
                return obj;
            }
        }
        return obj;
    }

    static {
        cacheKey = new ResourceCacheKey();
    }

    private static final class ResourceCacheKey
    implements Cloneable {
        private SoftReference loaderRef;
        private String searchName;
        private ULocale defaultLocale;
        private int hashCodeCache;

        private ResourceCacheKey() {
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            try {
                ResourceCacheKey otherEntry = (ResourceCacheKey)other;
                if (this.hashCodeCache != otherEntry.hashCodeCache) {
                    return false;
                }
                if (!this.searchName.equals(otherEntry.searchName)) {
                    return false;
                }
                if (this.defaultLocale == null ? otherEntry.defaultLocale != null : !this.defaultLocale.equals(otherEntry.defaultLocale)) {
                    return false;
                }
                if (this.loaderRef == null) {
                    return otherEntry.loaderRef == null;
                }
                return otherEntry.loaderRef != null && this.loaderRef.get() == otherEntry.loaderRef.get();
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCodeCache;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException();
            }
        }

        private synchronized void setKeyValues(ClassLoader root, String searchName, ULocale defaultLocale) {
            this.searchName = searchName;
            this.hashCodeCache = searchName.hashCode();
            this.defaultLocale = defaultLocale;
            if (defaultLocale != null) {
                this.hashCodeCache ^= defaultLocale.hashCode();
            }
            if (root == null) {
                this.loaderRef = null;
            } else {
                this.loaderRef = new SoftReference<ClassLoader>(root);
                this.hashCodeCache ^= root.hashCode();
            }
        }
    }
}

