/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.guides.aspects;

import com.adobe.guides.aspects.AspectUtils;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class LogExecutionTimeAspect {
    private static final Logger log = LoggerFactory.getLogger(LogExecutionTimeAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ LogExecutionTimeAspect ajc$perSingletonInstance;

    static {
        try {
            LogExecutionTimeAspect.ajc$perSingletonInstance = new LogExecutionTimeAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Around(value="@annotation(com.adobe.guides.customannotations.LogExecutionTime)")
    public Object logExecutionTime(ProceedingJoinPoint joinPoint) throws Throwable {
        if (AspectUtils.enableLogExecutionTime()) {
            log.debug(" {}  starting log execution time for this method", (Object)joinPoint.getSignature());
            long start = System.currentTimeMillis();
            Object proceed = joinPoint.proceed();
            String className = joinPoint.getSignature().getDeclaringTypeName();
            String methodName = joinPoint.getSignature().getName();
            long executionTime = System.currentTimeMillis() - start;
            String logMessage = String.format("Method %s.%s execution time : %d ms", className, methodName, executionTime);
            log.debug(logMessage);
            return proceed;
        }
        Object proceed = joinPoint.proceed();
        return proceed;
    }

    public static LogExecutionTimeAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.adobe.guides.aspects.LogExecutionTimeAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

