/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fmdita.api.profiles;

import com.adobe.fmdita.api.Services;
import com.adobe.fmdita.api.exception.GuidesApiException;
import com.adobe.fmdita.common.ClosableResolver;
import com.adobe.fmdita.folderprofiles.FolderProfileService;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;

public class FolderProfileUtils {
    public static boolean addAttributeProfiles(List<String> attributeNames, List<String> values, List<String> labels, String profileName, Session session) throws GuidesApiException {
        block12: {
            ResourceResolverFactory resolverFactory = Services.getInstance().getResourceResolverFactory();
            Throwable throwable = null;
            Object var7_9 = null;
            ClosableResolver loggedInResolver = new ClosableResolver(resolverFactory, "fmdita-serviceuser");
            try {
                ResourceResolver fmditaResolver = loggedInResolver.getResolver();
                UserManager userManager = (UserManager)fmditaResolver.adaptTo(UserManager.class);
                FolderProfileService.addAttributeProfiles(attributeNames, values, labels, (String)profileName, (Session)session, (UserManager)userManager);
                if (loggedInResolver == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (loggedInResolver != null) {
                            loggedInResolver.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new GuidesApiException("Failed to add attribute to profiles ", e);
                }
            }
            loggedInResolver.close();
        }
        return true;
    }

    public List<Resource> getAllFolderProfileForDisplay(ResourceResolver resolver, int row, int offset) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        Iterable allFolders = resolver.getChildren(resolver.getResource("/var/dxml/folderprofiles"));
        for (Resource resource : allFolders) {
            if (!((String)resource.getValueMap().get("jcr:primaryType", String.class)).equals("sling:OrderedFolder") || resource.getValueMap().get("name", String.class) == null) continue;
            list.add(resource);
        }
        list.sort((o1, o2) -> ((String)o2.getValueMap().get("jcr:created", String.class)).compareTo((String)o1.getValueMap().get("jcr:created", String.class)));
        return list.subList(Math.min(list.size(), offset), Math.min(list.size(), offset + row));
    }
}

