/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.utils.GuideUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationUtils {
    public static final String TRANSLATION_TOKEN = "##";
    public static final String PN_TRANSLATION_IDS = "fd:translationIds";
    public static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(TranslationUtils.class);

    private TranslationUtils() {
    }

    public static String get(String path, String propertyOrObjectKey, Integer index, boolean isProperty, String originalKey) {
        StringBuilder builder = new StringBuilder();
        if (originalKey == null) {
            if (!StringUtils.isEmpty((CharSequence)path)) {
                builder.append(path);
                builder.append(TRANSLATION_TOKEN);
            }
            builder.append(propertyOrObjectKey);
            if (isProperty) {
                builder.append(TRANSLATION_TOKEN);
                int randomNum = (int)Math.floor(Math.random() * 10000.0) + 1;
                builder.append(randomNum);
            }
        } else {
            builder.append(originalKey);
        }
        if (index != null) {
            builder.append(TRANSLATION_TOKEN);
            builder.append(index);
        }
        return builder.toString();
    }

    public static String get(String path, String propertyOrObjectKey, Integer index, boolean isProperty) {
        return TranslationUtils.get(path, propertyOrObjectKey, index, isProperty, null);
    }

    public static String getDictionaryPath(ResourceResolver resourceResolver, String guideContainerPath) {
        String formDamPath = GuideUtils.convertGuideContainerPathToFMAssetPath(guideContainerPath);
        String oldDictionaryPath = guideContainerPath + "/" + "assets" + "/" + "dictionary";
        String newDictionaryPath = formDamPath + "/" + "jcr:content" + "/" + "dictionary";
        if (resourceResolver.getResource(oldDictionaryPath) != null) {
            return oldDictionaryPath;
        }
        return newDictionaryPath;
    }

    public static Node getOrAddDictionaryNode(ResourceResolver resolver, String containerPath) throws RepositoryException {
        Node assetsNode = null;
        Node dictionaryNode = null;
        Resource damResoure = resolver.getResource(GuideUtils.convertGuideContainerPathToFMAssetPath(containerPath));
        Resource damContentResource = null;
        Node containerNode = (Node)resolver.getResource(containerPath).adaptTo(Node.class);
        Session session = (Session)resolver.adaptTo(Session.class);
        if (damResoure != null) {
            damContentResource = damResoure.getChild("jcr:content");
        }
        if (containerNode.hasNode("assets")) {
            assetsNode = containerNode.getNode("assets");
        }
        if (assetsNode != null && assetsNode.hasNode("dictionary")) {
            dictionaryNode = assetsNode.getNode("dictionary");
        } else if (damContentResource != null) {
            Node damContentNode = (Node)damContentResource.adaptTo(Node.class);
            if (damContentNode.hasNode("dictionary")) {
                dictionaryNode = damContentNode.getNode("dictionary");
            } else {
                dictionaryNode = damContentNode.addNode("dictionary", "nt:unstructured");
                session.save();
            }
        }
        return dictionaryNode;
    }

    public static String getTranslationId(ValueMap properties, String propertyName, String propertyValue, boolean checkArray) throws IOException {
        ObjectMapper mapper;
        Map map;
        String currentTranslationIds = (String)properties.get(PN_TRANSLATION_IDS, String.class);
        String translationId = null;
        if (StringUtils.isNotBlank((CharSequence)currentTranslationIds) && (map = (Map)(mapper = new ObjectMapper()).readValue(currentTranslationIds, Map.class)).containsKey(propertyName)) {
            String[] list;
            String value;
            List<String> valueList;
            int index;
            translationId = map.get(propertyName).toString();
            Object obj = properties.get((Object)propertyName);
            if (obj != null && obj.getClass().isArray() && checkArray && (index = valueList.indexOf(value = (valueList = Arrays.asList(list = (String[])properties.get(propertyName, String[].class))).get(0).contains("=") ? propertyValue : propertyValue.split("=")[0])) != -1) {
                StringBuilder builder = new StringBuilder();
                builder.append(translationId);
                builder.append(TRANSLATION_TOKEN);
                builder.append(index);
                translationId = builder.toString();
            }
        }
        return translationId;
    }

    public static String getTranslationId(ValueMap properties, String propertyName, String propertyValue) throws IOException {
        return TranslationUtils.getTranslationId(properties, propertyName, propertyValue, true);
    }

    public static boolean isNewTranslation(ValueMap properties) {
        return StringUtils.isNotBlank((CharSequence)((CharSequence)properties.get(PN_TRANSLATION_IDS, String.class)));
    }

    public static boolean isNewTranslation(Resource resource) {
        return resource != null ? TranslationUtils.isNewTranslation(resource.getValueMap()) : false;
    }

    public static String getTranslationId(Resource resource, String propertyName, String propertyValue) throws IOException {
        return TranslationUtils.getTranslationId(resource.getValueMap(), propertyName, propertyValue);
    }

    public static String getTranslationId(Resource resource, String propertyName, String propertyValue, boolean checkArray) throws IOException {
        return TranslationUtils.getTranslationId(resource.getValueMap(), propertyName, propertyValue, checkArray);
    }

    public static void addPropertyToTranslationIds(Resource resource, String propertyName, String dictKeyForPropertyName) throws IOException, RepositoryException {
        if (!StringUtils.startsWith((CharSequence)dictKeyForPropertyName, (CharSequence)"fd_")) {
            String currentTranslationIds = (String)resource.getValueMap().get(PN_TRANSLATION_IDS, String.class);
            Map<String, String> map = null;
            if (StringUtils.isNotBlank((CharSequence)currentTranslationIds)) {
                ObjectMapper mapper = new ObjectMapper();
                map = (Map)mapper.readValue(currentTranslationIds, Map.class);
            } else {
                map = new HashMap<String, String>();
            }
            map.put(propertyName, dictKeyForPropertyName);
            ((Node)resource.adaptTo(Node.class)).setProperty(PN_TRANSLATION_IDS, mapper.writeValueAsString(map));
            resource.getResourceResolver().commit();
        }
    }

    public static void removePropertyFromTranslationIds(Resource resource, String propertyName) throws IOException, RepositoryException {
        ObjectMapper mapper;
        String currentTranslationIds = (String)resource.getValueMap().get(PN_TRANSLATION_IDS, String.class);
        Map map = null;
        if (StringUtils.isNotBlank((CharSequence)currentTranslationIds) && (map = (Map)(mapper = new ObjectMapper()).readValue(currentTranslationIds, Map.class)).containsKey(propertyName)) {
            map.remove(propertyName);
            ((Node)resource.adaptTo(Node.class)).setProperty(PN_TRANSLATION_IDS, mapper.writeValueAsString((Object)map));
            resource.getResourceResolver().commit();
        }
    }
}

