/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.common.GuideError;
import com.adobe.aemds.guide.common.GuideValidationError;
import com.adobe.aemds.guide.common.GuideValidationResult;
import com.adobe.aemds.guide.fdfl.utils.XMLUtils;
import com.adobe.aemds.guide.model.FormSubmitInfo;
import com.adobe.aemds.guide.service.external.PortalRecordInfo;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.GuideSubmitErrorCause;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.day.cq.i18n.I18n;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class GuideSubmitUtils {
    private static Logger logger = LoggerFactory.getLogger(GuideSubmitUtils.class);
    public static final String REQUEST_ATTR_PDF_NAME = "pdfName";
    public static final String REQUEST_ATTR_REDIRECT_PARAMETER_MAP = "redirectParameters";
    public static final String REQ_ATTR_FORWARD_PATH = "forward.path";
    public static final String REQ_ATTR_FORWARD_OPTIONS = "forward.options";
    public static final String REQ_ATTR_GUIDE_SUBMIT_OPTIONS = "submit.options";

    public static void setForwardPath(SlingHttpServletRequest req, String path, String selector, String suffix) {
        req.setAttribute(REQ_ATTR_FORWARD_PATH, (Object)path);
        if (selector != null || suffix != null) {
            RequestDispatcherOptions options = new RequestDispatcherOptions();
            if (selector != null) {
                options.setReplaceSelectors(selector);
            }
            if (suffix != null) {
                options.setReplaceSuffix(suffix);
            }
            req.setAttribute(REQ_ATTR_FORWARD_OPTIONS, (Object)options);
        }
    }

    public static void setRedirectUrl(SlingHttpServletRequest req, String redirectUrl) {
        req.setAttribute(":redirect", (Object)redirectUrl);
    }

    public static String getUserID(SlingHttpServletRequest request) {
        String userId = ((Session)request.getResourceResolver().adaptTo(Session.class)).getUserID();
        int index = userId.lastIndexOf(58);
        if (index > 0 && index + 1 < userId.length()) {
            userId = userId.substring(index + 1);
        }
        return userId;
    }

    public static Resource getParentResource(Resource resource, String jcrPrimaryType) {
        Resource parentResource = resource;
        String parentResourceType = null;
        if (resource == null) {
            return null;
        }
        if (jcrPrimaryType.isEmpty()) {
            return resource.getParent();
        }
        do {
            if ((parentResource = parentResource.getParent()) == null) continue;
            ValueMap properties = (ValueMap)parentResource.adaptTo(ValueMap.class);
            parentResourceType = (String)properties.get("jcr:primaryType", (Object)"");
        } while (!jcrPrimaryType.equals(parentResourceType));
        return parentResource;
    }

    public static Map<String, String> getRedirectParameters(HttpServletRequest request) {
        HashMap redirectParameters = (HashMap)request.getAttribute(REQUEST_ATTR_REDIRECT_PARAMETER_MAP);
        if (redirectParameters == null) {
            redirectParameters = new HashMap();
        }
        return redirectParameters;
    }

    private static void populateMap(JSONObject data, Map<String, String> map, String generatedKey, boolean keepHierarchy) throws JSONException {
        Iterator keys = data.keys();
        while (keys.hasNext()) {
            String key;
            String newKey = key = (String)keys.next();
            if (keepHierarchy && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)generatedKey)) {
                newKey = generatedKey + "/" + key;
            }
            if (data.get(key) instanceof JSONObject) {
                GuideSubmitUtils.populateMap((JSONObject)data.get(key), map, newKey, keepHierarchy);
                continue;
            }
            map.put(newKey, data.getString(key));
        }
    }

    public static String getNameOfCompositeFieldFromChildResource(@Nonnull Resource resource) {
        String name = null;
        Resource parent = resource.getParent();
        if (parent != null && StringUtils.equals((String)parent.getName(), (String)"items") && (parent = parent.getParent()) != null) {
            for (String compositeResourceType : GuideConstants.GUIDE_COMPOSITE_FIELD_RESOURCE_TYPES) {
                if (!parent.isResourceType(compositeResourceType)) continue;
                name = (String)parent.getValueMap().get("name", (Object)"");
                break;
            }
        }
        return name;
    }

    public static Map<String, String> getGuideValueMap(FormSubmitInfo formSubmitInfo) throws JSONException {
        return GuideSubmitUtils.getGuideValueMap(formSubmitInfo, false);
    }

    public static Map<String, String> getGuideValueMap(FormSubmitInfo formSubmitInfo, boolean retainBoundDataHierarchy) throws JSONException {
        PortalRecordInfo portalRecordInfo;
        HashMap<String, String> guideValueMap;
        String data = formSubmitInfo.getData();
        if ("application/json".equals(formSubmitInfo.getContentType())) {
            guideValueMap = new HashMap();
            try {
                JSONObject dataJson = new JSONObject(data);
                JSONObject afDataJson = dataJson.getJSONObject("afData");
                JSONObject unboundDataJson = afDataJson.getJSONObject("afUnboundData");
                JSONObject boundDataJson = afDataJson.getJSONObject("afBoundData");
                if (unboundDataJson != null) {
                    GuideSubmitUtils.populateMap(unboundDataJson, guideValueMap, "", false);
                }
                if (boundDataJson != null) {
                    GuideSubmitUtils.populateMap(boundDataJson, guideValueMap, "", retainBoundDataHierarchy);
                }
            }
            catch (JSONException e) {
                logger.error("Failed to retrieve data from submit data JSON.", (Throwable)e);
            }
        } else {
            Document document = XMLUtils.strToDoc((String)data);
            guideValueMap = XMLUtils.getDataMap((Document)document);
        }
        if ((portalRecordInfo = formSubmitInfo.getPortalRecordInfo()) != null) {
            if (StringUtils.isNotEmpty((String)portalRecordInfo.getSubmitID())) {
                guideValueMap.put("submitID", portalRecordInfo.getSubmitID());
            }
            if (StringUtils.isNotEmpty((String)portalRecordInfo.getSubmitLink())) {
                guideValueMap.put("submitLink", portalRecordInfo.getSubmitLink());
            }
        }
        return guideValueMap;
    }

    public static Map<String, String> getMappedFieldParameters(String[] fieldParameterMapping) {
        HashMap<String, String> mappedFieldParameters = new HashMap<String, String>();
        if (fieldParameterMapping != null) {
            for (String param : fieldParameterMapping) {
                String fieldName;
                String[] map = StringUtils.split((String)param, (String)"=");
                String mappedParam = fieldName = map[0].trim();
                if (map.length == 2) {
                    mappedParam = map[1].trim();
                }
                mappedFieldParameters.put(fieldName, mappedParam);
            }
        }
        return mappedFieldParameters;
    }

    public static void setRedirectParameters(HttpServletRequest request, Map<String, String> value) {
        request.setAttribute(REQUEST_ATTR_REDIRECT_PARAMETER_MAP, value);
    }

    public static String getReqAttrPdfName(HttpServletRequest request) {
        return (String)request.getAttribute(REQUEST_ATTR_PDF_NAME);
    }

    public static String addContextPath(String url, String contextPath) {
        if (StringUtils.isNotBlank((String)url)) {
            if (url.matches("^(https?)://.+")) {
                return url;
            }
            if (StringUtils.isNotBlank((String)contextPath) && !StringUtils.startsWith((String)url, (String)contextPath) && StringUtils.startsWith((String)url, (String)"/")) {
                url = contextPath + url;
            }
        }
        return url;
    }

    public static String addContextPathWithServerUrl(String url, String contextPath, String serverUrl) {
        return GuideSubmitUtils.addContextPath(url, serverUrl + contextPath);
    }

    public static void handleValidationError(HttpServletRequest request, HttpServletResponse response, Map<String, Object> submitResult) {
        if (response != null && submitResult != null && submitResult.containsKey("FormSubmissionError") && submitResult.get("FormSubmissionError") instanceof GuideValidationResult) {
            GuideValidationResult submitFailure = (GuideValidationResult)submitResult.get("FormSubmissionError");
            response.setStatus(500);
            request.setAttribute("FormSubmissionError", (Object)submitFailure);
        }
    }

    public static GuideValidationResult getDefaultGuideValidationResult() {
        return new GuideValidationResult(GuideSubmitErrorCause.FORM_SUBMISSION, "Error During Form Submission");
    }

    public static GuideValidationResult getGuideValidationResultFromString(String errorMessage, String status) {
        GuideValidationResult guideValidationResult = new GuideValidationResult(GuideSubmitErrorCause.FORM_SUBMISSION, status, errorMessage);
        try {
            JSONObject jsonObject = new JSONObject(errorMessage);
            GuideSubmitErrorCause errorCausedBy = null;
            String guideValidationErrorMessage = null;
            List errorList = null;
            if (jsonObject.has("errorCausedBy") && StringUtils.isNotEmpty((String)((String)jsonObject.get("errorCausedBy")))) {
                errorCausedBy = Enum.valueOf(GuideSubmitErrorCause.class, (String)jsonObject.get("errorCausedBy"));
            }
            if (jsonObject.has("errorMessage") && StringUtils.isNotEmpty((String)((String)jsonObject.get("errorMessage")))) {
                guideValidationErrorMessage = (String)jsonObject.get("errorMessage");
            }
            if (jsonObject.has("errors") && ((JSONArray)jsonObject.get("errors")).length() > 0) {
                String jsonArray = jsonObject.get("errors").toString();
                Gson gson = new Gson();
                Type type = new TypeToken<List<GuideError>>(){}.getType();
                errorList = (List)gson.fromJson(jsonArray, type);
            }
            if (errorCausedBy != null || errorList != null && !errorList.isEmpty()) {
                if (errorCausedBy == null) {
                    errorCausedBy = GuideSubmitErrorCause.FORM_SUBMISSION;
                }
                GuideValidationResult guideValidationResultParsed = new GuideValidationResult(errorCausedBy, guideValidationErrorMessage, errorList);
                String originMessage = null;
                String originCode = null;
                if (jsonObject.has("originMessage")) {
                    originMessage = (String)jsonObject.get("originMessage");
                }
                if (jsonObject.has("originCode")) {
                    originCode = (String)jsonObject.get("originCode");
                }
                guideValidationResultParsed.setOriginDetails(originCode, originMessage);
                guideValidationResult = guideValidationResultParsed;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return guideValidationResult;
    }

    public static GuideValidationResult getGuideValidationResultFromStringV2(String originMessage, String originCode, String originContentTypeHeader) {
        GuideValidationResult guideValidationResult;
        block12: {
            guideValidationResult = new GuideValidationResult(GuideSubmitErrorCause.FORM_SUBMISSION, originCode, originMessage);
            try {
                if ("application/problem+json".equals(originContentTypeHeader)) {
                    guideValidationResult.setOriginContentTypeHeader(originContentTypeHeader);
                    JSONObject jsonObject = new JSONObject(originMessage);
                    List errorList = null;
                    if (jsonObject.has("type") && StringUtils.isNotEmpty((String)((String)jsonObject.get("type")))) {
                        try {
                            GuideSubmitErrorCause errorCausedBy = Enum.valueOf(GuideSubmitErrorCause.class, (String)jsonObject.get("type"));
                            guideValidationResult.setErrorCausedBy(errorCausedBy);
                        }
                        catch (IllegalArgumentException errorCausedBy) {
                            // empty catch block
                        }
                    }
                    if (jsonObject.has("title") && StringUtils.isNotEmpty((String)((String)jsonObject.get("title")))) {
                        guideValidationResult.setErrorTitle((String)jsonObject.get("title"));
                    }
                    if (jsonObject.has("instance") && StringUtils.isNotEmpty((String)((String)jsonObject.get("instance")))) {
                        guideValidationResult.setErrorInstance((String)jsonObject.get("instance"));
                    }
                    if (jsonObject.has("detail") && StringUtils.isNotEmpty((String)((String)jsonObject.get("detail")))) {
                        guideValidationResult.setErrorDetail((String)jsonObject.get("detail"));
                    }
                    if (jsonObject.has("validationErrors") && ((JSONArray)jsonObject.get("validationErrors")).length() > 0) {
                        String jsonArray = jsonObject.get("validationErrors").toString();
                        Gson gson = new Gson();
                        Type type = new TypeToken<List<GuideValidationError>>(){}.getType();
                        errorList = (List)gson.fromJson(jsonArray, type);
                        guideValidationResult.setValidationErrors(errorList);
                    }
                    break block12;
                }
                guideValidationResult = GuideSubmitUtils.getGuideValidationResultFromString(originMessage, originCode);
                if (guideValidationResult.getOriginMessage() == null) {
                    guideValidationResult.setOriginMessage(originMessage);
                }
                if (guideValidationResult.getOriginCode() == null) {
                    guideValidationResult.setOriginCode(originCode);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return guideValidationResult;
    }

    public static void addValidationErrorToResult(Map<String, Object> result, GuideSubmitErrorCause errorCause, String errorMessage, String originCode) {
        GuideValidationResult guideValidationResult = new GuideValidationResult(errorCause, errorMessage);
        guideValidationResult.setOriginDetails(originCode, null);
        result.put("FormSubmissionError", guideValidationResult);
    }

    public static String getLocale(HttpServletRequest request) {
        String locale = request.getParameter("runtimeLocale");
        if (locale == null || locale.isEmpty()) {
            locale = "en";
        }
        return locale;
    }

    public static String prepareRedirectUrl(SlingHttpServletRequest request, String redirectUrl) throws UnsupportedEncodingException {
        redirectUrl = !redirectUrl.contains("?") ? redirectUrl + "?" : redirectUrl + "&";
        Map<String, String> redirectParameters = GuideSubmitUtils.getRedirectParameters((HttpServletRequest)request);
        if (!redirectParameters.isEmpty()) {
            StringBuilder redirectUrlBuilder = new StringBuilder(redirectUrl);
            for (Map.Entry<String, String> param : redirectParameters.entrySet()) {
                redirectUrlBuilder.append(URLEncoder.encode(param.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(param.getValue(), "UTF-8")).append("&");
            }
            redirectUrl = redirectUrlBuilder.toString();
        }
        if (redirectUrl.charAt(redirectUrl.length() - 1) == '&' || redirectUrl.charAt(redirectUrl.length() - 1) == '?') {
            redirectUrl = redirectUrl.substring(0, redirectUrl.length() - 1);
        }
        return redirectUrl;
    }

    public static Map<String, String> getAFSuccessPayload(SlingHttpServletRequest request, ValueMap formContainerResourceProperties, String redirectUrl) throws UnsupportedEncodingException {
        String thankYouContent;
        String thankYouOption;
        String defaultThankYouPageUrl = request.getParameter("guideContainerPath") + "." + "guideThankYouPage.html";
        String defaultThankYouMessage = I18n.get((HttpServletRequest)request, (String)"Thank you for submitting the form.");
        String locale = GuideSubmitUtils.getLocale((HttpServletRequest)request);
        HashMap<String, String> successPayload = new HashMap<String, String>();
        I18n i18n = new I18n(request.getResourceBundle(new Locale(locale)));
        if (redirectUrl == null) {
            redirectUrl = defaultThankYouPageUrl;
        }
        if (StringUtils.isBlank((String)(thankYouOption = (String)formContainerResourceProperties.get("thankYouOption", null)))) {
            thankYouOption = (String)formContainerResourceProperties.get("thankyouConfig", (Object)GuideConstants.ThankYouOption.PAGE.toString());
        }
        if (GuideConstants.ThankYouOption.PAGE.toString().equals(thankYouOption)) {
            thankYouContent = GuideSubmitUtils.addContextPath(redirectUrl, request.getContextPath());
            thankYouContent = GuideSubmitUtils.prepareRedirectUrl(request, thankYouContent);
        } else {
            thankYouContent = (String)formContainerResourceProperties.get("thankYouMessage", null);
            if (StringUtils.isBlank((String)thankYouContent)) {
                thankYouContent = (String)formContainerResourceProperties.get("thankyouMessage", (Object)defaultThankYouMessage);
            }
            thankYouContent = GuideUtils.translateOrReturnOriginal(thankYouContent, "thankYouMessage", i18n, formContainerResourceProperties);
        }
        successPayload.put("thankYouOption", thankYouOption);
        successPayload.put("thankYouContent", thankYouContent);
        return successPayload;
    }
}

