/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.service.external;

import com.adobe.aemds.guide.model.ReCaptchaConfigurationModel;
import com.adobe.aemds.guide.service.CloudConfigurationProvider;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.forms.foundation.fdinternal.utils.Constants;
import com.adobe.granite.toggle.api.ToggleCondition;
import java.util.HashMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={CloudConfigurationProvider.class}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_FORMS-8771)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class CloudConfigurationProviderImpl
implements CloudConfigurationProvider {
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private static Logger logger = LoggerFactory.getLogger(CloudConfigurationProvider.class);

    private ResourceResolver getCloudServiceUserResourceResolver(ResourceResolverFactory resourceResolverFactory) {
        ResourceResolver resourceResolver = null;
        if (resourceResolverFactory != null) {
            try {
                HashMap<String, String> authenticationInfo = new HashMap<String, String>();
                authenticationInfo.put("sling.service.subservice", "readCloudService");
                resourceResolver = resourceResolverFactory.getServiceResourceResolver(authenticationInfo);
            }
            catch (LoginException e) {
                logger.error("[AF][Captcha] Cannot provide service resource resolver", (Throwable)e);
            }
        }
        return resourceResolver;
    }

    private String getInheritedProperty(Resource resource, String property) {
        while (resource != null) {
            String confPath = null;
            ValueMap valueMap = resource.getValueMap();
            if ("cq:Page".equals(valueMap.get("jcr:primaryType", String.class)) && resource.getChild("jcr:content") != null) {
                valueMap = resource.getChild("jcr:content").getValueMap();
            }
            if (valueMap != null && "cq:PageContent".equals(valueMap.get("jcr:primaryType", String.class))) {
                confPath = (String)valueMap.get(property, String.class);
            }
            if (confPath != null) {
                return confPath;
            }
            resource = resource.getParent();
        }
        return null;
    }

    @Override
    public ReCaptchaConfigurationModel getRecaptchaCloudConfiguration(Resource resource) throws GuideException {
        ResourceResolver resourceResolver = null;
        ReCaptchaConfigurationModel recaptchaConfiguration = null;
        if (resource != null) {
            try {
                Resource recaptchaConfigurationResource;
                String rootPath = this.getInheritedProperty(resource, Constants.PN_CONF_REF);
                if (rootPath == null) {
                    rootPath = this.getInheritedProperty(resource, "sling:configRef");
                }
                String recaptchaCloudConfigPath = (String)resource.getValueMap().get("rcCloudServicePath", String.class);
                String configName = rootPath + "/settings/cloudconfigs/recaptcha" + "/" + recaptchaCloudConfigPath + "/" + "jcr:content";
                resourceResolver = this.getCloudServiceUserResourceResolver(this.resourceResolverFactory);
                if (resourceResolver != null && (recaptchaConfigurationResource = resourceResolver.getResource(configName)) != null) {
                    recaptchaConfiguration = (ReCaptchaConfigurationModel)recaptchaConfigurationResource.adaptTo(ReCaptchaConfigurationModel.class);
                }
            }
            catch (Exception e) {
                logger.error("[AF][Captcha] not able to get config from rootpath of resource" + e.getMessage());
                throw new GuideException(e);
            }
            finally {
                resourceResolver.close();
            }
        }
        return recaptchaConfiguration;
    }
}

