/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.model;

import com.adobe.aem.adobesign.recipient.RecipientSetInfo;
import com.adobe.aemds.guide.model.SignField;
import com.adobe.aemds.guide.model.SignerInfoSource;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;

@Model(adaptables={Resource.class})
public class SignerInfo {
    @Inject
    private String emailSource;
    @Inject
    @Optional
    private String email;
    @Inject
    @Named(value=".")
    private List<SignField> signFields;
    @Inject
    private String securityOption;
    @Inject
    @Optional
    private String countryCodeSource;
    @Inject
    @Optional
    private String countryCode;
    @Inject
    @Optional
    private String phoneSource;
    @Inject
    @Optional
    private String phone;
    @Inject
    @Optional
    private String recipientRole;
    @Inject
    @Optional
    private String delegateTo;

    public SignerInfoSource getEmailSource() {
        return SignerInfoSource.get(this.emailSource);
    }

    public String getEmail() {
        return this.email;
    }

    public List<SignField> getSignFields() {
        return this.signFields;
    }

    public SignerInfoSource getCountryCodeSource() {
        return SignerInfoSource.get(this.countryCodeSource);
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public SignerInfoSource getPhoneSource() {
        return SignerInfoSource.get(this.phoneSource);
    }

    public String getPhone() {
        return this.phone;
    }

    public String getSecurityOption() {
        return this.securityOption;
    }

    public void setEmailSource(String emailSource) {
        this.emailSource = emailSource;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setSignFields(List<SignField> signFields) {
        this.signFields = signFields;
    }

    public void setSecurityOption(String securityOption) {
        this.securityOption = securityOption;
    }

    public void setCountryCodeSource(String countryCodeSource) {
        this.countryCodeSource = countryCodeSource;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setPhoneSource(String phoneSource) {
        this.phoneSource = phoneSource;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public RecipientSetInfo.RecipientRole getRecipientRole() {
        RecipientSetInfo.RecipientRole recipientRoleEnum = null;
        String recipientRole = this.recipientRole;
        if ("DELEGATE_TO_".equals(recipientRole)) {
            if (StringUtils.isEmpty((CharSequence)this.delegateTo)) {
                this.delegateTo = "SIGNER";
            }
            recipientRole = recipientRole + this.delegateTo;
        }
        try {
            recipientRoleEnum = RecipientSetInfo.RecipientRole.valueOf(recipientRole);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (recipientRoleEnum == null) {
            recipientRoleEnum = RecipientSetInfo.RecipientRole.SIGNER;
        }
        return recipientRoleEnum;
    }

    public void setRecipientRole(String recipientRole) {
        this.recipientRole = recipientRole;
    }
}

