/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.util;

import com.adobe.aem.dermis.api.converter.ConverterService;
import com.adobe.aem.dermis.api.util.DermisUtils;
import com.adobe.aem.dermis.api.util.JsonUtils;
import com.adobe.aem.dermis.exception.DermisException;
import com.adobe.aem.dermis.model.DataModel;
import com.adobe.aem.dermis.model.IDataModel;
import com.adobe.aem.dermis.model.IProperty;
import com.adobe.aem.dermis.model.JSONRenderer;
import com.adobe.aem.dermis.model.Property;
import com.adobe.aem.dermis.model.PropertyFormatType;
import com.adobe.aem.dermis.model.PropertyType;
import com.adobe.aem.dermis.model.value.CustomDate;
import com.adobe.aem.dermis.model.value.ITypeValue;
import com.adobe.aem.dermis.model.value.IValue;
import com.adobe.aem.dermis.model.value.IValueList;
import com.adobe.aem.dermis.model.value.IValueMap;
import com.adobe.aem.dermis.model.value.TypeValue;
import com.adobe.aem.dermis.model.value.ValueList;
import com.adobe.aem.dermis.model.value.ValueMap;
import com.adobe.aem.dermis.provider.ToggleRouterProvider;
import com.adobe.aemfd.dermis.authentication.exception.DermisLogger;
import com.adobe.granite.toggle.api.ToggleRouter;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueUtil {
    private static JSONRenderer renderer = new JSONRenderer();
    private static final Logger logger = LoggerFactory.getLogger(ValueUtil.class);

    public static IValue generateValue(IProperty property, Object data, boolean autoCoerce) throws DermisException {
        return ValueUtil.generateValue(property, data, autoCoerce, true);
    }

    public static IValue generateValue(IProperty property, Object data, List<? extends IDataModel> datamodels, boolean autoCoerce) throws DermisException {
        return ValueUtil.generateValue(property, data, datamodels, autoCoerce, true);
    }

    public static IValue generateValue(IProperty property, Object data, boolean autoCoerce, boolean generateNullForPropsNotInData) throws DermisException {
        return ValueUtil.generateValue(property, data, autoCoerce, generateNullForPropsNotInData, false);
    }

    public static IValue generateValue(IProperty property, Object data, List<? extends IDataModel> dataModels, boolean autoCoerce, boolean generateNullForPropsNotInData) throws DermisException {
        return ValueUtil.generateValue(property, data, dataModels, autoCoerce, generateNullForPropsNotInData, false);
    }

    public static IValue generateValue(IProperty property, Object data, boolean autoCoerce, boolean generateNullForPropsNotInData, boolean removeComputedAttributes) throws DermisException {
        return ValueUtil.generateValue(property, data, null, autoCoerce, generateNullForPropsNotInData, removeComputedAttributes);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IValue generateValue(IProperty property, Object data2222, List<? extends IDataModel> dataModels, boolean autoCoerce, boolean generateNullForPropsNotInData, boolean removeComputedAttributes) throws DermisException {
        List<Object> data2222;
        void var6_14;
        Object var6_10 = null;
        if (property == null) return var6_14;
        if (data2222 == null) return var6_14;
        PropertyType type = property.getType();
        PropertyType subType = property.getSubType();
        PropertyFormatType formatType = property.getFormatType();
        if (PropertyType.ARRAY == type) {
            void data2222;
            List dataList;
            Class subTypeClass = DermisUtils.getJavaClassForTypeAndFormat((PropertyType)subType, (PropertyFormatType)formatType);
            if (subTypeClass.isInstance(data2222) && !(data2222 instanceof List)) {
                dataList = new ArrayList();
                dataList.add(data2222);
                List data2222 = dataList;
            }
            if (!(data2222 instanceof List)) throw new DermisException("Excepted list data in case of property type array");
            IValueList iValueList = ValueList.of(null);
            dataList = (List)data2222;
            Iterator iterator = dataList.iterator();
            boolean isObjectType = PropertyType.OBJECT == subType;
            Property prop = new Property(property.getName(), property.getSubType(), null);
            while (iterator.hasNext()) {
                IValue childValue;
                Object nextObject = iterator.next();
                if (isObjectType) {
                    IDataModel dataModel = DermisUtils.resolveType((List)dataModels, (Map)((Map)nextObject));
                    if (dataModel == null) {
                        IDataModel refDatamodel = DermisUtils.getRefDatamodel((List)dataModels, (IProperty)property);
                        dataModel = refDatamodel != null ? refDatamodel : property.getChildDataModel();
                    }
                    childValue = ValueUtil.generateValue(dataModel, (Map)nextObject, (List<? extends IDataModel>)dataModels, (boolean)autoCoerce, (boolean)generateNullForPropsNotInData, (boolean)removeComputedAttributes);
                } else {
                    prop.setFormatType(property.getFormatType());
                    childValue = ValueUtil.generateValue(prop, nextObject, (List<? extends IDataModel>)dataModels, (boolean)autoCoerce, (boolean)generateNullForPropsNotInData, (boolean)removeComputedAttributes);
                }
                iValueList.add(childValue);
            }
            return var6_14;
        } else if (PropertyType.OBJECT == type) {
            if (!(data2222 instanceof Map)) throw new DermisException("Excepted map data in case of property type object");
            IDataModel dataModel = DermisUtils.resolveType((List)dataModels, (Map)((Map)((Object)data2222)));
            if (dataModel == null) {
                IDataModel refDatamodel = DermisUtils.getRefDatamodel((List)dataModels, (IProperty)property);
                if (refDatamodel != null) {
                    dataModel = refDatamodel;
                } else {
                    dataModel = new DataModel();
                    ((DataModel)dataModel).addProperties(property.getProperties());
                }
            }
            IValueMap iValueMap = ValueUtil.generateValue(dataModel, (Map)((Object)data2222), (List<? extends IDataModel>)dataModels, (boolean)autoCoerce, (boolean)generateNullForPropsNotInData, (boolean)removeComputedAttributes);
            return var6_14;
        } else {
            void data2222;
            if (autoCoerce != false && data2222 != null) {
                Object actualData = data2222;
                if (data2222 instanceof ITypeValue) {
                    actualData = ((ITypeValue)((Object)data2222)).get();
                }
                ConverterService converterService = ConverterService.getInstance();
                Object data2222 = converterService.convert(actualData, DermisUtils.getJavaClassForTypeAndFormat((PropertyType)type, (PropertyFormatType)formatType));
            }
            TypeValue typeValue = TypeValue.of(type, formatType, data2222);
        }
        return var6_14;
    }

    public static IValueMap generateValue(IDataModel dataModel, Map<String, Object> data, boolean autoCoerce) throws DermisException {
        return ValueUtil.generateValue(dataModel, data, autoCoerce, true);
    }

    public static IValueMap generateValue(IDataModel dataModel, Map<String, Object> data, List<? extends IDataModel> datamodels, boolean autoCoerce) throws DermisException {
        return ValueUtil.generateValue(dataModel, data, datamodels, autoCoerce, true);
    }

    public static IValueMap generateValue(IDataModel dataModel, Map<String, Object> data, boolean autoCoerce, boolean generateNullForPropsNotInData) throws DermisException {
        return ValueUtil.generateValue(dataModel, data, autoCoerce, generateNullForPropsNotInData, false);
    }

    public static IValueMap generateValue(IDataModel dataModel, Map<String, Object> data, List<? extends IDataModel> datamodels, boolean autoCoerce, boolean generateNullForPropsNotInData) throws DermisException {
        return ValueUtil.generateValue(dataModel, data, datamodels, autoCoerce, generateNullForPropsNotInData, false);
    }

    public static IValueMap generateValue(IDataModel dataModel, Map<String, Object> data, boolean autoCoerce, boolean generateNullForPropsNotInData, boolean removeComputedAttributes) throws DermisException {
        return ValueUtil.generateValue(dataModel, data, null, autoCoerce, generateNullForPropsNotInData, removeComputedAttributes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IValueMap generateValue(IDataModel dataModel, Map<String, Object> data, List<? extends IDataModel> datamodels, boolean autoCoerce, boolean generateNullForPropsNotInData, boolean removeComputedAttributes) throws DermisException {
        IValueMap value = ValueMap.of(null);
        IValue childValue = null;
        if (data != null & dataModel != null && dataModel.getProperties() != null && dataModel.getProperties().size() > 0) {
            if (data.containsKey("_fdm_additionalData")) {
                IValueMap additionalData = ValueMap.of(null);
                Map fdmAdditionalData = (Map)data.get("_fdm_additionalData");
                if (fdmAdditionalData != null && fdmAdditionalData.size() > 0) {
                    Iterator iterator = fdmAdditionalData.keySet().iterator();
                    String key = null;
                    Property property = null;
                    while (iterator.hasNext()) {
                        key = (String)iterator.next();
                        if (key.equals("_attributes")) {
                            if (fdmAdditionalData.get("_attributes") instanceof ValueMap) {
                                IValueMap attributeMap = ValueMap.of((ValueMap)fdmAdditionalData.get("_attributes"));
                                additionalData.put(key, attributeMap);
                                continue;
                            }
                            if (fdmAdditionalData.get("_attributes") instanceof HashMap) {
                                IValueMap attributeData = ValueMap.of(null);
                                Map attributeMap = (Map)fdmAdditionalData.get("_attributes");
                                for (Map.Entry attribute : attributeMap.entrySet()) {
                                    if (attribute.getValue() instanceof String) {
                                        attributeData.put((String)attribute.getKey(), TypeValue.of(PropertyType.STRING, null, attribute.getValue()));
                                    } else if (attribute.getValue() instanceof HashMap) {
                                        IValueMap innerAttributeMap = ValueMap.of(null);
                                        Map innerAttributeData = (Map)((Map)fdmAdditionalData.get("_attributes")).get(attribute.getKey());
                                        for (Map.Entry innerAttribute : innerAttributeData.entrySet()) {
                                            if (!(innerAttribute.getValue() instanceof String)) continue;
                                            innerAttributeMap.put((String)innerAttribute.getKey(), TypeValue.of(PropertyType.STRING, null, innerAttribute.getValue()));
                                        }
                                        attributeData.put((String)attribute.getKey(), innerAttributeMap);
                                    }
                                    additionalData.put(key, attributeData);
                                }
                                continue;
                            }
                            DermisLogger.logErrorAndDebug(ValueUtil.class, "Attribute instance not defined", fdmAdditionalData.get("_attributes").getClass().toString());
                            continue;
                        }
                        property = new Property(key, null, PropertyType.STRING);
                        childValue = ValueUtil.generateValue(property, fdmAdditionalData.get(property.getName()), autoCoerce);
                        additionalData.put(key, childValue);
                    }
                    value.put("_fdm_additionalData", additionalData);
                }
            }
            List<? extends IProperty> properties = dataModel.getProperties();
            for (IProperty iProperty : properties) {
                boolean openApi3FtEnabled;
                if (iProperty == null) continue;
                ToggleRouter toggleRouter = ToggleRouterProvider.getInstance();
                boolean bl = openApi3FtEnabled = toggleRouter != null ? toggleRouter.isEnabled("FT_CQ-4343082") : false;
                if (openApi3FtEnabled && iProperty.isFreeForm() != null && iProperty.isFreeForm().booleanValue()) {
                    value = ValueUtil.handleFreeFormObject(iProperty, data, value);
                    continue;
                }
                if (iProperty.isComputed() && removeComputedAttributes || !data.containsKey(iProperty.getName()) && !generateNullForPropsNotInData) continue;
                childValue = ValueUtil.generateValue(iProperty, data.get(iProperty.getName()), datamodels, autoCoerce, generateNullForPropsNotInData);
                value.put(iProperty.getName(), childValue);
            }
            return value;
        }
        if (data == null || dataModel == null || !data.containsKey("_fdm_additionalData")) return value;
        try {
            if (!((Map)data.get("_fdm_additionalData")).containsKey("_attributes")) return value;
            IValueMap additionalData = ValueMap.of(null);
            Map fdmAdditionalData = (Map)data.get("_fdm_additionalData");
            if (fdmAdditionalData == null || fdmAdditionalData.size() <= 0) return value;
            if (fdmAdditionalData.get("_attributes") instanceof ValueMap) {
                IValueMap iValueMap = ValueMap.of((ValueMap)fdmAdditionalData.get("_attributes"));
                additionalData.put("_attributes", iValueMap);
            } else if (fdmAdditionalData.get("_attributes") instanceof HashMap) {
                IValueMap iValueMap = ValueMap.of(null);
                Map attributeMap = (Map)fdmAdditionalData.get("_attributes");
                for (Map.Entry attribute : attributeMap.entrySet()) {
                    if (!(attribute.getValue() instanceof String)) continue;
                    iValueMap.put((String)attribute.getKey(), TypeValue.of(PropertyType.STRING, null, attribute.getValue()));
                }
                additionalData.put("_attributes", iValueMap);
            } else {
                DermisLogger.logErrorAndDebug(ValueUtil.class, "Attribute instance not defined for empty elements", fdmAdditionalData.get("_attributes").getClass().toString());
            }
            value.put("_fdm_additionalData", additionalData);
            return value;
        }
        catch (Exception e) {
            logger.error("error occurred while adding attributes for elements which does not have values : " + e.getStackTrace());
        }
        return value;
    }

    public static IValue jsonToValue(String jsonString, IProperty property) throws DermisException, JSONException {
        IValue value = null;
        if (StringUtils.isNotEmpty((String)jsonString)) {
            Object json = new JSONTokener(jsonString).nextValue();
            if (json instanceof JSONArray) {
                value = ValueUtil.jsonListToValue((JSONArray)json);
            } else if (json instanceof JSONObject) {
                value = ValueUtil.jsonObjectToValue((JSONObject)json);
            } else if (property.isPrimitiveType()) {
                value = TypeValue.of(property.getType(), property.getFormatType(), json);
            } else {
                DermisLogger.logErrorAndDebug(ValueUtil.class, "Unexpected value found for property " + property.getName(), "Unexpected value " + value + " found for property " + property.getName());
            }
        }
        return value;
    }

    public static IValue jsonToValue(Object data) throws DermisException, JSONException {
        IValue value = null;
        if (data != null && data != JSONObject.NULL) {
            if (data instanceof JSONArray) {
                value = ValueUtil.jsonListToValue((JSONArray)data);
            } else if (data instanceof JSONObject) {
                value = ValueUtil.jsonObjectToValue((JSONObject)data);
            } else {
                PropertyType propertyType = PropertyType.getPropertyType(data.getClass());
                PropertyFormatType formatType = PropertyFormatType.getFormatType(data.getClass());
                value = TypeValue.of(propertyType, formatType, data);
            }
        }
        return value;
    }

    public static IValueMap jsonObjectToValue(JSONObject data) throws DermisException, JSONException {
        IValueMap valueMap = ValueMap.of(null);
        if (data != null && data != JSONObject.NULL) {
            Iterator keysItr = data.keys();
            IValue childValue = null;
            while (keysItr.hasNext()) {
                String key = (String)keysItr.next();
                Object childData = JsonUtils.getValue((JSONObject)data, (String)key);
                childValue = ValueUtil.jsonToValue(childData);
                valueMap.put(key, childValue);
            }
        }
        return valueMap;
    }

    public static IValueList jsonListToValue(JSONArray array) throws DermisException, JSONException {
        IValueList valueList = ValueList.of(null);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                Object data = array.get(i);
                IValue childValue = ValueUtil.jsonToValue(data);
                valueList.add(childValue);
            }
        }
        return valueList;
    }

    public static Object getFormattedValue(Object value) {
        Object result = value;
        if (value != null) {
            Object actualValue = value;
            if (value instanceof ITypeValue) {
                result = actualValue = ((ITypeValue)value).get();
            }
            if (actualValue instanceof CustomDate) {
                result = actualValue.toString();
            } else if (actualValue instanceof Date) {
                result = ISO8601Utils.format((Date)((Date)actualValue), (boolean)true);
            } else if (actualValue instanceof byte[]) {
                result = Base64.encodeBase64String((byte[])((byte[])actualValue));
            } else if (value instanceof JSONObject) {
                result = renderer.toString((JSONObject)value);
            } else if (value instanceof JSONArray) {
                result = renderer.toString((JSONArray)value);
            } else if (value instanceof IValueMap || value instanceof IValueList) {
                try {
                    Object json = JsonUtils.getJSON((IValue)((IValue)value));
                    result = ValueUtil.getFormattedValue(json);
                }
                catch (DermisException e) {
                    DermisLogger.logErrorAndDebug(ValueUtil.class, "Unexpected exception occurred while converting IValue to JSON", e);
                }
            }
        }
        return result;
    }

    public static IValue getValue(IValueMap valueMap, String name) {
        IValue result = null;
        if (valueMap != null && valueMap.containsKey(name)) {
            result = valueMap.get(name);
        }
        return result;
    }

    private static IValueMap handleFreeFormObject(IProperty property, Map<String, Object> data, IValueMap value) {
        try {
            Object propertyValue = data.get(property.getName());
            if (propertyValue != null && propertyValue instanceof IValue) {
                value.put(property.getName(), (IValue)propertyValue);
            } else if (propertyValue != null && propertyValue instanceof Map) {
                value.put(property.getName(), ValueUtil.jsonToValue(new JSONObject(propertyValue.toString())));
            } else if (propertyValue == null && data instanceof Map) {
                value = (IValueMap)ValueUtil.jsonToValue(new JSONObject(data.toString()));
            }
            return value;
        }
        catch (Exception e) {
            logger.error("exception while transforming free form object : ", (Throwable)e);
            return null;
        }
    }
}

