/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.synthetic.impl;

import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowModel;
import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowRunner;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticMetaDataMap;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkItem;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflow;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflowData;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflowModelImpl;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflowSession;
import com.adobe.acs.commons.workflow.synthetic.impl.exceptions.SyntheticCompleteWorkflowException;
import com.adobe.acs.commons.workflow.synthetic.impl.exceptions.SyntheticRestartWorkflowException;
import com.adobe.acs.commons.workflow.synthetic.impl.exceptions.SyntheticTerminateWorkflowException;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Reference(name="workflowProcesses", referenceInterface=WorkflowProcess.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE)
@Service(value={SyntheticWorkflowRunner.class})
public class SyntheticWorkflowRunnerImpl
implements SyntheticWorkflowRunner {
    private static final Logger log = LoggerFactory.getLogger(SyntheticWorkflowRunnerImpl.class);
    private static final String UNSUPPORTED_OPERATION_MESSAGE = "Operation not supported by Synthetic Workflow";
    private static final String WORKFLOW_PROCESS_LABEL = "process.label";
    private static final int MAX_RESTART_COUNT = 3;
    private Map<String, WorkflowProcess> workflowProcessesByLabel = new ConcurrentHashMap<String, WorkflowProcess>();
    private Map<String, WorkflowProcess> workflowProcessesByProcessName = new ConcurrentHashMap<String, WorkflowProcess>();
    @Reference
    private WorkflowService aemWorkflowService;

    @Override
    public final void execute(ResourceResolver resourceResolver, String payloadPath, String[] workflowProcessLabels) throws WorkflowException {
        this.execute(resourceResolver, payloadPath, workflowProcessLabels, null, false, false);
    }

    @Override
    public final void execute(ResourceResolver resourceResolver, String payloadPath, String[] workflowProcessLabels, Map<String, Map<String, Object>> processArgs, boolean autoSaveAfterEachWorkflowProcess, boolean autoSaveAtEnd) throws WorkflowException {
        this.execute(resourceResolver, payloadPath, SyntheticWorkflowRunner.WorkflowProcessIdType.PROCESS_LABEL, workflowProcessLabels, processArgs, autoSaveAfterEachWorkflowProcess, autoSaveAtEnd);
    }

    @Override
    public final void execute(ResourceResolver resourceResolver, String payloadPath, SyntheticWorkflowRunner.WorkflowProcessIdType workflowProcessIdType, String[] workflowProcessIds, Map<String, Map<String, Object>> processArgs, boolean autoSaveAfterEachWorkflowProcess, boolean autoSaveAtEnd) throws WorkflowException {
        long start = System.currentTimeMillis();
        if (processArgs == null) {
            processArgs = new HashMap<String, Map<String, Object>>();
        }
        int count = 0;
        while (true) {
            ++count;
            try {
                this.run(resourceResolver, payloadPath, workflowProcessIdType, workflowProcessIds, processArgs, autoSaveAfterEachWorkflowProcess, autoSaveAtEnd);
                if (log.isInfoEnabled()) {
                    long duration = System.currentTimeMillis() - start;
                    log.info("Synthetic workflow execution of payload [ {} ] completed in [ {} ] ms", (Object)payloadPath, (Object)duration);
                }
                return;
            }
            catch (SyntheticRestartWorkflowException ex) {
                if (count < 3) {
                    log.info("Restarting synthetic workflow for [ {} ]", (Object)payloadPath);
                    continue;
                }
                log.warn("Synthetic workflow execution of payload [ {} ] reached max restart rate of [ {} ]", (Object)payloadPath, (Object)count);
                if (count < 3) continue;
                return;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(ResourceResolver resourceResolver, String payloadPath, SyntheticWorkflowRunner.WorkflowProcessIdType workflowProcessIdType, String[] workflowProcessIds, Map<String, Map<String, Object>> metaDataMaps, boolean autoSaveAfterEachWorkflowProcess, boolean autoSaveAtEnd) throws WorkflowException {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        WorkflowSession workflowSession = this.getWorkflowSession(session);
        SyntheticWorkflowData workflowData = new SyntheticWorkflowData("JCR_PATH", payloadPath);
        SyntheticWorkflow workflow = new SyntheticWorkflow("Synthetic Workflow ( " + payloadPath + " )", workflowData);
        boolean terminated = false;
        for (String workflowProcessId : workflowProcessIds) {
            WorkflowProcess workflowProcess = SyntheticWorkflowRunner.WorkflowProcessIdType.PROCESS_LABEL.equals((Object)workflowProcessIdType) ? this.workflowProcessesByLabel.get(workflowProcessId) : this.workflowProcessesByProcessName.get(workflowProcessId);
            if (workflowProcess != null) {
                SyntheticWorkItem workItem = new SyntheticWorkItem(workflowData);
                workItem.setWorkflow(workflow);
                SyntheticMetaDataMap workflowProcessMetaDataMap = new SyntheticMetaDataMap(metaDataMaps.get(workflowProcessId));
                long start = System.currentTimeMillis();
                log.trace("Executing synthetic workflow process [ {} ] on [ {} ]", (Object)workflowProcessId, (Object)payloadPath);
                try {
                    workflowProcess.execute((WorkItem)workItem, workflowSession, (MetaDataMap)workflowProcessMetaDataMap);
                    workItem.setTimeEnded(new Date());
                    continue;
                }
                catch (SyntheticCompleteWorkflowException ex) {
                    workItem.setTimeEnded(new Date());
                    log.trace(ex.getMessage());
                    continue;
                }
                catch (SyntheticTerminateWorkflowException ex) {
                    terminated = true;
                    log.info("Synthetic workflow execution stopped via terminate for [ {} ]", (Object)payloadPath);
                    break;
                }
                finally {
                    try {
                        if (!terminated && autoSaveAfterEachWorkflowProcess && session.hasPendingChanges()) {
                            session.save();
                        }
                        log.debug("Executed synthetic workflow process [ {} ] on [ {} ] in [ " + String.valueOf(System.currentTimeMillis() - start) + " ] ms", (Object)workflowProcessId, (Object)payloadPath);
                    }
                    catch (RepositoryException e) {
                        log.error("Could not save at end of synthetic workflow process execution [ {} ] for payload path [ {} ]", (Object)workflowProcessId, (Object)payloadPath);
                        log.error("Synthetic workflow process save failed.", (Throwable)e);
                        throw new WorkflowException((Throwable)e);
                    }
                }
            }
            log.error("Synthetic workflow runner retrieved a null Workflow Process for process.label [ {} ]", (Object)workflowProcessId);
        }
        try {
            if (autoSaveAtEnd && session.hasPendingChanges()) {
                session.save();
            }
        }
        catch (RepositoryException e) {
            log.error("Could not complete save at end of synthetic workflow execution process [ {} ]", (Object)payloadPath, (Object)e);
            throw new WorkflowException((Throwable)e);
        }
    }

    @Override
    public final void execute(ResourceResolver resourceResolver, String payloadPath, SyntheticWorkflowModel syntheticWorkflowModel, boolean autoSaveAfterEachWorkflowProcess, boolean autoSaveAtEnd) throws WorkflowException {
        String[] processNames = syntheticWorkflowModel.getWorkflowProcessNames();
        Map<String, Map<String, Object>> processConfigs = syntheticWorkflowModel.getSyntheticWorkflowModelData();
        this.execute(resourceResolver, payloadPath, SyntheticWorkflowRunner.WorkflowProcessIdType.PROCESS_NAME, processNames, processConfigs, autoSaveAfterEachWorkflowProcess, autoSaveAtEnd);
    }

    @Override
    public final SyntheticWorkflowModel getSyntheticWorkflowModel(ResourceResolver resourceResolver, String workflowModelId, boolean ignoreIncompatibleTypes) throws WorkflowException {
        WorkflowSession workflowSession = this.getWorkflowSession((Session)resourceResolver.adaptTo(Session.class));
        return new SyntheticWorkflowModelImpl(workflowSession, workflowModelId, ignoreIncompatibleTypes);
    }

    public final void start() throws WorkflowException {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    public final void stop() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    public final WorkflowSession getWorkflowSession(Session session) {
        return new SyntheticWorkflowSession(this, session);
    }

    public final WorkflowService getAEMWorkflowService() {
        return this.aemWorkflowService;
    }

    @Deprecated
    public final Dictionary<String, Object> getConfig() {
        return new Hashtable<String, Object>();
    }

    @Deactivate
    protected final void deactivate(Map<String, Object> config) {
        log.trace("Deactivating Synthetic Workflow Runner");
        this.workflowProcessesByLabel = new ConcurrentHashMap<String, WorkflowProcess>();
    }

    protected final void bindWorkflowProcesses(WorkflowProcess service, Map<Object, Object> props) {
        String processName;
        String label = PropertiesUtil.toString((Object)props.get(WORKFLOW_PROCESS_LABEL), null);
        if (label != null) {
            this.workflowProcessesByLabel.put(label, service);
            log.trace("Synthetic Workflow Runner added Workflow Process by Label [ {} ]", (Object)label);
        }
        if (service != null && (processName = service.getClass().getCanonicalName()) != null) {
            this.workflowProcessesByProcessName.put(processName, service);
            log.trace("Synthetic Workflow Runner added Workflow Process by Process Name [ {} ]", (Object)processName);
        }
    }

    protected final void unbindWorkflowProcesses(WorkflowProcess service, Map<Object, Object> props) {
        String processName;
        String label = PropertiesUtil.toString((Object)props.get(WORKFLOW_PROCESS_LABEL), null);
        if (label != null) {
            this.workflowProcessesByLabel.remove(label);
            log.trace("Synthetic Workflow Runner removed Workflow Process by Label [ {} ]", (Object)label);
        }
        if (service != null && (processName = service.getClass().getCanonicalName()) != null) {
            this.workflowProcessesByProcessName.remove(processName);
            log.trace("Synthetic Workflow Runner removed Workflow Process by Process Name [ {} ]", (Object)processName);
        }
    }

    protected void bindAemWorkflowService(WorkflowService workflowService) {
        this.aemWorkflowService = workflowService;
    }

    protected void unbindAemWorkflowService(WorkflowService workflowService) {
        if (this.aemWorkflowService == workflowService) {
            this.aemWorkflowService = null;
        }
    }
}

