/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;

@Component
@Service
@Properties(value={@Property(name="felix.webconsole.label", value={"wcm-inbox"}), @Property(name="felix.webconsole.title", value={"WCM Inbox"})})
public class WCMInboxWebConsolePlugin
extends HttpServlet {
    @Reference
    private ResourceResolverFactory rrFactory;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        Date yesterday = cal.getTime();
        PrintWriter pw = resp.getWriter();
        ResourceResolver resolver = null;
        try {
            resolver = this.rrFactory.getAdministrativeResourceResolver(null);
            pw.println("<p class='statline ui-state-highlight'>Inbox Notification Configurations</p>");
            pw.println("<ul>");
            Iterator configured = resolver.findResources("/jcr:root//element(*, rep:User)/wcm/notification/config/subscriptions/element(*)[@channel='inbox']", "xpath");
            while (configured.hasNext()) {
                String path = ((Resource)configured.next()).getPath();
                pw.println("<li>");
                pw.printf("<a target='_new' href='/crx/de/index.jsp#%s'>%s</a>", path, path);
                pw.println("</li>");
            }
            pw.println("</ul>");
            pw.println("<br/>");
            pw.println("<p class='statline ui-state-highlight'>Inbox Notification Sizes</p>");
            pw.println("<table class='content'>");
            pw.println("<tr><th class='content'>Path</th><th class='content'>Count</th><th class='content'>In Last 24 Hours</th><th></th></tr>");
            Iterator inboxes = resolver.findResources("/jcr:root//element(*, rep:User)/wcm/notification/inbox", "xpath");
            while (inboxes.hasNext()) {
                Resource inbox = (Resource)inboxes.next();
                long[] childCount = this.countChildren(inbox, yesterday);
                pw.printf("<tr><td class='content'>%s</td><td class='content'>%s</td><td class='content'>%s</td><td><form method='POST' action=''><input type='hidden' name='path' value='%s'><input type='submit' value='Clear'></form></td></tr>%n", inbox.getPath(), childCount[0], childCount[1], inbox.getPath());
            }
            pw.println("</table>");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (resolver != null && resolver.isLive()) {
                resolver.close();
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getParameter("path");
        if (path != null) {
            ResourceResolver resolver = null;
            try {
                int counter = 0;
                resolver = this.rrFactory.getAdministrativeResourceResolver(null);
                Session session = (Session)resolver.adaptTo(Session.class);
                Node node = session.getNode(path);
                NodeIterator it = node.getNodes();
                while (it.hasNext()) {
                    it.nextNode().remove();
                    ++counter;
                }
                session.save();
                resp.getWriter().printf("<p class='statline ui-state-error'>Deleted %s notifications</p>%n", counter);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                if (resolver != null && resolver.isLive()) {
                    resolver.close();
                }
            }
        }
        resp.sendRedirect((String)req.getAttribute("felix.webconsole.pluginRoot"));
    }

    private long[] countChildren(Resource inbox, Date yesterday) {
        long counter = 0L;
        long yesterdayCounter = 0L;
        Iterator children = inbox.listChildren();
        while (children.hasNext()) {
            Resource child = (Resource)children.next();
            ValueMap map = (ValueMap)child.adaptTo(ValueMap.class);
            Date date = (Date)map.get("modifiedDate", Date.class);
            if (date != null && date.after(yesterday)) {
                ++yesterdayCounter;
            }
            ++counter;
        }
        return new long[]{counter, yesterdayCounter};
    }

    protected void bindRrFactory(ResourceResolverFactory resourceResolverFactory) {
        this.rrFactory = resourceResolverFactory;
    }

    protected void unbindRrFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrFactory == resourceResolverFactory) {
            this.rrFactory = null;
        }
    }
}

