/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.day.cq.commons.Externalizer;
import com.day.cq.commons.Filter;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import com.day.cq.wcm.api.PageManager;
import java.io.IOException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.osgi.PropertiesUtil;

@Component(metatype=true, label="ACS AEM Commons - Site Map Servlet", description="Site Map Servlet", configurationFactory=true)
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", unbounded=PropertyUnbounded.ARRAY, label="Sling Resource Type", description="Sling Resource Type for the Home Page component or components."), @Property(name="sling.servlet.selectors", value={"sitemap"}, propertyPrivate=true), @Property(name="sling.servlet.extensions", value={"xml"}, propertyPrivate=true), @Property(name="sling.servlet.methods", value={"GET"}, propertyPrivate=true), @Property(name="webconsole.configurationFactory.nameHint", value={"Site Map for: {externalizer.domain}, on resource types: [{sling.servlet.resourceTypes}]"})})
public final class SiteMapServlet
extends SlingSafeMethodsServlet {
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private static final boolean DEFAULT_INCLUDE_LAST_MODIFIED = false;
    private static final String DEFAULT_EXTERNALIZER_DOMAIN = "publish";
    @Property(value={"publish"}, label="Externalizer Domain", description="Must correspond to a configuration of the Externalizer component.")
    private static final String PROP_EXTERNALIZER_DOMAIN = "externalizer.domain";
    @Property(boolValue={false}, label="Include Last Modified", description="If true, the last modified value will be included in the sitemap.")
    private static final String PROP_INCLUDE_LAST_MODIFIED = "include.lastmod";
    @Property(label="Change Frequency Properties", description="The set of JCR property names which will contain the change frequency value.")
    private static final String PROP_CHANGE_FREQUENCY_PROPERTIES = "changefreq.properties";
    @Property(label="Priority Properties", description="The set of JCR property names which will contain the priority value.")
    private static final String PROP_PRIORITY_PROPERTIES = "priority.properties";
    private static final String NS = "http://www.sitemaps.org/schemas/sitemap/0.9";
    @Reference
    private Externalizer externalizer;
    private String externalizerDomain;
    private boolean includeLastModified;
    private String[] changefreqProperties;
    private String[] priorityProperties;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.externalizerDomain = PropertiesUtil.toString((Object)properties.get(PROP_EXTERNALIZER_DOMAIN), (String)DEFAULT_EXTERNALIZER_DOMAIN);
        this.includeLastModified = PropertiesUtil.toBoolean((Object)properties.get(PROP_INCLUDE_LAST_MODIFIED), (boolean)false);
        this.changefreqProperties = PropertiesUtil.toStringArray((Object)properties.get(PROP_CHANGE_FREQUENCY_PROPERTIES), (String[])new String[0]);
        this.priorityProperties = PropertiesUtil.toStringArray((Object)properties.get(PROP_PRIORITY_PROPERTIES), (String[])new String[0]);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType(request.getResponseContentType());
        ResourceResolver resourceResolver = request.getResourceResolver();
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        Page page = pageManager.getContainingPage(request.getResource());
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            XMLStreamWriter stream = outputFactory.createXMLStreamWriter(response.getWriter());
            stream.writeStartDocument("1.0");
            stream.writeStartElement("", "urlset", NS);
            stream.writeNamespace("", NS);
            this.write(page, stream, resourceResolver);
            Iterator children = page.listChildren((Filter)new PageFilter(), true);
            while (children.hasNext()) {
                this.write((Page)children.next(), stream, resourceResolver);
            }
            stream.writeEndElement();
            stream.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void write(Page page, XMLStreamWriter stream, ResourceResolver resolver) throws XMLStreamException {
        Calendar cal;
        stream.writeStartElement(NS, "url");
        String loc = this.externalizer.externalLink(resolver, this.externalizerDomain, String.format("%s.html", page.getPath()));
        this.writeElement(stream, "loc", loc);
        if (this.includeLastModified && (cal = page.getLastModified()) != null) {
            this.writeElement(stream, "lastmod", DATE_FORMAT.format(cal));
        }
        ValueMap properties = page.getProperties();
        this.writeFirstPropertyValue(stream, "changefreq", this.changefreqProperties, properties);
        this.writeFirstPropertyValue(stream, "priority", this.priorityProperties, properties);
        stream.writeEndElement();
    }

    private void writeFirstPropertyValue(XMLStreamWriter stream, String elementName, String[] propertyNames, ValueMap properties) throws XMLStreamException {
        for (String prop : propertyNames) {
            String value = (String)properties.get(prop, String.class);
            if (value == null) continue;
            this.writeElement(stream, elementName, value);
            break;
        }
    }

    private void writeElement(XMLStreamWriter stream, String elementName, String text) throws XMLStreamException {
        stream.writeStartElement(NS, elementName);
        stream.writeCharacters(text);
        stream.writeEndElement();
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }
}

