/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.day.cq.commons.PathInfo;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.reference.Reference;
import com.day.cq.wcm.api.reference.ReferenceProvider;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.PropertiesUtil;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service
public final class PagesReferenceProvider
implements ReferenceProvider {
    private static final String TYPE_PAGE = "page";
    private static final String DEFAULT_PAGE_ROOT_PATH = "/content/";
    private String pageRootPath = "/content/";
    @Property(label="page root path", description="Page root path", value={"/content/"})
    private static final String PAGE_ROOT_PATH = "page.root.path";
    private Pattern pattern = Pattern.compile("([\"']|^)(" + Pattern.quote(this.pageRootPath) + ")(\\S|$)");

    @Activate
    protected void activate(Map<String, Object> props) {
        this.pageRootPath = PropertiesUtil.toString((Object)props.get(PAGE_ROOT_PATH), (String)DEFAULT_PAGE_ROOT_PATH);
        this.pattern = Pattern.compile("([\"']|^)(" + Pattern.quote(this.pageRootPath) + ")(\\S|$)");
    }

    public List<Reference> findReferences(Resource resource) {
        ArrayList<Reference> references = new ArrayList<Reference>();
        ResourceResolver resolver = resource.getResourceResolver();
        PageManager pageManager = (PageManager)resolver.adaptTo(PageManager.class);
        HashSet<Page> pages = new HashSet<Page>();
        this.search(resource, pages, pageManager);
        for (Page page : pages) {
            references.add(this.getReference(page));
        }
        return references;
    }

    private void search(Resource resource, Set<Page> pages, PageManager pageManager) {
        this.findReferencesInResource(resource, pages, pageManager);
        Iterator iter = resource.listChildren();
        while (iter.hasNext()) {
            this.search((Resource)iter.next(), pages, pageManager);
        }
    }

    private void findReferencesInResource(Resource resource, Set<Page> pages, PageManager pageManager) {
        ValueMap map = (ValueMap)resource.adaptTo(ValueMap.class);
        for (String key : map.keySet()) {
            String[] values;
            for (String value : values = (String[])map.get(key, (Object)new String[0])) {
                if (!this.pattern.matcher(value).find()) continue;
                for (String path : this.getAllPathsInAProperty(value)) {
                    Page page = pageManager.getContainingPage(path);
                    if (page == null) continue;
                    pages.add(page);
                }
            }
        }
    }

    private Reference getReference(Page page) {
        return new Reference(TYPE_PAGE, String.format("%s (Page)", page.getName()), page.getContentResource(), this.getLastModifiedTimeOfResource(page));
    }

    private long getLastModifiedTimeOfResource(Page page) {
        Calendar mod = page.getLastModified();
        long lastModified = mod != null ? mod.getTimeInMillis() : -1L;
        return lastModified;
    }

    private Set<String> getAllPathsInAProperty(String value) {
        if (this.isSinglePathInValue(value)) {
            return this.getSinglePath(value);
        }
        return this.getMultiplePaths(value);
    }

    private boolean isSinglePathInValue(String value) {
        return value.startsWith("/");
    }

    private Set<String> getSinglePath(String value) {
        HashSet<String> paths = new HashSet<String>();
        paths.add(this.decode(value));
        return paths;
    }

    private Set<String> getMultiplePaths(String value) {
        HashSet<String> paths = new HashSet<String>();
        int startPos = value.indexOf(this.pageRootPath, 1);
        while (startPos != -1) {
            int endPos;
            char charBeforeStartPos = value.charAt(startPos - 1);
            if ((charBeforeStartPos == '\'' || charBeforeStartPos == '\"') && (endPos = value.indexOf(charBeforeStartPos, startPos)) > startPos) {
                String ref = value.substring(startPos, endPos);
                paths.add(this.decode(ref));
                startPos = endPos;
            }
            startPos = value.indexOf(this.pageRootPath, startPos + 1);
        }
        return paths;
    }

    private String decode(String url) {
        return new PathInfo(url).getResourcePath();
    }
}

