/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.adobe.acs.commons.json.AbstractJSONObjectVisitor;
import com.adobe.acs.commons.util.BufferingResponse;
import com.adobe.acs.commons.util.InfoWriter;
import com.adobe.acs.commons.util.PathInfoUtil;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(selectors={"overlay.cqinclude.namespace"}, extensions={"json"}, resourceTypes={"sling/servlet/default"})
public final class CQIncludePropertyNamespaceServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(CQIncludePropertyNamespaceServlet.class);
    private static final String REQ_ATTR = CQIncludePropertyNamespaceServlet.class.getName() + ".processed";
    private static final String AEM_CQ_INCLUDE_SELECTORS = "overlay.infinity";
    private static final int NAME_PROPERTY_SELECTOR_INDEX = 3;
    private static final String PN_NAME = "name";
    private static final String NT_CQ_WIDGET = "cq:Widget";
    private static final String[] DEFAULT_NAMESPACEABLE_PROPERTY_NAMES = new String[]{"name", "cropParameter", "fileNameParameter", "fileReferenceParameter", "mapParameter", "rotateParameter", "widthParameter", "heightParameter"};
    private String[] namespaceablePropertyNames = null;
    @Property(label="Property Names", description="Namespace properties defined in this list. Leave empty for on 'name'.  Defaults to [ name, cropParameter, fileNameParameter, fileReferenceParameter, mapParameter, rotateParameter, widthParameter, heightParameter] ", value={"name", "cropParameter", "fileNameParameter", "fileReferenceParameter", "mapParameter", "rotateParameter", "widthParameter", "heightParameter"})
    public static final String PROP_NAMESPACEABLE_PROPERTY_NAMES = "namespace.property-names";
    private static final String[] DEFAULT_NAMESPACEABLE_PROPERTY_VALUE_PATTERNS = new String[]{"^\\./.*"};
    private List<Pattern> namespaceablePropertyValuePatterns = new ArrayList<Pattern>();
    @Property(label="Property Value Patterns", description="Namespace properties whose values match a regex in this list. Defaults to [ \"^\\\\./.*\" ]", value={"^\\./.*"})
    public static final String PROP_NAMESPACEABLE_PROPERTY_VALUE_PATTERNS = "namespace.property-value-patterns";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        if (!this.accepts(request)) {
            response.setStatus(404);
            response.getWriter().write(new JSONObject().toString());
        }
        RequestUtil.setRequestAttribute((HttpServletRequest)request, (String)REQ_ATTR, (Object)true);
        String namespace = URLDecoder.decode(PathInfoUtil.getSelector(request, 3), "UTF-8");
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setReplaceSelectors(AEM_CQ_INCLUDE_SELECTORS);
        BufferingResponse bufferingResponse = new BufferingResponse((HttpServletResponse)response);
        request.getRequestDispatcher(request.getResource(), options).forward((ServletRequest)request, (ServletResponse)bufferingResponse);
        try {
            JSONObject json = new JSONObject(bufferingResponse.getContents());
            PropertyNamespaceUpdater propertyNamespaceUpdater = new PropertyNamespaceUpdater(namespace);
            propertyNamespaceUpdater.accept(json);
            response.getWriter().write(json.toString());
        }
        catch (JSONException e) {
            log.error("Error composing the cqinclude JSON representation of the widget overlay for [ {} ]", (Object)request.getRequestURI(), (Object)e);
            response.setStatus(500);
            response.getWriter().write(new JSONObject().toString());
        }
    }

    protected boolean accepts(SlingHttpServletRequest request) {
        if (request.getAttribute(REQ_ATTR) != null) {
            log.warn("Identified a cyclic loop in the ACS Commons CQ Include Namespace prefix Servlet for [ {} ]", (Object)request.getRequestURI());
            return false;
        }
        for (int i = 0; i <= 3; ++i) {
            if (!StringUtils.isBlank((String)PathInfoUtil.getSelector(request, i))) continue;
            return false;
        }
        return true;
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        String[] regexes;
        this.namespaceablePropertyNames = PropertiesUtil.toStringArray((Object)config.get(PROP_NAMESPACEABLE_PROPERTY_NAMES), (String[])DEFAULT_NAMESPACEABLE_PROPERTY_NAMES);
        this.namespaceablePropertyValuePatterns = new ArrayList<Pattern>();
        for (String regex : regexes = PropertiesUtil.toStringArray((Object)config.get(PROP_NAMESPACEABLE_PROPERTY_VALUE_PATTERNS), (String[])DEFAULT_NAMESPACEABLE_PROPERTY_VALUE_PATTERNS)) {
            this.namespaceablePropertyValuePatterns.add(Pattern.compile(regex));
        }
        InfoWriter iw = new InfoWriter();
        iw.title("ACS AEM Commons - CQInclude Property Namespace Servlet");
        iw.message("Namespace-able Property Names: {}", Arrays.asList(this.namespaceablePropertyNames));
        iw.message("Namespace-able Property Value Patterns: {}", this.namespaceablePropertyValuePatterns);
        iw.end();
        log.info(iw.toString());
    }

    public final class PropertyNamespaceUpdater
    extends AbstractJSONObjectVisitor {
        private final String namespace;
        private static final String DOT_SLASH = "./";

        public PropertyNamespaceUpdater(String namespace) {
            this.namespace = namespace;
        }

        private boolean accept(String propertyName, String propertyValue) {
            if (CQIncludePropertyNamespaceServlet.this.namespaceablePropertyNames != null) {
                for (String name : CQIncludePropertyNamespaceServlet.this.namespaceablePropertyNames) {
                    if (!StringUtils.equals((String)name, (String)propertyName)) continue;
                    return true;
                }
            }
            if (CQIncludePropertyNamespaceServlet.this.namespaceablePropertyValuePatterns != null) {
                for (Pattern pattern : CQIncludePropertyNamespaceServlet.this.namespaceablePropertyValuePatterns) {
                    Matcher matcher = pattern.matcher(propertyValue);
                    if (!matcher.matches()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected void visit(JSONObject jsonObject) {
            if (StringUtils.equals((String)jsonObject.optString("jcr:primaryType"), (String)CQIncludePropertyNamespaceServlet.NT_CQ_WIDGET)) {
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String propertyName = (String)keys.next();
                    if (!this.accept(propertyName, jsonObject.optString(propertyName))) {
                        log.debug("Property [ {} ~> {} ] is not a namespaceable property name/value", (Object)propertyName, (Object)jsonObject.optString(propertyName));
                        continue;
                    }
                    String value = jsonObject.optString(propertyName);
                    if (value == null) continue;
                    String prefix = "";
                    if (StringUtils.startsWith((String)value, (String)DOT_SLASH)) {
                        value = StringUtils.removeStart((String)value, (String)DOT_SLASH);
                        prefix = DOT_SLASH;
                    }
                    if (!StringUtils.isNotBlank((String)value)) continue;
                    try {
                        jsonObject.put(propertyName, (Object)(prefix + this.namespace + "/" + value));
                    }
                    catch (JSONException e) {
                        log.error("Error updating the Name property of the JSON object", (Throwable)e);
                    }
                }
            }
        }
    }
}

