/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="ACS AEM Commons - OSGI Bundle Disabler", description="Disables bundles by configuration", policy=ConfigurationPolicy.REQUIRE)
@Service
@Property(name="event.topics", value={"org/osgi/framework/BundleEvent/STARTED"}, propertyPrivate=true)
public class BundleDisabler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(BundleDisabler.class);
    @Property(label="Disabled bundles", description="The symbolic names of the bundles you want to disable", cardinality=0x7FFFFFFF)
    private static final String DISABLED_BUNDLES = "bundles";
    private BundleContext bundleContext;
    private List<String> disabledBundles = Collections.emptyList();

    @Activate
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        this.bundleContext = componentContext.getBundleContext();
        this.disabledBundles = this.getDisabledBundles(properties);
        this.disableBundles();
    }

    public void handleEvent(Event event) {
        this.disableBundles();
    }

    private void disableBundles() {
        if (this.disabledBundles.isEmpty()) {
            log.info("No bundles specified. Consider specifying bundles or removing this service config");
            return;
        }
        log.trace("Disabling bundles {}", this.disabledBundles);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (!this.isOnBundleStopList(bundle)) continue;
            try {
                this.disableBundle(bundle);
            }
            catch (BundleException be) {
                log.error("Unable to stop bundle {}", (Object)bundle.getSymbolicName(), (Object)be);
            }
        }
    }

    private void disableBundle(Bundle bundle) throws BundleException {
        if (this.isBundleStoppable(bundle) && this.isNotOwnBundle(bundle)) {
            log.info("Bundle {} disabled by configuration (name={}) ", (Object)bundle.getSymbolicName(), (Object)bundle.getBundleId());
            bundle.stop();
        }
    }

    private List<String> getDisabledBundles(Map<String, Object> properties) {
        String[] bundlesProperty = PropertiesUtil.toStringArray((Object)properties.get(DISABLED_BUNDLES), (String[])new String[0]);
        return Arrays.asList(PropertiesUtil.toStringArray((Object)bundlesProperty, (String[])new String[0]));
    }

    private boolean isOnBundleStopList(Bundle bundle) {
        return this.disabledBundles.contains(bundle.getSymbolicName());
    }

    private boolean isBundleStoppable(Bundle bundle) {
        return bundle.getState() != 1;
    }

    private boolean isNotOwnBundle(Bundle bundle) {
        return !bundle.equals(this.bundleContext.getBundle());
    }
}

