/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.status.impl;

import com.adobe.acs.commons.workflow.WorkflowPackageManager;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Property(label="Workflow Label", name="process.label", value={"Set Replicated By Property to Workflow Initiator"}, description="Sets the Replicated By Property on the payload to the Workflow Initiator")
@Service
public class ReplicatedByWorkflowProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(ReplicatedByWorkflowProcess.class);
    private static final String AUTHENTICATION_INFO_SESSION = "user.jcr.session";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private WorkflowPackageManager workflowPackageManager;

    public final void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        WorkflowData workflowData = workItem.getWorkflowData();
        String type = workflowData.getPayloadType();
        if (!StringUtils.equals((String)type, (String)"JCR_PATH")) {
            return;
        }
        String payloadPath = workflowData.getPayload().toString();
        HashMap<String, Session> authInfo = new HashMap<String, Session>();
        authInfo.put(AUTHENTICATION_INFO_SESSION, workflowSession.getSession());
        try {
            ResourceResolver resourceResolver = this.resourceResolverFactory.getResourceResolver(authInfo);
            String replicatedBy = StringUtils.defaultIfEmpty((String)workItem.getWorkflow().getInitiator(), (String)"Unknown Workflow User");
            PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
            List<String> paths = this.workflowPackageManager.getPaths(resourceResolver, payloadPath);
            for (String path : paths) {
                Resource resource;
                Page page = pageManager.getContainingPage(path);
                Asset asset = DamUtil.resolveToAsset((Resource)resourceResolver.getResource(path));
                if (page != null) {
                    resource = page.getContentResource();
                    log.trace("Candidate Page for setting replicateBy is [ {} ]", (Object)resource.getPath());
                } else if (asset != null) {
                    Resource assetResource = resourceResolver.getResource(asset.getPath());
                    resource = assetResource.getChild("jcr:content");
                    log.trace("Candidate Asset for setting replicateBy is [ {} ]", (Object)resource.getPath());
                } else {
                    resource = resourceResolver.getResource(path);
                    log.trace("Candidate Resource for setting replicateBy is [ {} ]", (Object)resource.getPath());
                }
                ModifiableValueMap mvm = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
                if (StringUtils.isNotBlank((String)((String)mvm.get("cq:lastReplicatedBy", String.class)))) {
                    mvm.put((Object)"cq:lastReplicatedBy", (Object)replicatedBy);
                    resourceResolver.commit();
                    log.trace("Set replicateBy to [ {} ] on resource  [ {} ]", (Object)replicatedBy, (Object)resource.getPath());
                    continue;
                }
                log.trace("Skipping; Resource does not have replicateBy property set  [ {} ]", (Object)resource.getPath());
            }
        }
        catch (LoginException e) {
            log.error("Could not acquire a ResourceResolver object from the Workflow Session's JCR Session: {}", (Throwable)e);
        }
        catch (PersistenceException e) {
            log.error("Could not save replicateBy property for payload [ {} ] due to: {}", (Object)payloadPath, (Object)e);
        }
        catch (RepositoryException e) {
            log.error("Could not collect Workflow Package items for payload [ {} ] due to: {}", (Object)payloadPath, (Object)e);
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindWorkflowPackageManager(WorkflowPackageManager workflowPackageManager) {
        this.workflowPackageManager = workflowPackageManager;
    }

    protected void unbindWorkflowPackageManager(WorkflowPackageManager workflowPackageManager) {
        if (this.workflowPackageManager == workflowPackageManager) {
            this.workflowPackageManager = null;
        }
    }
}

