/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.quickly.results.impl;

import com.adobe.acs.commons.quickly.Command;
import com.adobe.acs.commons.quickly.results.Action;
import com.adobe.acs.commons.quickly.results.Result;
import com.adobe.acs.commons.quickly.results.ResultBuilder;
import com.adobe.acs.commons.quickly.results.ResultSerializer;
import com.day.cq.wcm.api.AuthoringUIMode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Reference(name="resultSerializers", referenceInterface=ResultSerializer.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE)
@Service
public class ResultBuilderImpl
implements ResultBuilder {
    private static final Logger log = LoggerFactory.getLogger(ResultBuilderImpl.class);
    private Map<String, ResultSerializer> resultSerializers = new ConcurrentHashMap<String, ResultSerializer>();
    @Reference(target="(type=GENERIC)")
    private ResultSerializer defaultResultSerialize;

    @Override
    public JSONObject toJSON(Command cmd, Result result, ValueMap config) throws JSONException {
        if (!this.acceptsAuthoringUIMode(result, (AuthoringUIMode)config.get(AuthoringUIMode.class.getName(), (Object)AuthoringUIMode.TOUCH))) {
            log.debug("Rejected by Authoring UI Mode: {}", (Object)result.getTitle());
            return null;
        }
        if (!this.acceptsQuicklyMode(result, Arrays.asList((Object[])config.get("results", String[].class)))) {
            log.debug("Rejected by Quickly Mode: {}", (Object)result.getTitle());
            return null;
        }
        result = this.processPunctuation(cmd.getPunctuation(), result);
        ResultSerializer serializer = null;
        if (StringUtils.isNotBlank((String)result.getResultType()) && this.resultSerializers.containsKey(result.getResultType())) {
            serializer = this.resultSerializers.get(result.getResultType());
        }
        if (serializer == null) {
            serializer = this.resultSerializers.get("GENERIC");
        }
        if (serializer != null) {
            return serializer.toJSON(result, config);
        }
        log.trace("Could not find Quickly Result Serializer for type [ {} ]", (Object)result.getResultType());
        if (this.defaultResultSerialize != null) {
            log.trace("Using Default Quickly Result Serializer for type [ {} ]", (Object)"GENERIC");
            return this.defaultResultSerialize.toJSON(result, config);
        }
        log.error("Could not find Default Quickly Result Serializer of type [ {} ]", (Object)"GENERIC");
        return null;
    }

    protected final boolean acceptsAuthoringUIMode(Result result, AuthoringUIMode authoringUIMode) {
        if (result.getAuthoringMode() == null) {
            return true;
        }
        return result.getAuthoringMode().equals((Object)authoringUIMode);
    }

    protected final boolean acceptsQuicklyMode(Result result, List<String> modes) {
        if (result.getModes().contains((Object)Result.Mode.ANY) || CollectionUtils.isEmpty(result.getModes())) {
            return true;
        }
        for (Result.Mode mode : result.getModes()) {
            for (String resultMode : modes) {
                if (!StringUtils.equalsIgnoreCase((String)mode.toString(), (String)resultMode)) continue;
                return true;
            }
        }
        return false;
    }

    protected final Result processPunctuation(String[] punctuation, Result result) {
        for (String p : punctuation) {
            if (!"!".equals(p) || !Action.Method.GET.equals((Object)result.getAction().getMethod()) && !Action.Method.POST.equals((Object)result.getAction().getMethod())) continue;
            result.getAction().setTarget(Action.Target.BLANK);
        }
        return result;
    }

    @Deactivate
    protected final void deactivate(Map<String, String> map) {
        this.resultSerializers = new ConcurrentHashMap<String, ResultSerializer>();
    }

    protected final void bindResultSerializers(ResultSerializer service, Map<Object, Object> props) {
        String type = PropertiesUtil.toString((Object)props.get("type"), null);
        if (type != null) {
            this.resultSerializers.put(type.toUpperCase(), service);
            log.info("Collected Result Serializer [ {} ]", (Object)type.toUpperCase());
        }
    }

    protected final void unbindResultSerializers(ResultSerializer service, Map<Object, Object> props) {
        String type = PropertiesUtil.toString((Object)props.get("type"), null);
        if (type != null) {
            this.resultSerializers.remove(type.toUpperCase());
            log.info("Discarded Result Serializer [ {} ]", (Object)type.toUpperCase());
        }
    }

    protected void bindDefaultResultSerialize(ResultSerializer resultSerializer) {
        this.defaultResultSerialize = resultSerializer;
    }

    protected void unbindDefaultResultSerialize(ResultSerializer resultSerializer) {
        if (this.defaultResultSerialize == resultSerializer) {
            this.defaultResultSerialize = null;
        }
    }
}

