/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.packaging.impl;

import com.adobe.acs.commons.packaging.PackageHelper;
import com.day.jcr.vault.fs.api.Filter;
import com.day.jcr.vault.fs.api.PathFilterSet;
import com.day.jcr.vault.fs.filter.DefaultPathFilter;
import com.day.jcr.vault.fs.io.AccessControlHandling;
import com.day.jcr.vault.packaging.JcrPackage;
import com.day.jcr.vault.packaging.Packaging;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/packager/authorizable-packager"}, selectors={"package"}, extensions={"json"})
public class AuthorizablePackagerServletImpl
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(AuthorizablePackagerServletImpl.class);
    private static final String PACKAGE_NAME = "packageName";
    private static final String PACKAGE_GROUP_NAME = "packageGroupName";
    private static final String PACKAGE_VERSION = "packageVersion";
    private static final String PACKAGE_DESCRIPTION = "packageDescription";
    private static final String PACKAGE_ACL_HANDLING = "packageACLHandling";
    private static final String CONFLICT_RESOLUTION = "conflictResolution";
    private static final String DEFAULT_PACKAGE_NAME = "authorizables";
    private static final String DEFAULT_PACKAGE_GROUP_NAME = "Authorizables";
    private static final String DEFAULT_PACKAGE_VERSION = "1.0.0";
    private static final String DEFAULT_PACKAGE_DESCRIPTION = "Authorizable Package initially defined by a ACS AEM Commons - Authorizable Packager configuration.";
    private static final String QUERY_PACKAGE_THUMBNAIL_RESOURCE_PATH = "/apps/acs-commons/components/utilities/packager/authorizable-packager/definition/package-thumbnail.png";
    @Reference
    private Packaging packaging;
    @Reference
    private PackageHelper packageHelper;

    public final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        ResourceResolver resourceResolver = request.getResourceResolver();
        boolean preview = Boolean.parseBoolean(request.getParameter("preview"));
        log.debug("Preview mode: {}", (Object)preview);
        ValueMap properties = this.getProperties(request);
        try {
            List<PathFilterSet> paths = this.findPaths(resourceResolver, (String[])properties.get("authorizableIds", (Object)new String[0]));
            HashMap<String, String> packageDefinitionProperties = new HashMap<String, String>();
            packageDefinitionProperties.put("acHandling", (String)properties.get(PACKAGE_ACL_HANDLING, (Object)AccessControlHandling.OVERWRITE.toString()));
            packageDefinitionProperties.put("jcr:description", (String)properties.get(PACKAGE_DESCRIPTION, (Object)DEFAULT_PACKAGE_DESCRIPTION));
            if (preview) {
                response.getWriter().print(this.packageHelper.getPathFilterSetPreviewJSON(paths));
            } else if (paths == null || paths.isEmpty()) {
                response.getWriter().print(this.packageHelper.getErrorJSON("Refusing to create a package with no filter set rules."));
            } else {
                JcrPackage jcrPackage = this.packageHelper.createPackageFromPathFilterSets(paths, (Session)request.getResourceResolver().adaptTo(Session.class), (String)properties.get(PACKAGE_GROUP_NAME, (Object)DEFAULT_PACKAGE_GROUP_NAME), (String)properties.get(PACKAGE_NAME, (Object)DEFAULT_PACKAGE_NAME), (String)properties.get(PACKAGE_VERSION, (Object)DEFAULT_PACKAGE_VERSION), PackageHelper.ConflictResolution.valueOf((String)properties.get(CONFLICT_RESOLUTION, (Object)PackageHelper.ConflictResolution.IncrementVersion.toString())), packageDefinitionProperties);
                this.packageHelper.addThumbnail(jcrPackage, request.getResourceResolver().getResource(QUERY_PACKAGE_THUMBNAIL_RESOURCE_PATH));
                log.debug("Successfully created JCR package");
                response.getWriter().print(this.packageHelper.getSuccessJSON(jcrPackage));
            }
        }
        catch (RepositoryException ex) {
            log.error("Repository error while creating Query Package", (Throwable)ex);
            response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
        }
        catch (IOException ex) {
            log.error("IO error while creating Query Package", (Throwable)ex);
            response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
        }
        catch (JSONException ex) {
            log.error("JSON error while creating Query Package response", (Throwable)ex);
            response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
        }
    }

    private ValueMap getProperties(SlingHttpServletRequest request) {
        if (request.getResource().getChild("configuration") == null) {
            log.warn("Authorizable Packager Configuration node could not be found for: {}", (Object)request.getResource());
            return new ValueMapDecorator(new HashMap());
        }
        return (ValueMap)request.getResource().getChild("configuration").adaptTo(ValueMap.class);
    }

    private List<PathFilterSet> findPaths(ResourceResolver resourceResolver, String[] authorizableIds) throws RepositoryException {
        UserManager userManager = (UserManager)resourceResolver.adaptTo(UserManager.class);
        ArrayList<PathFilterSet> pathFilterSets = new ArrayList<PathFilterSet>();
        for (String authorizableId : authorizableIds) {
            try {
                Authorizable authorizable = userManager.getAuthorizable(authorizableId);
                if (authorizable == null) continue;
                String path = authorizable.getPath();
                PathFilterSet principal = new PathFilterSet(path);
                principal.addExclude((Filter)new DefaultPathFilter(path + "/\\.tokens"));
                pathFilterSets.add(principal);
            }
            catch (RepositoryException e) {
                log.warn("Unable to find path for authorizable " + authorizableId, (Throwable)e);
            }
        }
        return pathFilterSets;
    }

    protected void bindPackaging(Packaging packaging) {
        this.packaging = packaging;
    }

    protected void unbindPackaging(Packaging packaging) {
        if (this.packaging == packaging) {
            this.packaging = null;
        }
    }

    protected void bindPackageHelper(PackageHelper packageHelper) {
        this.packageHelper = packageHelper;
    }

    protected void unbindPackageHelper(PackageHelper packageHelper) {
        if (this.packageHelper == packageHelper) {
            this.packageHelper = null;
        }
    }
}

