/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.models.injectors.impl;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.commons.WCMUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import javax.jcr.Session;
import javax.servlet.ServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;

@Component
@Service
@Property(name="service.ranking", intValue={4500})
public final class AemObjectsInjector
implements Injector {
    private static final String COM_DAY_CQ_WCM_TAGS_DEFINE_OBJECTS_TAG = "com.day.cq.wcm.tags.DefineObjectsTag";

    public String getName() {
        return "define-objects";
    }

    public Object getValue(Object adaptable, String name, Type declaredType, AnnotatedElement element, DisposalCallbackRegistry callbackRegistry) {
        if (!(adaptable instanceof Resource) && !(adaptable instanceof SlingHttpServletRequest)) {
            return null;
        }
        ObjectType nameEnum = ObjectType.fromString(name);
        if (nameEnum == null) {
            return null;
        }
        switch (nameEnum) {
            case RESOURCE: {
                return this.getResource(adaptable);
            }
            case RESOURCE_RESOLVER: {
                return this.getResourceResolver(adaptable);
            }
            case COMPONENT_CONTEXT: {
                return this.getComponentContext(adaptable);
            }
            case PAGE_MANAGER: {
                return this.getPageManager(adaptable);
            }
            case CURRENT_PAGE: {
                return this.getCurrentPage(adaptable);
            }
            case RESOURCE_PAGE: {
                return this.getResourcePage(adaptable);
            }
            case DESIGNER: {
                return this.getDesigner(adaptable);
            }
            case CURRENT_DESIGN: {
                return this.getCurrentDesign(adaptable);
            }
            case RESOURCE_DESIGN: {
                return this.getResourceDesign(adaptable);
            }
            case CURRENT_STYLE: {
                return this.getCurrentStyle(adaptable);
            }
            case SESSION: {
                return this.getSession(adaptable);
            }
            case XSS_API: {
                return this.getXssApi(adaptable);
            }
        }
        return null;
    }

    private Resource getResource(Object adaptable) {
        if (adaptable instanceof SlingHttpServletRequest) {
            return ((SlingHttpServletRequest)adaptable).getResource();
        }
        if (adaptable instanceof Resource) {
            return (Resource)adaptable;
        }
        return null;
    }

    private ResourceResolver getResourceResolver(Object adaptable) {
        if (adaptable instanceof SlingHttpServletRequest) {
            return ((SlingHttpServletRequest)adaptable).getResourceResolver();
        }
        if (adaptable instanceof Resource) {
            return ((Resource)adaptable).getResourceResolver();
        }
        return null;
    }

    private PageManager getPageManager(Object adaptable) {
        ResourceResolver resolver = this.getResourceResolver(adaptable);
        if (resolver != null) {
            return (PageManager)resolver.adaptTo(PageManager.class);
        }
        return null;
    }

    private Designer getDesigner(Object adaptable) {
        ResourceResolver resolver = this.getResourceResolver(adaptable);
        if (resolver != null) {
            return (Designer)resolver.adaptTo(Designer.class);
        }
        return null;
    }

    private ComponentContext getComponentContext(Object adaptable) {
        if (adaptable instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest request = (SlingHttpServletRequest)adaptable;
            return WCMUtils.getComponentContext((ServletRequest)request);
        }
        return null;
    }

    private Page getResourcePage(Object adaptable) {
        PageManager pageManager = this.getPageManager(adaptable);
        Resource resource = this.getResource(adaptable);
        if (pageManager != null && resource != null) {
            return pageManager.getContainingPage(resource);
        }
        return null;
    }

    private Page getCurrentPage(Object adaptable) {
        ComponentContext context = this.getComponentContext(adaptable);
        return context != null ? context.getPage() : null;
    }

    private Design getCurrentDesign(Object adaptable) {
        Page currentPage = this.getCurrentPage(adaptable);
        Designer designer = this.getDesigner(adaptable);
        if (currentPage != null && designer != null) {
            return designer.getDesign(currentPage);
        }
        return null;
    }

    private Design getResourceDesign(Object adaptable) {
        Page resourcePage = this.getResourcePage(adaptable);
        Designer designer = this.getDesigner(adaptable);
        if (adaptable instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest request = (SlingHttpServletRequest)adaptable;
            if (resourcePage != null && designer != null) {
                String resourceDesignKey = COM_DAY_CQ_WCM_TAGS_DEFINE_OBJECTS_TAG + resourcePage.getPath();
                Object cachedResourceDesign = request.getAttribute(resourceDesignKey);
                if (cachedResourceDesign != null) {
                    return (Design)cachedResourceDesign;
                }
                Design resourceDesign = designer.getDesign(resourcePage);
                request.setAttribute(resourceDesignKey, (Object)resourceDesign);
                return resourceDesign;
            }
        }
        if (adaptable instanceof Resource) {
            return designer != null ? designer.getDesign(resourcePage) : null;
        }
        return null;
    }

    private Style getCurrentStyle(Object adaptable) {
        Design currentDesign = this.getCurrentDesign(adaptable);
        ComponentContext componentContext = this.getComponentContext(adaptable);
        if (currentDesign != null && componentContext != null) {
            return currentDesign.getStyle(componentContext.getCell());
        }
        return null;
    }

    private Session getSession(Object adaptable) {
        ResourceResolver resolver = this.getResourceResolver(adaptable);
        return resolver != null ? (Session)resolver.adaptTo(Session.class) : null;
    }

    private XSSAPI getXssApi(Object adaptable) {
        if (adaptable instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest request = (SlingHttpServletRequest)adaptable;
            return (XSSAPI)request.adaptTo(XSSAPI.class);
        }
        return null;
    }

    private static enum ObjectType {
        RESOURCE("resource"),
        RESOURCE_RESOLVER("resourceResolver"),
        COMPONENT_CONTEXT("componentContext"),
        PAGE_MANAGER("pageManager"),
        CURRENT_PAGE("currentPage"),
        RESOURCE_PAGE("resourcePage"),
        DESIGNER("designer"),
        CURRENT_DESIGN("currentDesign"),
        RESOURCE_DESIGN("resourceDesign"),
        CURRENT_STYLE("currentStyle"),
        SESSION("session"),
        XSS_API("xssApi");

        private String text;

        private ObjectType(String text) {
            this.text = text;
        }

        public static ObjectType fromString(String text) {
            if (text != null) {
                for (ObjectType b : ObjectType.values()) {
                    if (!text.equalsIgnoreCase(b.text)) continue;
                    return b;
                }
            }
            return null;
        }
    }
}

