/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.mem.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.engine.CacheContent;
import com.adobe.acs.commons.httpcache.exception.HttpCacheDataStreamException;
import com.adobe.acs.commons.httpcache.exception.HttpCacheKeyCreationException;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.store.HttpCacheStore;
import com.adobe.acs.commons.httpcache.store.TempSink;
import com.adobe.acs.commons.httpcache.store.mem.impl.MemCacheMBean;
import com.adobe.acs.commons.httpcache.store.mem.impl.MemCachePersistenceObject;
import com.adobe.acs.commons.httpcache.store.mem.impl.MemTempSinkImpl;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - HTTP Cache - In-Memory cache store.", description="Cache data store implementation for in-memory storage.", metatype=true)
@Properties(value={@Property(name="httpcache.cachestore.type", value={"MEM"}, propertyPrivate=true), @Property(name="jmx.objectname", value={"com.adobe.acs.httpcache:type=In Memory HTTP Cache Store"}, propertyPrivate=true), @Property(name="webconsole.configurationFactory.nameHint", value={"TTL: {httpcache.cachestore.memcache.ttl}, Max size in MB: {httpcache.cachestore.memcache.maxsize}"}, propertyPrivate=true)})
@Service(value={DynamicMBean.class, HttpCacheStore.class})
public class MemHttpCacheStoreImpl
extends AnnotatedStandardMBean
implements HttpCacheStore,
MemCacheMBean {
    private static final Logger log = LoggerFactory.getLogger(MemHttpCacheStoreImpl.class);
    private static final long MEGABYTE = 0x100000L;
    @Property(label="TTL", description="TTL for all entries in this cache in seconds. Default to -1 meaning no TTL.", longValue={-1L})
    private static final String PROP_TTL = "httpcache.cachestore.memcache.ttl";
    private static final long DEFAULT_TTL = -1L;
    private long ttl;
    @Property(label="Maximum size of this store in MB", description="Default to 10MB. If cache size goes beyond this size, least used entry will be evicted from the cache", longValue={10L})
    private static final String PROP_MAX_SIZE_IN_MB = "httpcache.cachestore.memcache.maxsize";
    private static final long DEFAULT_MAX_SIZE_IN_MB = 10L;
    private long maxSizeInMb;
    private Cache<CacheKey, MemCachePersistenceObject> cache;

    @Activate
    protected void activate(Map<String, Object> configs) {
        this.ttl = PropertiesUtil.toLong((Object)configs.get(PROP_TTL), (long)-1L);
        this.maxSizeInMb = PropertiesUtil.toLong((Object)configs.get(PROP_MAX_SIZE_IN_MB), (long)10L);
        if (null != this.cache) {
            this.cache.invalidateAll();
            log.info("Mem cache already present. Invalidating the cache and re-initializing it.");
        }
        this.cache = this.ttl != -1L ? CacheBuilder.newBuilder().maximumWeight(this.maxSizeInMb * 0x100000L).expireAfterWrite(this.ttl, TimeUnit.SECONDS).removalListener((RemovalListener)new MemCacheEntryRemovalListener()).recordStats().build() : CacheBuilder.newBuilder().maximumWeight(this.maxSizeInMb * 0x100000L).weigher((Weigher)new MemCacheEntryWeigher()).removalListener((RemovalListener)new MemCacheEntryRemovalListener()).recordStats().build();
        log.info("MemHttpCacheStoreImpl activated / modified.");
    }

    @Deactivate
    protected void deactivate(Map<String, Object> configs) {
        this.cache.invalidateAll();
        log.info("MemHttpCacheStoreImpl deactivated.");
    }

    @Override
    public void put(CacheKey key, CacheContent content) throws HttpCacheDataStreamException {
        this.cache.put((Object)key, (Object)new MemCachePersistenceObject().buildForCaching(content.getCharEncoding(), content.getContentType(), content.getHeaders(), content.getInputDataStream()));
    }

    @Override
    public boolean contains(CacheKey key) {
        return null != this.getIfPresent(key);
    }

    @Override
    public CacheContent getIfPresent(CacheKey key) {
        MemCachePersistenceObject value = (MemCachePersistenceObject)this.cache.getIfPresent((Object)key);
        if (null == value) {
            return null;
        }
        return new CacheContent(value.getCharEncoding(), value.getContentType(), value.getHeaders(), new ByteArrayInputStream(value.getBytes()));
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public void invalidate(CacheKey key) {
        this.cache.invalidate((Object)key);
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public void invalidate(HttpCacheConfig cacheConfig) {
        ConcurrentMap cacheAsMap = this.cache.asMap();
        for (CacheKey key : cacheAsMap.keySet()) {
            try {
                if (!cacheConfig.knows(key)) continue;
                this.cache.invalidate((Object)key);
            }
            catch (HttpCacheKeyCreationException e) {
                log.error("Could not invalidate HTTP cache. Falling back to full cache invalidation.", (Throwable)e);
                this.invalidateAll();
            }
        }
    }

    @Override
    public TempSink createTempSink() {
        return new MemTempSinkImpl();
    }

    public MemHttpCacheStoreImpl() throws NotCompliantMBeanException {
        super(MemCacheMBean.class);
    }

    @Override
    public void clearCache() {
        this.cache.invalidateAll();
    }

    @Override
    public long getCacheEntriesCount() {
        return this.size();
    }

    @Override
    public String getCacheSize() {
        long size = 0L;
        ConcurrentMap cacheAsMap = this.cache.asMap();
        for (CacheKey key : cacheAsMap.keySet()) {
            size += (long)((MemCachePersistenceObject)cacheAsMap.get(key)).getBytes().length;
        }
        return FileUtils.byteCountToDisplaySize((long)size);
    }

    @Override
    public long getTtl() {
        return this.ttl;
    }

    @Override
    public String getCacheEntry(String cacheKeyStr) throws IOException {
        MemCachePersistenceObject persistenceObject;
        CacheKey cacheKey = null;
        for (CacheKey cacheKeyTmp : this.cache.asMap().keySet()) {
            if (!StringUtils.equals((String)cacheKeyStr, (String)cacheKeyTmp.toString())) continue;
            cacheKey = cacheKeyTmp;
            break;
        }
        if (cacheKey != null && (persistenceObject = (MemCachePersistenceObject)this.cache.getIfPresent(cacheKey)) != null) {
            return IOUtils.toString((InputStream)new ByteArrayInputStream(persistenceObject.getBytes()), (String)persistenceObject.getCharEncoding());
        }
        return "Invalid cache key parameter.";
    }

    @Override
    public TabularData getCacheStats() throws OpenDataException {
        CompositeType cacheEntryType = new CompositeType("Cache Stats", "Cache Stats", new String[]{"Stat", "Value"}, new String[]{"Stat", "Value"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType("Cache Stats", "Cache Stats", cacheEntryType, new String[]{"Stat"}));
        CacheStats cacheStats = this.cache.stats();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("Stat", "Request Count");
        row.put("Value", String.valueOf(cacheStats.requestCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Hit Count");
        row.put("Value", String.valueOf(cacheStats.hitCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Hit Rate");
        row.put("Value", String.format("%.0f%%", cacheStats.hitRate() * 100.0));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Miss Count");
        row.put("Value", String.valueOf(cacheStats.missCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Miss Rate");
        row.put("Value", String.format("%.0f%%", cacheStats.missRate() * 100.0));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Eviction Count");
        row.put("Value", String.valueOf(cacheStats.evictionCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Count");
        row.put("Value", String.valueOf(cacheStats.loadCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Exception Count");
        row.put("Value", String.valueOf(cacheStats.loadExceptionCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Exception Rate");
        row.put("Value", String.format("%.0f%%", cacheStats.loadExceptionRate() * 100.0));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Success Count");
        row.put("Value", String.valueOf(cacheStats.loadSuccessCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Average Load Penalty");
        row.put("Value", String.valueOf(cacheStats.averageLoadPenalty()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Total Load Time");
        row.put("Value", String.valueOf(cacheStats.totalLoadTime()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        return tabularData;
    }

    @Override
    public TabularData getCacheKeys() throws OpenDataException {
        CompositeType cacheEntryType = new CompositeType("Cache Entry", "Cache Entry", new String[]{"Cache Key", "Size", "Content Type", "Character Encoding"}, new String[]{"Cache Key", "Size", "Content Type", "Character Encoding"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType("Cache Entries", "Cache Entries", cacheEntryType, new String[]{"Cache Key"}));
        ConcurrentMap cacheAsMap = this.cache.asMap();
        for (CacheKey key : cacheAsMap.keySet()) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("Cache Key", key.toString());
            MemCachePersistenceObject cacheObj = (MemCachePersistenceObject)this.cache.getIfPresent((Object)key);
            if (cacheObj != null) {
                data.put("Size", FileUtils.byteCountToDisplaySize((long)cacheObj.getBytes().length));
                data.put("Content Type", cacheObj.getContentType());
                data.put("Character Encoding", cacheObj.getCharEncoding());
            }
            tabularData.put(new CompositeDataSupport(cacheEntryType, data));
        }
        return tabularData;
    }

    private static class MemCacheEntryWeigher
    implements Weigher<CacheKey, MemCachePersistenceObject> {
        private MemCacheEntryWeigher() {
        }

        public int weigh(CacheKey memCacheKey, MemCachePersistenceObject memCachePersistenceObject) {
            return memCachePersistenceObject.getBytes().length;
        }
    }

    private static class MemCacheEntryRemovalListener
    implements RemovalListener<CacheKey, MemCachePersistenceObject> {
        private static final Logger log = LoggerFactory.getLogger(MemCacheEntryRemovalListener.class);

        private MemCacheEntryRemovalListener() {
        }

        public void onRemoval(RemovalNotification<CacheKey, MemCachePersistenceObject> removalNotification) {
            log.debug("Mem cache entry for uri {} removed due to {}", (Object)((CacheKey)removalNotification.getKey()).toString(), (Object)removalNotification.getCause().name());
        }
    }
}

