/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.invalidator;

import com.adobe.acs.commons.httpcache.engine.HttpCacheEngine;
import com.adobe.acs.commons.httpcache.exception.HttpCacheException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
@Property(name="job.topics", value={"com/adobe/acs/commons/httpcache/invalidator/job"})
public class HttpCacheInvalidationJobConsumer
implements JobConsumer {
    private static final Logger log = LoggerFactory.getLogger(HttpCacheInvalidationJobConsumer.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    private HttpCacheEngine httpCacheEngine;

    public JobConsumer.JobResult process(Job job) {
        String path = (String)job.getProperty("path");
        if (StringUtils.isEmpty((String)path)) {
            log.error("Invalidation job doesn't have path information.");
            return JobConsumer.JobResult.CANCEL;
        }
        if (this.httpCacheEngine.isPathPotentialToInvalidate(path)) {
            try {
                this.httpCacheEngine.invalidateCache(path);
            }
            catch (HttpCacheException e) {
                log.debug("Job with the payload path - {} has invalidated the cache", (Object)path);
            }
        }
        log.trace("Invalidation job for the path processed.", (Object)path);
        return JobConsumer.JobResult.OK;
    }

    protected void bindHttpCacheEngine(HttpCacheEngine httpCacheEngine) {
        this.httpCacheEngine = httpCacheEngine;
    }

    protected void unbindHttpCacheEngine(HttpCacheEngine httpCacheEngine) {
        if (this.httpCacheEngine == httpCacheEngine) {
            this.httpCacheEngine = null;
        }
    }
}

