/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.filter.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.engine.HttpCacheEngine;
import com.adobe.acs.commons.httpcache.exception.HttpCacheException;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.sling.SlingFilter;
import org.apache.felix.scr.annotations.sling.SlingFilterScope;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingFilter(generateComponent=true, generateService=true, order=4999, scope={SlingFilterScope.REQUEST})
public class HttpCacheFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(HttpCacheFilter.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private HttpCacheEngine cacheEngine;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.trace("In HttpCache filter.");
        long start = System.currentTimeMillis();
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        Object slingResponse = (SlingHttpServletResponse)response;
        HttpCacheConfig cacheConfig = null;
        boolean isResponseCacheable = false;
        try {
            cacheConfig = this.cacheEngine.getCacheConfig(slingRequest);
            if (cacheConfig != null && this.cacheEngine.isRequestCacheable(slingRequest, cacheConfig)) {
                if (this.cacheEngine.isCacheHit(slingRequest, cacheConfig)) {
                    if (this.cacheEngine.deliverCacheContent(slingRequest, (SlingHttpServletResponse)slingResponse, cacheConfig)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Delivered cached request [ {} ] in {} ms", (Object)slingRequest.getRequestURI(), (Object)(System.currentTimeMillis() - start));
                        }
                        return;
                    }
                } else {
                    isResponseCacheable = true;
                    slingResponse = this.cacheEngine.wrapResponse(slingRequest, (SlingHttpServletResponse)slingResponse, cacheConfig);
                }
            }
        }
        catch (HttpCacheException e) {
            log.error("HttpCache exception while dealing with request. Passed on the control to filter chain.", (Throwable)e);
        }
        chain.doFilter(request, (ServletResponse)slingResponse);
        try {
            if (isResponseCacheable) {
                this.cacheEngine.cacheResponse(slingRequest, (SlingHttpServletResponse)slingResponse, cacheConfig);
            }
            if (log.isTraceEnabled()) {
                log.trace("Delivered un-cached request [ {} ] in {} ms", (Object)slingRequest.getRequestURI(), (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (HttpCacheException e) {
            log.error("HttpCache exception while dealing with response. Returned the filter chain response", (Throwable)e);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    protected void bindCacheEngine(HttpCacheEngine httpCacheEngine) {
        this.cacheEngine = httpCacheEngine;
    }

    protected void unbindCacheEngine(HttpCacheEngine httpCacheEngine) {
        if (this.cacheEngine == httpCacheEngine) {
            this.cacheEngine = null;
        }
    }
}

