/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.engine;

import com.adobe.acs.commons.httpcache.engine.impl.HttpCacheServletResponseWrapper;
import com.adobe.acs.commons.httpcache.exception.HttpCacheDataStreamException;
import com.adobe.acs.commons.httpcache.store.TempSink;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheContent {
    private static final Logger log = LoggerFactory.getLogger(CacheContent.class);
    private String charEncoding;
    private String contentType;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private InputStream dataInputStream;
    private TempSink tempSink;

    public CacheContent(String charEncoding, String contentType, Map<String, List<String>> headers, InputStream dataInputStream) {
        this.charEncoding = charEncoding;
        this.contentType = contentType;
        this.headers = headers;
        this.dataInputStream = dataInputStream;
    }

    public CacheContent() {
    }

    public CacheContent build(HttpCacheServletResponseWrapper responseWrapper) throws HttpCacheDataStreamException {
        CacheContent cacheContent = new CacheContent();
        this.charEncoding = responseWrapper.getCharacterEncoding();
        this.contentType = responseWrapper.getContentType();
        ArrayList headerNames = new ArrayList();
        headerNames.addAll(responseWrapper.getHeaderNames());
        for (String headerName : headerNames) {
            ArrayList values = new ArrayList();
            values.addAll(responseWrapper.getHeaders(headerName));
            this.headers.put(headerName, values);
        }
        this.tempSink = responseWrapper.getTempSink();
        this.dataInputStream = responseWrapper.getTempSink().createInputStream();
        return this;
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public InputStream getInputDataStream() {
        return this.dataInputStream;
    }

    public TempSink getTempSink() {
        return this.tempSink;
    }
}

