/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.http.headers.impl;

import com.adobe.acs.commons.http.headers.impl.AbstractExpiresHeaderFilter;
import java.util.Calendar;
import java.util.Dictionary;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;

@Component(label="ACS AEM Commons - Dispatcher Expires Header - Weekly", description="Adds an Expires header to content to enable Dispatcher TTL support.", immediate=false, metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Service
@Properties(value={@Property(label="Filter Patterns", description="Patterns on which to apply this Expires rule.", cardinality=0x7FFFFFFF, name="filter.pattern", propertyPrivate=false, value={}), @Property(label="Expires Time", description="Time of day at which resources will expire. Must match SimpleDateFormat of 'HH:mm'.", name="expires.time", propertyPrivate=false), @Property(name="webconsole.configurationFactory.nameHint", value={"Expires Each week on day {expires.day-of-week} at {expires.time} for Patterns: [{filter.pattern}]"}, propertyPrivate=true)})
public class WeeklyExpiresHeaderFilter
extends AbstractExpiresHeaderFilter {
    @Property(label="Expires Day", description="Day of week on which content expires.", options={@PropertyOption(name="1", value="Sunday"), @PropertyOption(name="2", value="Monday"), @PropertyOption(name="3", value="Tuesday"), @PropertyOption(name="4", value="Wednesday"), @PropertyOption(name="5", value="Thursday"), @PropertyOption(name="6", value="Friday"), @PropertyOption(name="7", value="Saturday")})
    static final String PROP_EXPIRES_DAY_OF_WEEK = "expires.day-of-week";
    private int dayOfWeek;

    @Override
    protected void adjustExpires(Calendar next) {
        next.set(7, this.dayOfWeek);
        if (next.before(Calendar.getInstance())) {
            next.add(7, next.getMaximum(7));
        }
    }

    @Override
    protected void doActivate(ComponentContext context) throws Exception {
        super.doActivate(context);
        Dictionary props = context.getProperties();
        this.dayOfWeek = PropertiesUtil.toInteger(props.get(PROP_EXPIRES_DAY_OF_WEEK), (int)-1);
        if (this.dayOfWeek < 1 || this.dayOfWeek > 7) {
            throw new ConfigurationException(PROP_EXPIRES_DAY_OF_WEEK, "Day of week must be valid value from Calendar DAY_OF_WEEK attribute.");
        }
    }
}

