/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.http.headers.impl;

import com.adobe.acs.commons.http.headers.impl.AbstractExpiresHeaderFilter;
import java.util.Calendar;
import java.util.Dictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;

@Component(label="ACS AEM Commons - Dispatcher Expires Header - Monthly", description="Adds an Expires header to content to enable Dispatcher TTL support.", immediate=false, metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Service
@Properties(value={@Property(label="Filter Patterns", description="Patterns on which to apply this Expires rule.", cardinality=0x7FFFFFFF, name="filter.pattern", propertyPrivate=false, value={}), @Property(label="Expires Time", description="Time of day at which resources will expire. Must match SimpleDateFormat of 'HH:mm'.", name="expires.time", propertyPrivate=false), @Property(name="webconsole.configurationFactory.nameHint", value={"Expires each month on the {expires.day-of-month} day at {expires.time} for Patterns: [{filter.pattern}]"}, propertyPrivate=true)})
public class MonthlyExpiresHeaderFilter
extends AbstractExpiresHeaderFilter {
    private static final String LAST = "LAST";
    @Property(label="Expires Day", description="Day of month on which content expires. Use keyword 'LAST' to enable last day of month, as setting to 31 will generate errors in February.")
    static final String PROP_EXPIRES_DAY_OF_MONTH = "expires.day-of-month";
    private String dayOfMonth;

    @Override
    protected void adjustExpires(Calendar next) {
        if (StringUtils.equalsIgnoreCase((CharSequence)LAST, (CharSequence)this.dayOfMonth)) {
            next.set(5, next.getActualMaximum(5));
        } else {
            next.set(5, Integer.parseInt(this.dayOfMonth));
        }
        if (next.before(Calendar.getInstance())) {
            next.add(2, 1);
        }
    }

    @Override
    protected void doActivate(ComponentContext context) throws Exception {
        super.doActivate(context);
        Dictionary props = context.getProperties();
        this.dayOfMonth = PropertiesUtil.toString(props.get(PROP_EXPIRES_DAY_OF_MONTH), null);
        if (StringUtils.isBlank((CharSequence)this.dayOfMonth)) {
            throw new ConfigurationException(PROP_EXPIRES_DAY_OF_MONTH, "Day of month must be specified.");
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)LAST, (CharSequence)this.dayOfMonth)) {
            try {
                int intDay = Integer.parseInt(this.dayOfMonth);
                Calendar test = Calendar.getInstance();
                if (intDay < test.getMinimum(5)) {
                    throw new ConfigurationException(PROP_EXPIRES_DAY_OF_MONTH, "Day of month is smaller than minimum allowed value.");
                }
                if (intDay > test.getActualMaximum(5)) {
                    throw new ConfigurationException(PROP_EXPIRES_DAY_OF_MONTH, "Day of month is larger than least maximum allowed value.");
                }
            }
            catch (NumberFormatException ex) {
                throw new ConfigurationException(PROP_EXPIRES_DAY_OF_MONTH, "Day of month is not a valid value.");
            }
        }
    }
}

