/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.forms.helpers.impl;

import com.adobe.acs.commons.forms.Form;
import com.adobe.acs.commons.forms.helpers.FormHelper;
import com.adobe.acs.commons.forms.helpers.ForwardAsGetFormHelper;
import com.adobe.acs.commons.forms.helpers.impl.AbstractFormHelperImpl;
import com.adobe.acs.commons.forms.helpers.impl.synthetics.SyntheticSlingHttpServletGetRequest;
import com.adobe.acs.commons.forms.impl.FormImpl;
import com.day.cq.wcm.api.Page;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(inherit=true)
@Property(label="Service Ranking", name="service.ranking", intValue={1000})
@Service(value={FormHelper.class, ForwardAsGetFormHelper.class})
public class ForwardAsGetFormHelperImpl
extends AbstractFormHelperImpl
implements ForwardAsGetFormHelper {
    private static final Logger log = LoggerFactory.getLogger(ForwardAsGetFormHelperImpl.class);
    private static final String CQ_PAGE_RESOURCE_TYPE = "cq/Page";

    @Override
    public final Form getForm(String formName, SlingHttpServletRequest request) {
        if (this.doHandlePost(formName, request)) {
            return this.getPostForm(formName, request);
        }
        String key = this.getLookupKey(formName);
        Object obj = request.getAttribute(key);
        if (obj instanceof Form) {
            return this.getProtectedForm((Form)obj);
        }
        log.info("Unable to find Form in Request attribute: [ {} => {} ]", (Object)key, obj);
        return new FormImpl(formName, request.getResource().getPath());
    }

    @Override
    public Form getForm(String formName, SlingHttpServletRequest request, SlingHttpServletResponse response) {
        return this.getForm(formName, request);
    }

    @Override
    public final void forwardAsGet(Form form, Page page, SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setReplaceSelectors("");
        options.setForceResourceType(CQ_PAGE_RESOURCE_TYPE);
        this.forwardAsGet(form, page, request, response, options);
    }

    @Override
    public final void forwardAsGet(Form form, Page page, SlingHttpServletRequest request, SlingHttpServletResponse response, RequestDispatcherOptions options) throws ServletException, IOException {
        options.setForceResourceType(CQ_PAGE_RESOURCE_TYPE);
        String path = page.getPath() + ".html";
        this.forwardAsGet(form, path, request, response, options);
    }

    @Override
    public final void forwardAsGet(Form form, Resource resource, SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        this.forwardAsGet(form, resource, request, response, options);
    }

    @Override
    public final void forwardAsGet(Form form, Resource resource, SlingHttpServletRequest request, SlingHttpServletResponse response, RequestDispatcherOptions options) throws ServletException, IOException {
        String path = resource.getPath();
        this.forwardAsGet(form, path, request, response, options);
    }

    @Override
    public final void forwardAsGet(Form form, String path, SlingHttpServletRequest request, SlingHttpServletResponse response, RequestDispatcherOptions options) throws ServletException, IOException {
        this.setRequestAttrForm(request, form);
        SyntheticSlingHttpServletGetRequest syntheticRequest = new SyntheticSlingHttpServletGetRequest(request);
        if (log.isDebugEnabled()) {
            log.debug("Forwarding as GET to path: {} ", (Object)path);
            log.debug("Forwarding as GET w/ replace selectors: {} ", (Object)options.getReplaceSelectors());
            log.debug("Forwarding as GET w/ add selectors: {} ", (Object)options.getAddSelectors());
            log.debug("Forwarding as GET w/ suffix: {} ", (Object)options.getReplaceSuffix());
            log.debug("Forwarding as GET w/ forced resourceType: {} ", (Object)options.getForceResourceType());
        }
        request.getRequestDispatcher(path, options).forward((ServletRequest)syntheticRequest, (ServletResponse)response);
    }

    @Override
    public final void renderForm(Form form, Page page, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException, JSONException {
        String formSelector = this.getFormSelector(request);
        this.renderOtherForm(form, page, formSelector, request, response);
    }

    @Override
    public final void renderForm(Form form, Resource resource, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException, JSONException {
        String formSelector = this.getFormSelector(request);
        this.renderOtherForm(form, resource, formSelector, request, response);
    }

    @Override
    public final void renderForm(Form form, String path, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException, JSONException {
        String formSelector = this.getFormSelector(request);
        this.renderOtherForm(form, path, formSelector, request, response);
    }

    @Override
    public final void renderOtherForm(Form form, String path, String formSelector, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException, JSONException {
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        if (StringUtils.isNotBlank((String)formSelector)) {
            options.setReplaceSelectors(formSelector);
        }
        this.forwardAsGet(form, path, request, response, options);
    }

    @Override
    public final void renderOtherForm(Form form, Page page, String formSelector, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException, JSONException {
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        if (StringUtils.isNotBlank((String)formSelector)) {
            options.setReplaceSelectors(formSelector);
        }
        this.forwardAsGet(form, page, request, response, options);
    }

    @Override
    public final void renderOtherForm(Form form, Resource resource, String formSelector, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException, JSONException {
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        if (StringUtils.isNotBlank((String)formSelector)) {
            options.setReplaceSelectors(formSelector);
        }
        this.forwardAsGet(form, resource, request, response, options);
    }

    protected final String getLookupKey(String formName) {
        return REQUEST_ATTR_FORM_KEY + formName;
    }

    protected final void setRequestAttrForm(SlingHttpServletRequest request, Form form) {
        String key = this.getLookupKey(form.getName());
        request.setAttribute(key, (Object)form);
    }
}

