/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.errorpagehandler.impl;

import com.adobe.acs.commons.errorpagehandler.ErrorPageHandlerService;
import com.adobe.acs.commons.errorpagehandler.cache.impl.ErrorPageCache;
import com.adobe.acs.commons.errorpagehandler.cache.impl.ErrorPageCacheImpl;
import com.adobe.acs.commons.errorpagehandler.impl.StringLengthComparator;
import com.adobe.acs.commons.util.InfoWriter;
import com.adobe.acs.commons.wcm.ComponentHelper;
import com.day.cq.commons.PathInfo;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.search.QueryBuilder;
import com.day.cq.widget.HtmlLibraryManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.auth.core.AuthUtil;
import org.apache.sling.commons.auth.Authenticator;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Error Page Handler", description="Error Page Handling module which facilitates the resolution of errors against author-able pages for discrete content trees.", immediate=false, metatype=true)
@Service
public final class ErrorPageHandlerImpl
implements ErrorPageHandlerService {
    private static final Logger log = LoggerFactory.getLogger(ErrorPageHandlerImpl.class);
    public static final String DEFAULT_ERROR_PAGE_NAME = "errors";
    public static final String ERROR_PAGE_PROPERTY = "errorPages";
    private static final String REDIRECT_TO_LOGIN = "redirect-to-login";
    private static final String RESPOND_WITH_404 = "respond-with-404";
    private static final boolean DEFAULT_ENABLED = true;
    private boolean enabled = true;
    @Property(label="Enable", description="Enables/Disables the error handler. [Required]", boolValue={true})
    private static final String PROP_ENABLED = "enabled";
    private static final String DEFAULT_ERROR_PAGE_EXTENSION = "html";
    private String errorPageExtension = "html";
    @Property(label="Error page extension", description="Examples: html, htm, xml, json. [Optional] [Default: html]", value={"html"})
    private static final String PROP_ERROR_PAGE_EXTENSION = "error-page.extension";
    private static final String DEFAULT_FALLBACK_ERROR_NAME = "500";
    private String fallbackErrorName = "500";
    @Property(label="Fallback error page name", description="Error page name (not path) to use if a valid Error Code/Error Servlet Name cannot be retrieved from the Request. [Required] [Default: 500]", value={"500"})
    private static final String PROP_FALLBACK_ERROR_NAME = "error-page.fallback-name";
    private static final String DEFAULT_SYSTEM_ERROR_PAGE_PATH_DEFAULT = "";
    private String systemErrorPagePath = "";
    @Property(label="System error page", description="Absolute path to system Error page resource to serve if no other more appropriate error pages can be found. Does not include extension. [Optional... but highly recommended]", value={""})
    private static final String PROP_ERROR_PAGE_PATH = "error-page.system-path";
    private static final String[] DEFAULT_SEARCH_PATHS = new String[0];
    @Property(label="Error page paths", description="List of inclusive content trees under which error pages may reside, along with the name of the the default error page for the content tree. This is a fallback/less powerful option to adding the ./errorPages property to CQ Page property dialogs. Example: /content/geometrixx/en:errors [Optional]", cardinality=0x7FFFFFFF)
    private static final String PROP_SEARCH_PATHS = "paths";
    private static final String DEFAULT_NOT_FOUND_DEFAULT_BEHAVIOR = "respond-with-404";
    private String notFoundBehavior = "respond-with-404";
    @Property(label="Not Found Behavior", description="Default resource not found behavior. [Default: Respond with 404]", options={@PropertyOption(value="Redirect to Login", name="redirect-to-login"), @PropertyOption(value="Respond with 404", name="respond-with-404")})
    private static final String PROP_NOT_FOUND_DEFAULT_BEHAVIOR = "not-found.behavior";
    private static final String[] DEFAULT_NOT_FOUND_EXCLUSION_PATH_PATTERNS = new String[0];
    private ArrayList<Pattern> notFoundExclusionPatterns = new ArrayList();
    @Property(label="Not Found Exclusions", description="Regex path patterns that will act in the \"other\" (redirect-to-login vs.  respond-with-404) way to the \"Not Found Behavior\". This allows the usual Not Found behavior to be defined via \"not-found.behavior\" with specific exclusions defined here. [Optional]", cardinality=0x7FFFFFFF)
    private static final String PROP_NOT_FOUND_EXCLUSION_PATH_PATTERNS = "not-found.exclusion-path-patterns";
    private static final int DEFAULT_TTL = 300;
    private static final boolean DEFAULT_SERVE_AUTHENTICATED_FROM_CACHE = false;
    @Property(label="Serve authenticated from cache", description="Serve authenticated requests from the error page cache. [ Default: false ]", boolValue={false})
    private static final String PROP_SERVE_AUTHENTICATED_FROM_CACHE = "cache.serve-authenticated";
    private static final String LEGACY_PROP_SERVE_AUTHENTICATED_FROM_CACHE = "serve-authenticated-from-cache";
    @Property(label="TTL (in seconds)", description="TTL for each cache entry in seconds. [ Default: 300 ]", intValue={300})
    private static final String PROP_TTL = "cache.ttl";
    private static final String LEGACY_PROP_TTL = "ttl";
    private static final boolean DEFAULT_ERROR_IMAGES_ENABLED = false;
    private boolean errorImagesEnabled = false;
    @Property(label="Enable placeholder images", description="Enable image error handling  [ Default: false ]", boolValue={false})
    private static final String PROP_ERROR_IMAGES_ENABLED = "error-images.enabled";
    private static final String DEFAULT_ERROR_IMAGE_PATH = ".img.png";
    private String errorImagePath = ".img.png";
    @Property(label="Error image path/selector", description="Accepts a selectors.extension (ex. `.img.png`) absolute, or relative path. If an extension or relative path, this value is applied to the resolved error page. Note: This concatenated path must resolve to a nt:file else a 200 response will be sent. [ Optional ] [ Default: .img.png ]", value={".img.png"})
    private static final String PROP_ERROR_IMAGE_PATH = "error-images.path";
    private static final String[] DEFAULT_ERROR_IMAGE_EXTENSIONS = new String[]{"jpg", "jpeg", "png", "gif"};
    private String[] errorImageExtensions = DEFAULT_ERROR_IMAGE_EXTENSIONS;
    @Property(label="Error image extensions", description="List of valid image extensions (no proceeding .) to handle. Example: 'png' [ Optional ] [ Default: png, jpeg, jpeg, gif ]", cardinality=0x7FFFFFFF, value={"png", "jpeg", "jpg", "gif"})
    private static final String PROP_ERROR_IMAGE_EXTENSIONS = "error-images.extensions";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private QueryBuilder queryBuilder;
    @Reference
    private Authenticator authenticator;
    @Reference
    private ComponentHelper componentHelper;
    private ErrorPageCache cache;
    private SortedMap<String, String> pathMap = new TreeMap<String, String>();
    private ServiceRegistration cacheRegistration;

    @Override
    public String findErrorPage(SlingHttpServletRequest request, Resource errorResource) {
        HierarchyNodeInheritanceValueMap pageProperties;
        Resource parentContentResource;
        if (!this.isEnabled()) {
            return null;
        }
        Resource page = null;
        ResourceResolver resourceResolver = errorResource.getResourceResolver();
        String errorResourcePath = errorResource.getPath();
        String errorsPath = null;
        Resource parent = this.findFirstRealParentOrSelf(request, errorResource);
        if (parent != null && (parentContentResource = parent.getChild("jcr:content")) != null && (errorsPath = (String)(pageProperties = new HierarchyNodeInheritanceValueMap(parentContentResource)).getInherited(ERROR_PAGE_PROPERTY, String.class)) == null) {
            for (Map.Entry<String, String> mapPage : this.pathMap.entrySet()) {
                if (!errorResourcePath.startsWith(mapPage.getKey())) continue;
                errorsPath = mapPage.getValue();
                break;
            }
        }
        if (StringUtils.isNotBlank(errorsPath)) {
            log.debug("Best matching errors path for request is: {}", errorsPath);
            String errorPath = errorsPath + "/" + this.getErrorPageName(request);
            page = this.getResource(resourceResolver, errorPath);
            if (page == null && StringUtils.isNotBlank((String)errorsPath)) {
                page = resourceResolver.resolve(errorsPath);
            }
        }
        String errorPagePath = null;
        if (page == null || ResourceUtil.isNonExistingResource(page)) {
            if (this.hasSystemErrorPage()) {
                errorPagePath = this.getSystemErrorPagePath();
            }
        } else {
            errorPagePath = page.getPath();
        }
        if (this.errorImagesEnabled && this.isImageRequest(request)) {
            if (StringUtils.startsWith((String)this.errorImagePath, (String)"/")) {
                return this.errorImagePath;
            }
            if (StringUtils.isNotBlank((String)errorPagePath)) {
                if (StringUtils.startsWith((String)this.errorImagePath, (String)".")) {
                    String selectorErrorImagePath = errorPagePath + this.errorImagePath;
                    log.debug("Using selector-based error image: {}", (Object)selectorErrorImagePath);
                    return selectorErrorImagePath;
                }
                String relativeErrorImagePath = errorPagePath + "/" + StringUtils.removeStart((String)this.errorImagePath, (String)"/");
                log.debug("Using relative path-based error image: {}", (Object)relativeErrorImagePath);
                return relativeErrorImagePath;
            }
            log.warn("Error image path found, but no error page could be found so relative path cannot be applied: {}", (Object)this.errorImagePath);
        } else {
            if (StringUtils.isNotBlank((String)errorPagePath)) {
                errorPagePath = StringUtils.stripToNull((String)this.applyExtension(errorPagePath));
                log.debug("Using resolved error page: {}", (Object)errorPagePath);
                return errorPagePath;
            }
            log.debug("ACS AEM Commons Error Page Handler is enabled but mis-configured. A valid error image handler nor a valid error page could be found.");
        }
        return null;
    }

    private Resource getResource(ResourceResolver resourceResolver, String path) {
        Resource resource = resourceResolver.getResource(path);
        if (resource != null && !ResourceUtil.isNonExistingResource((Resource)resource)) {
            return resource;
        }
        return null;
    }

    @Override
    public int getStatusCode(SlingHttpServletRequest request) {
        Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        if (statusCode != null) {
            return statusCode;
        }
        return 500;
    }

    @Override
    public String getErrorPageName(SlingHttpServletRequest request) {
        String servletName = String.valueOf(this.getStatusCode(request));
        servletName = StringUtils.lowerCase((String)servletName);
        log.debug("Error page name to (try to) use: {} ", (Object)servletName);
        return servletName;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasSystemErrorPage() {
        return StringUtils.isNotBlank((String)this.getSystemErrorPagePath());
    }

    public String getSystemErrorPagePath() {
        return StringUtils.strip((String)this.systemErrorPagePath);
    }

    public String getErrorPagesPath(String rootPath, Map<String, String> errorPagesMap) {
        if (errorPagesMap.containsKey(rootPath)) {
            return errorPagesMap.get(rootPath);
        }
        return null;
    }

    private boolean isImageRequest(SlingHttpServletRequest request) {
        if (StringUtils.isBlank((String)this.errorImagePath)) {
            log.warn("ACS AEM Commons error page handler enabled to handle error images, but no error image path was provided.");
            return false;
        }
        String extension = StringUtils.stripToEmpty((String)StringUtils.lowerCase((String)request.getRequestPathInfo().getExtension()));
        return ArrayUtils.contains((Object[])this.errorImageExtensions, (Object)extension);
    }

    private Resource findFirstRealParentOrSelf(SlingHttpServletRequest request, Resource errorResource) {
        if (errorResource == null) {
            log.debug("Error resource is null");
            return null;
        }
        log.trace("Finding first real parent for [ {} ]", (Object)errorResource.getPath());
        ResourceResolver resourceResolver = errorResource.getResourceResolver();
        String path = StringUtils.substringBefore((String)errorResource.getPath(), (String)"jcr:content");
        Resource resource = errorResource;
        if (!StringUtils.equals((String)path, (String)errorResource.getPath())) {
            resource = resourceResolver.resolve((HttpServletRequest)request, path);
        }
        if (!ResourceUtil.isNonExistingResource((Resource)resource)) {
            log.debug("Found real aggregate resource at [ {} }", (Object)resource.getPath());
            return resource;
        }
        Resource parent = resource.getParent();
        if (parent != null) {
            log.debug("Found real aggregate resource via getParent() at [ {} ]", (Object)parent.getPath());
            return parent;
        }
        PathInfo pathInfo = new PathInfo(resource.getPath());
        Object[] parts = StringUtils.split((String)pathInfo.getResourcePath(), (char)'/');
        for (int i = parts.length - 1; i >= 0; --i) {
            Object[] tmpArray = (String[])ArrayUtils.subarray((Object[])parts, (int)0, (int)i);
            String candidatePath = "/".concat(StringUtils.join((Object[])tmpArray, (char)'/'));
            Resource candidateResource = resourceResolver.resolve((HttpServletRequest)request, candidatePath);
            if (candidateResource == null || ResourceUtil.isNonExistingResource((Resource)candidateResource)) continue;
            log.debug("Found first real aggregate parent via path look-up at [ {} ]", (Object)candidateResource.getPath());
            return candidateResource;
        }
        log.debug("Could not find real parent for [ {} ]", (Object)errorResource.getPath());
        return null;
    }

    private String applyExtension(String path) {
        if (path == null) {
            return null;
        }
        if (StringUtils.isBlank((String)this.errorPageExtension)) {
            return path;
        }
        return StringUtils.stripToEmpty((String)path).concat(".").concat(this.errorPageExtension);
    }

    protected boolean isAnonymousRequest(SlingHttpServletRequest request) {
        return request.getAuthType() == null || request.getRemoteUser() == null;
    }

    protected boolean authenticateRequest(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        if (this.authenticator == null) {
            log.warn("Cannot login: Missing Authenticator service");
            return false;
        }
        this.authenticator.login((HttpServletRequest)request, (HttpServletResponse)response);
        return true;
    }

    @Override
    public boolean doHandle404(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        String path = request.getResource().getPath();
        if (StringUtils.isBlank((String)path)) {
            path = request.getPathInfo();
        }
        if (log.isDebugEnabled()) {
            InfoWriter iw = new InfoWriter();
            iw.title("ACS AEM Commons - Error Page Handler 404 Handling");
            iw.message("Status code: {}", this.getStatusCode(request));
            iw.message("Is anonymous: {}", this.isAnonymousRequest(request));
            iw.message("Is browser request: {}", AuthUtil.isBrowserRequest((HttpServletRequest)request));
            iw.message("Is redirect to login page: {}", this.isRedirectToLogin(path));
            iw.message("Default 404 Behavior: {}", this.notFoundBehavior);
            iw.line();
            log.debug(iw.toString());
        }
        if (this.getStatusCode(request) == 404 && this.isAnonymousRequest(request) && AuthUtil.isBrowserRequest((HttpServletRequest)request) && this.isRedirectToLogin(path)) {
            return !this.authenticateRequest(request, response);
        }
        log.debug("Allow error page handler to handle request");
        return true;
    }

    private boolean isRedirectToLogin(String path) {
        log.debug("Not Found Behavior: {}", (Object)this.notFoundBehavior);
        if (StringUtils.equals((String)REDIRECT_TO_LOGIN, (String)this.notFoundBehavior)) {
            for (Pattern p : this.notFoundExclusionPatterns) {
                Matcher m = p.matcher(path);
                if (!m.matches()) continue;
                log.debug("Path is an exclusion to \"redirect to login\" ~> \"respond w/ 404\"");
                return false;
            }
            log.debug("Path did NOT match exclusions for \"redirect to login\" ~> \"redirect to login\"");
            return true;
        }
        for (Pattern p : this.notFoundExclusionPatterns) {
            Matcher m = p.matcher(path);
            if (!m.matches()) continue;
            log.debug("Path is an exclusion to \"respond w/ 404\" ~> \"redirect to login\"");
            return true;
        }
        log.debug("Path did NOT match exclusions for \"respond w/ 404\" ~> \"respond w/ 404\"");
        return false;
    }

    @Override
    public String getException(SlingHttpServletRequest request) {
        StringWriter stringWriter = new StringWriter();
        if (request.getAttribute("javax.servlet.error.exception") instanceof Throwable) {
            Throwable throwable = (Throwable)request.getAttribute("javax.servlet.error.exception");
            if (throwable == null) {
                return DEFAULT_SYSTEM_ERROR_PAGE_PATH_DEFAULT;
            }
            if (throwable instanceof ServletException) {
                ServletException se = (ServletException)throwable;
                while (se.getRootCause() != null && (throwable = se.getRootCause()) instanceof ServletException) {
                    se = (ServletException)throwable;
                }
            }
            throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        }
        return stringWriter.toString();
    }

    @Override
    public String getRequestProgress(SlingHttpServletRequest request) {
        StringWriter stringWriter = new StringWriter();
        if (request != null) {
            RequestProgressTracker tracker = request.getRequestProgressTracker();
            tracker.dump(new PrintWriter((Writer)stringWriter, true));
        }
        return stringWriter.toString();
    }

    @Override
    public void resetRequestAndResponse(SlingHttpServletRequest request, SlingHttpServletResponse response, int statusCode) {
        request.setAttribute(HtmlLibraryManager.class.getName() + ".included", new HashSet());
        response.reset();
        response.setContentType("text/html");
        response.setStatus(statusCode);
    }

    private AbstractMap.SimpleEntry<String, String> toSimpleEntry(String value, String separator) {
        String[] tmp = StringUtils.split((String)value, (String)separator);
        if (tmp == null) {
            return null;
        }
        if (tmp.length == 2) {
            return new AbstractMap.SimpleEntry<String, String>(tmp[0], tmp[1]);
        }
        return null;
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.configure(componentContext);
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.enabled = false;
        if (this.cacheRegistration != null) {
            this.cacheRegistration.unregister();
            this.cacheRegistration = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(ComponentContext componentContext) {
        Dictionary config = componentContext.getProperties();
        String legacyPrefix = "prop.";
        this.enabled = PropertiesUtil.toBoolean(config.get(PROP_ENABLED), (boolean)PropertiesUtil.toBoolean(config.get("prop.enabled"), (boolean)true));
        this.systemErrorPagePath = PropertiesUtil.toString(config.get(PROP_ERROR_PAGE_PATH), (String)PropertiesUtil.toString(config.get("prop.error-page.system-path"), (String)DEFAULT_SYSTEM_ERROR_PAGE_PATH_DEFAULT));
        this.errorPageExtension = PropertiesUtil.toString(config.get(PROP_ERROR_PAGE_EXTENSION), (String)PropertiesUtil.toString(config.get("prop.error-page.extension"), (String)DEFAULT_ERROR_PAGE_EXTENSION));
        this.fallbackErrorName = PropertiesUtil.toString(config.get(PROP_FALLBACK_ERROR_NAME), (String)PropertiesUtil.toString(config.get("prop.error-page.fallback-name"), (String)DEFAULT_FALLBACK_ERROR_NAME));
        this.pathMap = this.configurePathMap(PropertiesUtil.toStringArray(config.get(PROP_SEARCH_PATHS), (String[])PropertiesUtil.toStringArray(config.get("prop.paths"), (String[])DEFAULT_SEARCH_PATHS)));
        this.notFoundBehavior = PropertiesUtil.toString(config.get(PROP_NOT_FOUND_DEFAULT_BEHAVIOR), (String)"respond-with-404");
        Object[] tmpNotFoundExclusionPatterns = PropertiesUtil.toStringArray(config.get(PROP_NOT_FOUND_EXCLUSION_PATH_PATTERNS), (String[])DEFAULT_NOT_FOUND_EXCLUSION_PATH_PATTERNS);
        this.notFoundExclusionPatterns = new ArrayList();
        for (String string : tmpNotFoundExclusionPatterns) {
            this.notFoundExclusionPatterns.add(Pattern.compile(string));
        }
        int ttl = PropertiesUtil.toInteger(config.get(PROP_TTL), (int)PropertiesUtil.toInteger((Object)LEGACY_PROP_TTL, (int)300));
        boolean serveAuthenticatedFromCache = PropertiesUtil.toBoolean(config.get(PROP_SERVE_AUTHENTICATED_FROM_CACHE), (boolean)PropertiesUtil.toBoolean((Object)LEGACY_PROP_SERVE_AUTHENTICATED_FROM_CACHE, (boolean)false));
        try {
            this.cache = new ErrorPageCacheImpl(ttl, serveAuthenticatedFromCache);
            Hashtable<String, String> serviceProps = new Hashtable<String, String>();
            ((Dictionary)serviceProps).put("jmx.objectname", "com.adobe.acs.commons:type=ErrorPageHandlerCache");
            this.cacheRegistration = componentContext.getBundleContext().registerService(DynamicMBean.class.getName(), (Object)this.cache, serviceProps);
        }
        catch (NotCompliantMBeanException e) {
            log.error("Unable to create cache", (Throwable)e);
        }
        this.errorImagesEnabled = PropertiesUtil.toBoolean(config.get(PROP_ERROR_IMAGES_ENABLED), (boolean)false);
        this.errorImagePath = PropertiesUtil.toString(config.get(PROP_ERROR_IMAGE_PATH), (String)DEFAULT_ERROR_IMAGE_PATH);
        if (StringUtils.startsWith((String)this.errorImagePath, (String)"/")) {
            ResourceResolver adminResourceResolver = null;
            try {
                PathInfo pathInfo;
                adminResourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                Resource resource = adminResourceResolver.resolve(this.errorImagePath);
                if (resource != null && resource.isResourceType("nt:file") && (!StringUtils.equals((String)"img", (String)(pathInfo = new PathInfo(this.errorImagePath)).getSelectorString()) || StringUtils.isBlank((String)pathInfo.getExtension()))) {
                    log.warn("Absolute Error Image Path paths to nt:files should have '.img.XXX' selector.extension");
                }
            }
            catch (LoginException loginException) {
                log.error("Could not get admin resource resolver to inspect validity of absolute errorImagePath");
            }
            finally {
                if (adminResourceResolver != null) {
                    adminResourceResolver.close();
                }
            }
        }
        this.errorImageExtensions = PropertiesUtil.toStringArray(config.get(PROP_ERROR_IMAGE_EXTENSIONS), (String[])DEFAULT_ERROR_IMAGE_EXTENSIONS);
        for (int i = 0; i < this.errorImageExtensions.length; ++i) {
            this.errorImageExtensions[i] = StringUtils.lowerCase((String)this.errorImageExtensions[i], (Locale)Locale.ENGLISH);
        }
        StringWriter sw = new StringWriter();
        PrintWriter printWriter = new PrintWriter(sw);
        printWriter.println();
        printWriter.printf("Enabled: %s", this.enabled).println();
        printWriter.printf("System Error Page Path: %s", this.systemErrorPagePath).println();
        printWriter.printf("Error Page Extension: %s", this.errorPageExtension).println();
        printWriter.printf("Fallback Error Page Name: %s", this.fallbackErrorName).println();
        printWriter.printf("Resource Not Found - Behavior: %s", this.notFoundBehavior).println();
        printWriter.printf("Resource Not Found - Exclusion Path Patterns %s", Arrays.toString(tmpNotFoundExclusionPatterns)).println();
        printWriter.printf("Cache - TTL: %s", ttl).println();
        printWriter.printf("Cache - Serve Authenticated: %s", serveAuthenticatedFromCache).println();
        printWriter.printf("Error Images - Enabled: %s", this.errorImagesEnabled).println();
        printWriter.printf("Error Images - Path: %s", this.errorImagePath).println();
        printWriter.printf("Error Images - Extensions: %s", Arrays.toString(this.errorImageExtensions)).println();
        log.debug(sw.toString());
    }

    private SortedMap<String, String> configurePathMap(String[] paths) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(new StringLengthComparator());
        for (String path : paths) {
            AbstractMap.SimpleEntry<String, String> tmp;
            if (StringUtils.isBlank((String)path) || (tmp = this.toSimpleEntry(path, ":")) == null) continue;
            String key = StringUtils.strip((String)tmp.getKey());
            String val = StringUtils.strip((String)tmp.getValue());
            if (StringUtils.isBlank((String)key) || !StringUtils.startsWith((String)key, (String)"/")) continue;
            if (StringUtils.isBlank((String)val)) {
                val = key + "/" + DEFAULT_ERROR_PAGE_NAME;
            } else if (StringUtils.equals((String)val, (String)".")) {
                val = key;
            } else if (!StringUtils.startsWith((String)val, (String)"/")) {
                val = key + "/" + val;
            }
            sortedMap.put(key, val);
        }
        return sortedMap;
    }

    @Override
    public void includeUsingGET(SlingHttpServletRequest request, SlingHttpServletResponse response, String path) {
        if (this.cache == null || this.errorImagesEnabled && this.isImageRequest(request)) {
            RequestDispatcher dispatcher = request.getRequestDispatcher(path);
            if (dispatcher != null) {
                try {
                    dispatcher.include((ServletRequest)new GetRequest(request), (ServletResponse)response);
                }
                catch (Exception e) {
                    log.debug("Exception swallowed while including error page", (Throwable)e);
                }
            }
        } else {
            String responseData = this.cache.get(path, (SlingHttpServletRequest)new GetRequest(request), response);
            try {
                response.getWriter().write(responseData);
            }
            catch (Exception e) {
                log.info("Exception swallowed while including error page", (Throwable)e);
            }
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    protected void unbindAuthenticator(Authenticator authenticator) {
        if (this.authenticator == authenticator) {
            this.authenticator = null;
        }
    }

    protected void bindComponentHelper(ComponentHelper componentHelper) {
        this.componentHelper = componentHelper;
    }

    protected void unbindComponentHelper(ComponentHelper componentHelper) {
        if (this.componentHelper == componentHelper) {
            this.componentHelper = null;
        }
    }

    private static class GetRequest
    extends SlingHttpServletRequestWrapper {
        public GetRequest(SlingHttpServletRequest wrappedRequest) {
            super(wrappedRequest);
        }

        public String getMethod() {
            return "GET";
        }
    }
}

