/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.email.impl;

import com.adobe.acs.commons.email.EmailService;
import com.day.cq.commons.mail.MailTemplate;
import com.day.cq.mailer.MessageGateway;
import com.day.cq.mailer.MessageGatewayService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Session;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public final class EmailServiceImpl
implements EmailService {
    private static final Logger log = LoggerFactory.getLogger(EmailServiceImpl.class);
    @Reference
    private MessageGatewayService messageGatewayService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Override
    public List<String> sendEmail(String templatePath, Map<String, String> emailParams, String ... recipients) {
        ArrayList<String> failureList = new ArrayList<String>();
        if (recipients == null || recipients.length <= 0) {
            throw new IllegalArgumentException("Invalid Recipients");
        }
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>(recipients.length);
        for (String recipient : recipients) {
            try {
                addresses.add(new InternetAddress(recipient));
            }
            catch (AddressException e) {
                log.warn("Invalid email address {} passed to sendEmail(). Skipping.", (Object)recipient);
            }
        }
        InternetAddress[] iAddressRecipients = addresses.toArray(new InternetAddress[addresses.size()]);
        List<InternetAddress> failureInternetAddresses = this.sendEmail(templatePath, emailParams, iAddressRecipients);
        for (InternetAddress address : failureInternetAddresses) {
            failureList.add(address.toString());
        }
        return failureList;
    }

    @Override
    public List<InternetAddress> sendEmail(String templatePath, Map<String, String> emailParams, InternetAddress ... recipients) {
        ArrayList<InternetAddress> failureList = new ArrayList<InternetAddress>();
        if (recipients == null || recipients.length <= 0) {
            throw new IllegalArgumentException("Invalid Recipients");
        }
        MailTemplate mailTemplate = this.getMailTemplate(templatePath);
        Class<? extends Email> mailType = this.getMailType(templatePath);
        MessageGateway messageGateway = this.messageGatewayService.getGateway(mailType);
        for (InternetAddress address : recipients) {
            try {
                Email email = this.getEmail(mailTemplate, mailType, emailParams);
                email.setTo(Collections.singleton(address));
                messageGateway.send((Object)email);
            }
            catch (Exception e) {
                failureList.add(address);
                log.error("Error sending email to [ " + address + " ]", (Throwable)e);
            }
        }
        return failureList;
    }

    private Email getEmail(MailTemplate mailTemplate, Class<? extends Email> mailType, Map<String, String> params) throws EmailException, MessagingException, IOException {
        Email email = mailTemplate.getEmail(StrLookup.mapLookup(params), mailType);
        if (params.containsKey("senderEmailAddress") && params.containsKey("senderName")) {
            email.setFrom(params.get("senderEmailAddress"), params.get("senderName"));
        } else if (params.containsKey("senderEmailAddress")) {
            email.setFrom(params.get("senderEmailAddress"));
        }
        return email;
    }

    private Class<? extends Email> getMailType(String templatePath) {
        return templatePath.endsWith(".html") ? HtmlEmail.class : SimpleEmail.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailTemplate getMailTemplate(String templatePath) throws IllegalArgumentException {
        MailTemplate mailTemplate = null;
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            mailTemplate = MailTemplate.create((String)templatePath, (Session)((Session)resourceResolver.adaptTo(Session.class)));
            if (mailTemplate == null) {
                throw new IllegalArgumentException("Mail template path [ " + templatePath + " ] could not resolve to a valid template");
            }
        }
        catch (LoginException e) {
            log.error("Unable to obtain an administrative resource resolver to get the Mail Template at [ " + templatePath + " ]", (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
        return mailTemplate;
    }

    protected void bindMessageGatewayService(MessageGatewayService messageGatewayService) {
        this.messageGatewayService = messageGatewayService;
    }

    protected void unbindMessageGatewayService(MessageGatewayService messageGatewayService) {
        if (this.messageGatewayService == messageGatewayService) {
            this.messageGatewayService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

