/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.designer.impl;

import com.adobe.acs.commons.designer.DesignHtmlLibraryManager;
import com.adobe.acs.commons.designer.PageRegion;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.widget.HtmlLibraryManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public final class DesignHtmlLibraryManagerImpl
implements DesignHtmlLibraryManager {
    private static final Logger log = LoggerFactory.getLogger(DesignHtmlLibraryManagerImpl.class);
    @Reference
    private HtmlLibraryManager htmlLibraryManager;

    @Override
    public void writeCssInclude(SlingHttpServletRequest request, Design design, PageRegion pageRegion, Writer writer) throws IOException {
        this.htmlLibraryManager.writeCssInclude(request, writer, this.getCssLibraries(design, pageRegion));
    }

    @Override
    public void writeJsInclude(SlingHttpServletRequest request, Design design, PageRegion pageRegion, Writer writer) throws IOException {
        this.htmlLibraryManager.writeJsInclude(request, writer, this.getJsLibraries(design, pageRegion));
    }

    @Override
    public void writeIncludes(SlingHttpServletRequest request, Design design, PageRegion pageRegion, Writer writer) throws IOException {
        this.writeCssInclude(request, design, pageRegion, writer);
        this.writeJsInclude(request, design, pageRegion, writer);
    }

    @Override
    public String[] getCssLibraries(Design design, PageRegion pageRegion) {
        ValueMap cssProps = this.getPageRegionProperties(design, pageRegion);
        return (String[])cssProps.get("css", (Object)new String[0]);
    }

    @Override
    public String[] getJsLibraries(Design design, PageRegion pageRegion) {
        ValueMap jsProps = this.getPageRegionProperties(design, pageRegion);
        return (String[])jsProps.get("js", (Object)new String[0]);
    }

    @Override
    public String[] getLibraries(Design design, PageRegion pageRegion) {
        String[] cssLibs = this.getCssLibraries(design, pageRegion);
        String[] jsLibs = this.getJsLibraries(design, pageRegion);
        LinkedHashSet<String> libs = new LinkedHashSet<String>();
        libs.addAll(Arrays.asList(cssLibs));
        libs.addAll(Arrays.asList(jsLibs));
        return libs.toArray(new String[libs.size()]);
    }

    private ValueMap getPageRegionProperties(Design design, PageRegion pageRegion) {
        String relPath = "clientlibs/" + (Object)((Object)pageRegion);
        ValueMapDecorator empty = new ValueMapDecorator(new HashMap());
        if (design == null) {
            log.warn("Cannot find properties for `null` Design");
            return empty;
        }
        if (design.getContentResource() == null) {
            log.warn("Cannot find properties for `null` Design content resource");
            return empty;
        }
        if (design.getContentResource().getChild(relPath) == null) {
            log.warn("Could not find resource: {}", (Object)(design.getContentResource().getPath() + "/" + relPath));
            return empty;
        }
        return (ValueMap)design.getContentResource().getChild(relPath).adaptTo(ValueMap.class);
    }

    protected void bindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        this.htmlLibraryManager = htmlLibraryManager;
    }

    protected void unbindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        if (this.htmlLibraryManager == htmlLibraryManager) {
            this.htmlLibraryManager = null;
        }
    }
}

